/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.model.perceptron;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.corpus.document.sentence.Sentence;
import com.hankcs.hanlp.dictionary.other.CharTable;
import com.hankcs.hanlp.model.perceptron.PerceptronNERecognizer;
import com.hankcs.hanlp.model.perceptron.PerceptronPOSTagger;
import com.hankcs.hanlp.model.perceptron.PerceptronSegmenter;
import com.hankcs.hanlp.model.perceptron.model.LinearModel;
import com.hankcs.hanlp.tokenizer.lexical.AbstractLexicalAnalyzer;
import java.io.IOException;
import java.util.List;

public class PerceptronLexicalAnalyzer
extends AbstractLexicalAnalyzer {
    public PerceptronLexicalAnalyzer(PerceptronSegmenter segmenter) {
        super(segmenter);
    }

    public PerceptronLexicalAnalyzer(PerceptronSegmenter segmenter, PerceptronPOSTagger posTagger) {
        super(segmenter, posTagger);
    }

    public PerceptronLexicalAnalyzer(PerceptronSegmenter segmenter, PerceptronPOSTagger posTagger, PerceptronNERecognizer neRecognizer) {
        super(segmenter, posTagger, neRecognizer);
    }

    public PerceptronLexicalAnalyzer(LinearModel cwsModel, LinearModel posModel, LinearModel nerModel) {
        this.segmenter = new PerceptronSegmenter(cwsModel);
        if (posModel != null) {
            this.posTagger = new PerceptronPOSTagger(posModel);
            this.config.speechTagging = true;
        } else {
            this.posTagger = null;
        }
        if (nerModel != null) {
            this.neRecognizer = new PerceptronNERecognizer(nerModel);
            this.config.ner = true;
        } else {
            this.neRecognizer = null;
        }
    }

    public PerceptronLexicalAnalyzer(String cwsModelFile, String posModelFile, String nerModelFile) throws IOException {
        this(new LinearModel(cwsModelFile), posModelFile == null ? null : new LinearModel(posModelFile), nerModelFile == null ? null : new LinearModel(nerModelFile));
    }

    public PerceptronLexicalAnalyzer(String cwsModelFile, String posModelFile) throws IOException {
        this(new LinearModel(cwsModelFile), posModelFile == null ? null : new LinearModel(posModelFile), null);
    }

    public PerceptronLexicalAnalyzer(String cwsModelFile) throws IOException {
        this(new LinearModel(cwsModelFile), null, null);
    }

    public PerceptronLexicalAnalyzer(LinearModel CWSModel) {
        this(CWSModel, null, null);
    }

    public PerceptronLexicalAnalyzer() throws IOException {
        this(HanLP.Config.PerceptronCWSModelPath, HanLP.Config.PerceptronPOSModelPath, HanLP.Config.PerceptronNERModelPath);
    }

    public void segment(String text, List<String> output) {
        String normalized = CharTable.convert(text);
        this.segment(text, normalized, output);
    }

    public String[] partOfSpeechTag(List<String> wordList) {
        if (this.posTagger == null) {
            throw new IllegalStateException("\u672a\u63d0\u4f9b\u8bcd\u6027\u6807\u6ce8\u6a21\u578b");
        }
        return this.tag(wordList);
    }

    public String[] namedEntityRecognize(String[] wordArray, String[] posArray) {
        if (this.neRecognizer == null) {
            throw new IllegalStateException("\u672a\u63d0\u4f9b\u547d\u540d\u5b9e\u4f53\u8bc6\u522b\u6a21\u578b");
        }
        return this.recognize(wordArray, posArray);
    }

    public boolean learn(String segmentedTaggedSentence) {
        Sentence sentence = Sentence.create(segmentedTaggedSentence);
        return this.learn(sentence);
    }

    public boolean learn(Sentence sentence) {
        CharTable.normalize(sentence);
        if (!this.getPerceptronSegmenter().learn(sentence)) {
            return false;
        }
        if (this.posTagger != null && !this.getPerceptronPOSTagger().learn(sentence)) {
            return false;
        }
        return this.neRecognizer == null || this.getPerceptionNERecognizer().learn(sentence);
    }

    public PerceptronSegmenter getPerceptronSegmenter() {
        return (PerceptronSegmenter)this.segmenter;
    }

    public PerceptronPOSTagger getPerceptronPOSTagger() {
        return (PerceptronPOSTagger)this.posTagger;
    }

    public PerceptronNERecognizer getPerceptionNERecognizer() {
        return (PerceptronNERecognizer)this.neRecognizer;
    }
}

