/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.model.perceptron;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.corpus.document.sentence.Sentence;
import com.hankcs.hanlp.corpus.document.sentence.word.CompoundWord;
import com.hankcs.hanlp.corpus.document.sentence.word.IWord;
import com.hankcs.hanlp.model.perceptron.PerceptronTagger;
import com.hankcs.hanlp.model.perceptron.common.TaskType;
import com.hankcs.hanlp.model.perceptron.feature.FeatureMap;
import com.hankcs.hanlp.model.perceptron.instance.Instance;
import com.hankcs.hanlp.model.perceptron.instance.NERInstance;
import com.hankcs.hanlp.model.perceptron.model.LinearModel;
import com.hankcs.hanlp.model.perceptron.tagset.NERTagSet;
import com.hankcs.hanlp.tokenizer.lexical.NERecognizer;
import com.hankcs.hanlp.utility.Predefine;
import java.io.IOException;

public class PerceptronNERecognizer
extends PerceptronTagger
implements NERecognizer {
    final NERTagSet tagSet;

    public PerceptronNERecognizer(LinearModel nerModel) {
        super(nerModel);
        if (nerModel.tagSet().type != TaskType.NER) {
            throw new IllegalArgumentException(String.format("\u9519\u8bef\u7684\u6a21\u578b\u7c7b\u578b: \u4f20\u5165\u7684\u4e0d\u662f\u547d\u540d\u5b9e\u4f53\u8bc6\u522b\u6a21\u578b\uff0c\u800c\u662f %s \u6a21\u578b", new Object[]{nerModel.featureMap.tagSet.type}));
        }
        this.tagSet = (NERTagSet)this.model.tagSet();
    }

    public PerceptronNERecognizer(String nerModelPath) throws IOException {
        this(new LinearModel(nerModelPath));
    }

    public PerceptronNERecognizer() throws IOException {
        this(HanLP.Config.PerceptronNERModelPath);
    }

    @Override
    public String[] recognize(String[] wordArray, String[] posArray) {
        NERInstance instance = new NERInstance(wordArray, posArray, this.model.featureMap);
        return this.recognize(instance);
    }

    public String[] recognize(NERInstance instance) {
        instance.tagArray = new int[instance.size()];
        this.model.viterbiDecode(instance);
        return instance.tags(this.tagSet);
    }

    @Override
    public NERTagSet getNERTagSet() {
        return this.tagSet;
    }

    public boolean learn(String segmentedTaggedNERSentence) {
        return this.learn(new NERInstance(segmentedTaggedNERSentence, this.model.featureMap));
    }

    @Override
    protected Instance createInstance(Sentence sentence, FeatureMap featureMap) {
        for (IWord word : sentence) {
            if (!(word instanceof CompoundWord) || this.tagSet.nerLabels.contains(word.getLabel())) continue;
            Predefine.logger.warning("\u5728\u7ebf\u5b66\u4e60\u4e0d\u53ef\u80fd\u5b66\u4e60\u65b0\u7684\u6807\u7b7e: " + word + " \uff1b\u8bf7\u6807\u6ce8\u8bed\u6599\u5e93\u540e\u91cd\u65b0\u5168\u91cf\u8bad\u7ec3\u3002");
        }
        return new NERInstance(sentence, featureMap);
    }
}

