/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.dictionary.ns;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.collection.AhoCorasick.AhoCorasickDoubleArrayTrie;
import com.hankcs.hanlp.corpus.dictionary.item.EnumItem;
import com.hankcs.hanlp.corpus.tag.NS;
import com.hankcs.hanlp.dictionary.CoreDictionary;
import com.hankcs.hanlp.dictionary.TransformMatrixDictionary;
import com.hankcs.hanlp.dictionary.ns.NSDictionary;
import com.hankcs.hanlp.seg.common.Vertex;
import com.hankcs.hanlp.seg.common.WordNet;
import com.hankcs.hanlp.utility.Predefine;
import java.util.List;
import java.util.TreeMap;

public class PlaceDictionary {
    public static NSDictionary dictionary;
    public static TransformMatrixDictionary<NS> transformMatrixDictionary;
    public static AhoCorasickDoubleArrayTrie<String> trie;
    static final int WORD_ID;
    static final CoreDictionary.Attribute ATTRIBUTE;

    public static void parsePattern(List<NS> nsList, List<Vertex> vertexList, final WordNet wordNetOptimum, final WordNet wordNetAll) {
        StringBuilder sbPattern = new StringBuilder(nsList.size());
        for (NS ns : nsList) {
            sbPattern.append(ns.toString());
        }
        String pattern = sbPattern.toString();
        final Vertex[] wordArray = vertexList.toArray(new Vertex[0]);
        trie.parseText(pattern, new AhoCorasickDoubleArrayTrie.IHit<String>(){

            @Override
            public void hit(int begin, int end, String value) {
                StringBuilder sbName = new StringBuilder();
                for (int i = begin; i < end; ++i) {
                    sbName.append(wordArray[i].realWord);
                }
                String name = sbName.toString();
                if (PlaceDictionary.isBadCase(name)) {
                    return;
                }
                if (HanLP.Config.DEBUG) {
                    System.out.printf("\u8bc6\u522b\u51fa\u5730\u540d\uff1a%s %s\n", name, value);
                }
                int offset = 0;
                for (int i = 0; i < begin; ++i) {
                    offset += wordArray[i].realWord.length();
                }
                wordNetOptimum.insert(offset, new Vertex("\u672a##\u5730", name, ATTRIBUTE, WORD_ID), wordNetAll);
            }
        });
    }

    static boolean isBadCase(String name) {
        EnumItem nrEnumItem = (EnumItem)dictionary.get(name);
        if (nrEnumItem == null) {
            return false;
        }
        return nrEnumItem.containsLabel(NS.Z);
    }

    static {
        WORD_ID = CoreDictionary.getWordID("\u672a##\u5730");
        ATTRIBUTE = CoreDictionary.get(WORD_ID);
        long start = System.currentTimeMillis();
        dictionary = new NSDictionary();
        if (!dictionary.load(HanLP.Config.PlaceDictionaryPath)) {
            throw new IllegalArgumentException(HanLP.Config.PlaceDictionaryPath + "\u52a0\u8f7d\u5931\u8d25");
        }
        Predefine.logger.info(HanLP.Config.PlaceDictionaryPath + "\u52a0\u8f7d\u6210\u529f\uff0c\u8017\u65f6" + (System.currentTimeMillis() - start) + "ms");
        transformMatrixDictionary = new TransformMatrixDictionary<NS>(NS.class);
        transformMatrixDictionary.load(HanLP.Config.PlaceDictionaryTrPath);
        trie = new AhoCorasickDoubleArrayTrie();
        TreeMap<String, String> patternMap = new TreeMap<String, String>();
        patternMap.put("CH", "CH");
        patternMap.put("CDH", "CDH");
        patternMap.put("CDEH", "CDEH");
        patternMap.put("GH", "GH");
        trie.build(patternMap);
    }
}

