/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.algorithm;

import com.hankcs.hanlp.seg.Dijkstra.Path.State;
import com.hankcs.hanlp.seg.common.EdgeFrom;
import com.hankcs.hanlp.seg.common.Graph;
import com.hankcs.hanlp.seg.common.Vertex;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.PriorityQueue;

public class Dijkstra {
    public static List<Vertex> compute(Graph graph) {
        LinkedList<Vertex> resultList = new LinkedList<Vertex>();
        Vertex[] vertexes = graph.getVertexes();
        List<EdgeFrom>[] edgesTo = graph.getEdgesTo();
        double[] d = new double[vertexes.length];
        Arrays.fill(d, Double.MAX_VALUE);
        d[d.length - 1] = 0.0;
        int[] path = new int[vertexes.length];
        Arrays.fill(path, -1);
        PriorityQueue<State> que = new PriorityQueue<State>();
        que.add(new State(0.0, vertexes.length - 1));
        while (!que.isEmpty()) {
            State p = (State)que.poll();
            if (d[p.vertex] < p.cost) continue;
            for (EdgeFrom edgeFrom : edgesTo[p.vertex]) {
                if (!(d[edgeFrom.from] > d[p.vertex] + edgeFrom.weight)) continue;
                d[edgeFrom.from] = d[p.vertex] + edgeFrom.weight;
                que.add(new State(d[edgeFrom.from], edgeFrom.from));
                path[edgeFrom.from] = p.vertex;
            }
        }
        int t = 0;
        while (t != -1) {
            resultList.add(vertexes[t]);
            t = path[t];
        }
        return resultList;
    }
}

