/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.model.crf.crfpp;

import com.hankcs.hanlp.collection.trie.datrie.IntArrayList;
import com.hankcs.hanlp.collection.trie.datrie.MutableDoubleArrayTrieInteger;
import com.hankcs.hanlp.corpus.io.IOUtil;
import com.hankcs.hanlp.model.crf.crfpp.Encoder;
import com.hankcs.hanlp.model.crf.crfpp.FeatureIndex;
import com.hankcs.hanlp.model.crf.crfpp.TaggerImpl;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.OutputStreamWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class EncoderFeatureIndex
extends FeatureIndex {
    private MutableDoubleArrayTrieInteger dic_;
    private IntArrayList frequency;
    private int bId = Integer.MAX_VALUE;

    public EncoderFeatureIndex(int n) {
        this.threadNum_ = n;
        this.dic_ = new MutableDoubleArrayTrieInteger();
        this.frequency = new IntArrayList();
    }

    @Override
    public int getID(String key) {
        int k = this.dic_.get(key);
        if (k == -1) {
            this.dic_.put(key, this.maxid_);
            this.frequency.append(1);
            int n = this.maxid_;
            if (key.charAt(0) == 'U') {
                this.maxid_ += this.y_.size();
            } else {
                this.bId = n;
                this.maxid_ += this.y_.size() * this.y_.size();
            }
            return n;
        }
        int cid = this.continuousId(k);
        int oldVal = this.frequency.get(cid);
        this.frequency.set(cid, oldVal + 1);
        return k;
    }

    private int continuousId(int id) {
        if (id <= this.bId) {
            return id / this.y_.size();
        }
        return id / this.y_.size() - this.y_.size() + 1;
    }

    private boolean openTemplate(String filename) {
        InputStreamReader isr = null;
        try {
            String line;
            isr = new InputStreamReader(IOUtil.newInputStream(filename), "UTF-8");
            BufferedReader br = new BufferedReader(isr);
            while ((line = br.readLine()) != null) {
                if (line.length() == 0 || line.charAt(0) == ' ' || line.charAt(0) == '#') continue;
                if (line.charAt(0) == 'U') {
                    this.unigramTempls_.add(line.trim());
                    continue;
                }
                if (line.charAt(0) == 'B') {
                    this.bigramTempls_.add(line.trim());
                    continue;
                }
                System.err.println("unknown type: " + line);
            }
            br.close();
            this.templs_ = this.makeTempls(this.unigramTempls_, this.bigramTempls_);
        }
        catch (Exception e) {
            if (isr != null) {
                try {
                    isr.close();
                }
                catch (Exception e2) {
                    // empty catch block
                }
            }
            e.printStackTrace();
            System.err.println("Error reading " + filename);
            return false;
        }
        return true;
    }

    private boolean openTagSet(String filename) {
        int max_size = 0;
        InputStreamReader isr = null;
        this.y_.clear();
        try {
            String line;
            isr = new InputStreamReader(IOUtil.newInputStream(filename), "UTF-8");
            BufferedReader br = new BufferedReader(isr);
            while ((line = br.readLine()) != null) {
                char firstChar;
                if (line.length() == 0 || (firstChar = line.charAt(0)) == '\u0000' || firstChar == ' ' || firstChar == '\t') continue;
                String[] cols = line.split("[\t ]", -1);
                if (max_size == 0) {
                    max_size = cols.length;
                }
                if (max_size != cols.length) {
                    String msg = "inconsistent column size: " + max_size + " " + cols.length + " " + filename;
                    throw new RuntimeException(msg);
                }
                this.xsize_ = cols.length - 1;
                if (this.y_.indexOf(cols[max_size - 1]) != -1) continue;
                this.y_.add(cols[max_size - 1]);
            }
            Collections.sort(this.y_);
            br.close();
        }
        catch (Exception e) {
            if (isr != null) {
                try {
                    isr.close();
                }
                catch (Exception e2) {
                    // empty catch block
                }
            }
            e.printStackTrace();
            System.err.println("Error reading " + filename);
            return false;
        }
        return true;
    }

    public boolean open(String filename1, String filename2) {
        this.checkMaxXsize_ = true;
        return this.openTemplate(filename1) && this.openTagSet(filename2);
    }

    public boolean save(String filename, boolean textModelFile) {
        try {
            ObjectOutputStream oos = new ObjectOutputStream(IOUtil.newOutputStream(filename));
            oos.writeObject(Encoder.MODEL_VERSION);
            oos.writeObject(this.costFactor_);
            oos.writeObject(this.maxid_);
            if (this.max_xsize_ > 0) {
                this.xsize_ = Math.min(this.xsize_, this.max_xsize_);
            }
            oos.writeObject(this.xsize_);
            oos.writeObject(this.y_);
            oos.writeObject(this.unigramTempls_);
            oos.writeObject(this.bigramTempls_);
            oos.writeObject(this.dic_);
            oos.writeObject(this.alpha_);
            oos.close();
            if (textModelFile) {
                OutputStreamWriter osw = new OutputStreamWriter(IOUtil.newOutputStream(filename + ".txt"), "UTF-8");
                osw.write("version: " + Encoder.MODEL_VERSION + "\n");
                osw.write("cost-factor: " + this.costFactor_ + "\n");
                osw.write("maxid: " + this.maxid_ + "\n");
                osw.write("xsize: " + this.xsize_ + "\n");
                osw.write("\n");
                for (String y : this.y_) {
                    osw.write(y + "\n");
                }
                osw.write("\n");
                for (String utempl : this.unigramTempls_) {
                    osw.write(utempl + "\n");
                }
                for (String bitempl : this.bigramTempls_) {
                    osw.write(bitempl + "\n");
                }
                osw.write("\n");
                for (MutableDoubleArrayTrieInteger.KeyValuePair pair : this.dic_) {
                    osw.write(pair.getValue() + " " + pair.getKey() + "\n");
                }
                osw.write("\n");
                for (int k = 0; k < this.maxid_; ++k) {
                    String val = new DecimalFormat("0.0000000000000000").format(this.alpha_[k]);
                    osw.write(val + "\n");
                }
                osw.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Error saving model to " + filename);
            return false;
        }
        return true;
    }

    @Override
    public void clear() {
    }

    public void shrink(int freq, List<TaggerImpl> taggers) {
        if (freq <= 1) {
            return;
        }
        int newMaxId = 0;
        TreeMap<Integer, Integer> old2new = new TreeMap<Integer, Integer>();
        ArrayList<String> deletedKeys = new ArrayList<String>(this.dic_.size() / 8);
        LinkedList<Map.Entry<String, Integer>> l = new LinkedList<Map.Entry<String, Integer>>(this.dic_.entrySet());
        for (MutableDoubleArrayTrieInteger.KeyValuePair pair : this.dic_) {
            String key = pair.key();
            int id = pair.value();
            int cid = this.continuousId(id);
            int f = this.frequency.get(cid);
            if (f >= freq) {
                old2new.put(id, newMaxId);
                pair.setValue(newMaxId);
                newMaxId += key.charAt(0) == 'U' ? this.y_.size() : this.y_.size() * this.y_.size();
                continue;
            }
            deletedKeys.add(key);
        }
        for (String key : deletedKeys) {
            this.dic_.remove(key);
        }
        for (TaggerImpl tagger : taggers) {
            List<List<Integer>> featureCache = tagger.getFeatureCache_();
            for (int k = 0; k < featureCache.size(); ++k) {
                List<Integer> featureCacheItem = featureCache.get(k);
                ArrayList<Integer> newCache = new ArrayList<Integer>();
                for (Integer it : featureCacheItem) {
                    Integer nid;
                    if (it == -1 || (nid = (Integer)old2new.get(it)) == null) continue;
                    newCache.add(nid);
                }
                newCache.add(-1);
                featureCache.set(k, newCache);
            }
        }
        this.maxid_ = newMaxId;
    }

    public boolean convert(String textmodel, String binarymodel) {
        try {
            String line;
            InputStreamReader isr = new InputStreamReader(IOUtil.newInputStream(textmodel), "UTF-8");
            BufferedReader br = new BufferedReader(isr);
            int version = Integer.valueOf(br.readLine().substring("version: ".length()));
            this.costFactor_ = Double.valueOf(br.readLine().substring("cost-factor: ".length()));
            this.maxid_ = Integer.valueOf(br.readLine().substring("maxid: ".length()));
            this.xsize_ = Integer.valueOf(br.readLine().substring("xsize: ".length()));
            System.out.println("Done reading meta-info");
            br.readLine();
            while ((line = br.readLine()) != null && line.length() > 0) {
                this.y_.add(line);
            }
            System.out.println("Done reading labels");
            while ((line = br.readLine()) != null && line.length() > 0) {
                if (line.startsWith("U")) {
                    this.unigramTempls_.add(line);
                    continue;
                }
                if (!line.startsWith("B")) continue;
                this.bigramTempls_.add(line);
            }
            System.out.println("Done reading templates");
            this.dic_ = new MutableDoubleArrayTrieInteger();
            while ((line = br.readLine()) != null && line.length() > 0) {
                String[] content = line.trim().split(" ");
                if (content.length != 2) {
                    System.err.println("feature indices format error");
                    return false;
                }
                this.dic_.put(content[1], Integer.valueOf(content[0]));
            }
            System.out.println("Done reading feature indices");
            ArrayList<Double> alpha = new ArrayList<Double>();
            while ((line = br.readLine()) != null && line.length() > 0) {
                alpha.add(Double.valueOf(line));
            }
            System.out.println("Done reading weights");
            this.alpha_ = new double[alpha.size()];
            for (int i = 0; i < alpha.size(); ++i) {
                this.alpha_[i] = (Double)alpha.get(i);
            }
            br.close();
            System.out.println("Writing binary model to " + binarymodel);
            return this.save(binarymodel, false);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            return;
        }
        EncoderFeatureIndex featureIndex = new EncoderFeatureIndex(1);
        if (!featureIndex.convert(args[0], args[1])) {
            System.err.println("Fail to convert text model");
        }
    }
}

