/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.corpus.io;

import com.hankcs.hanlp.HanLP;
import com.hankcs.hanlp.corpus.tag.Nature;
import com.hankcs.hanlp.dictionary.CoreDictionary;
import com.hankcs.hanlp.utility.LexiconUtility;
import com.hankcs.hanlp.utility.Predefine;
import com.hankcs.hanlp.utility.TextUtility;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;

public class IOUtil {
    public static boolean saveObjectTo(Object o, String path) {
        try {
            ObjectOutputStream oos = new ObjectOutputStream(IOUtil.newOutputStream(path));
            oos.writeObject(o);
            oos.close();
        }
        catch (IOException e) {
            Predefine.logger.warning("\u5728\u4fdd\u5b58\u5bf9\u8c61" + o + "\u5230" + path + "\u65f6\u53d1\u751f\u5f02\u5e38" + e);
            return false;
        }
        return true;
    }

    public static Object readObjectFrom(String path) {
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(IOUtil.newInputStream(path));
            Object o = ois.readObject();
            ois.close();
            return o;
        }
        catch (Exception e) {
            Predefine.logger.warning("\u5728\u4ece" + path + "\u8bfb\u53d6\u5bf9\u8c61\u65f6\u53d1\u751f\u5f02\u5e38" + e);
            return null;
        }
    }

    public static String readTxt(String path) {
        if (path == null) {
            return null;
        }
        try {
            InputStream in = HanLP.Config.IOAdapter == null ? new FileInputStream(path) : HanLP.Config.IOAdapter.open(path);
            byte[] fileContent = new byte[in.available()];
            int read = IOUtil.readBytesFromOtherInputStream(in, fileContent);
            in.close();
            if (read >= 3 && fileContent[0] == -17 && fileContent[1] == -69 && fileContent[2] == -65) {
                return new String(fileContent, 3, fileContent.length - 3, Charset.forName("UTF-8"));
            }
            return new String(fileContent, Charset.forName("UTF-8"));
        }
        catch (FileNotFoundException e) {
            Predefine.logger.warning("\u627e\u4e0d\u5230" + path + e);
            return null;
        }
        catch (IOException e) {
            Predefine.logger.warning("\u8bfb\u53d6" + path + "\u53d1\u751fIO\u5f02\u5e38" + e);
            return null;
        }
    }

    public static LinkedList<String[]> readCsv(String path) {
        LinkedList<String[]> resultList = new LinkedList<String[]>();
        LinkedList<String> lineList = IOUtil.readLineList(path);
        for (String line : lineList) {
            resultList.add(line.split(","));
        }
        return resultList;
    }

    public static boolean saveTxt(String path, String content) {
        try {
            FileChannel fc = new FileOutputStream(path).getChannel();
            fc.write(ByteBuffer.wrap(content.getBytes()));
            fc.close();
        }
        catch (Exception e) {
            Predefine.logger.throwing("IOUtil", "saveTxt", e);
            Predefine.logger.warning("IOUtil saveTxt \u5230" + path + "\u5931\u8d25" + e.toString());
            return false;
        }
        return true;
    }

    public static boolean saveTxt(String path, StringBuilder content) {
        return IOUtil.saveTxt(path, content.toString());
    }

    public static <T> boolean saveCollectionToTxt(Collection<T> collection, String path) {
        StringBuilder sb = new StringBuilder();
        for (T o : collection) {
            sb.append(o);
            sb.append('\n');
        }
        return IOUtil.saveTxt(path, sb.toString());
    }

    public static byte[] readBytes(String path) {
        try {
            if (HanLP.Config.IOAdapter == null) {
                return IOUtil.readBytesFromFileInputStream(new FileInputStream(path));
            }
            InputStream is = HanLP.Config.IOAdapter.open(path);
            if (is instanceof FileInputStream) {
                return IOUtil.readBytesFromFileInputStream((FileInputStream)is);
            }
            return IOUtil.readBytesFromOtherInputStream(is);
        }
        catch (Exception e) {
            Predefine.logger.warning("\u8bfb\u53d6" + path + "\u65f6\u53d1\u751f\u5f02\u5e38" + e);
            return null;
        }
    }

    public static String readTxt(String file, String charsetName) throws IOException {
        int len;
        InputStream is = HanLP.Config.IOAdapter.open(file);
        byte[] targetArray = new byte[is.available()];
        for (int off = 0; (len = is.read(targetArray, off, targetArray.length - off)) != -1 && off < targetArray.length; off += len) {
        }
        is.close();
        return new String(targetArray, charsetName);
    }

    public static String baseName(String path) {
        if (path == null || path.length() == 0) {
            return "";
        }
        path = path.replaceAll("[/\\\\]+", "/");
        int len = path.length();
        int upCount = 0;
        while (len > 0) {
            if (path.charAt(len - 1) == '/' && --len == 0) {
                return "";
            }
            int lastInd = path.lastIndexOf(47, len - 1);
            String fileName = path.substring(lastInd + 1, len);
            if (fileName.equals(".")) {
                --len;
                continue;
            }
            if (fileName.equals("..")) {
                len -= 2;
                ++upCount;
                continue;
            }
            if (upCount == 0) {
                return fileName;
            }
            --upCount;
            len -= fileName.length();
        }
        return "";
    }

    private static byte[] readBytesFromFileInputStream(FileInputStream fis) throws IOException {
        FileChannel channel = fis.getChannel();
        int fileSize = (int)channel.size();
        ByteBuffer byteBuffer = ByteBuffer.allocate(fileSize);
        channel.read(byteBuffer);
        byteBuffer.flip();
        byte[] bytes = byteBuffer.array();
        byteBuffer.clear();
        channel.close();
        fis.close();
        return bytes;
    }

    public static byte[] readBytesFromOtherInputStream(InputStream is) throws IOException {
        int readBytes;
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        byte[] buffer = new byte[Math.max(is.available(), 4096)];
        while ((readBytes = is.read(buffer, 0, buffer.length)) != -1) {
            data.write(buffer, 0, readBytes);
        }
        data.flush();
        return data.toByteArray();
    }

    public static int readBytesFromOtherInputStream(InputStream is, byte[] targetArray) throws IOException {
        int off;
        int len;
        assert (targetArray != null);
        if (targetArray.length == 0) {
            return 0;
        }
        for (off = 0; off < targetArray.length && (len = is.read(targetArray, off, targetArray.length - off)) != -1; off += len) {
        }
        return off;
    }

    public static byte[] readBytesFromResource(String path) throws IOException {
        int len;
        InputStream is = IOUtil.class.getResourceAsStream("/" + path);
        byte[] targetArray = new byte[is.available()];
        for (int off = 0; (len = is.read(targetArray, off, targetArray.length - off)) != -1 && off < targetArray.length; off += len) {
        }
        is.close();
        return targetArray;
    }

    public static byte[] getBytes(InputStream is) throws IOException {
        int len;
        int size = 1024;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] buf = new byte[size];
        while ((len = is.read(buf, 0, size)) != -1) {
            bos.write(buf, 0, len);
        }
        buf = bos.toByteArray();
        return buf;
    }

    public static LinkedList<String> readLineList(String path) {
        LinkedList<String> result = new LinkedList<String>();
        String txt = IOUtil.readTxt(path);
        if (txt == null) {
            return result;
        }
        StringTokenizer tokenizer = new StringTokenizer(txt, "\n");
        while (tokenizer.hasMoreTokens()) {
            result.add(tokenizer.nextToken());
        }
        return result;
    }

    public static LinkedList<String> readLineListWithLessMemory(String path) {
        LinkedList<String> result = new LinkedList<String>();
        String line = null;
        boolean first = true;
        try {
            BufferedReader bw = new BufferedReader(new InputStreamReader(IOUtil.newInputStream(path), "UTF-8"));
            while ((line = bw.readLine()) != null) {
                if (first) {
                    first = false;
                    if (!line.isEmpty() && line.charAt(0) == '\ufeff') {
                        line = line.substring(1);
                    }
                }
                result.add(line);
            }
            bw.close();
        }
        catch (Exception e) {
            Predefine.logger.warning("\u52a0\u8f7d" + path + "\u5931\u8d25\uff0c" + e);
        }
        return result;
    }

    public static boolean saveMapToTxt(Map<Object, Object> map, String path) {
        return IOUtil.saveMapToTxt(map, path, "=");
    }

    public static boolean saveMapToTxt(Map<Object, Object> map, String path, String separator) {
        map = new TreeMap<Object, Object>(map);
        return IOUtil.saveEntrySetToTxt(map.entrySet(), path, separator);
    }

    public static boolean saveEntrySetToTxt(Set<Map.Entry<Object, Object>> entrySet, String path, String separator) {
        StringBuilder sbOut = new StringBuilder();
        for (Map.Entry<Object, Object> entry : entrySet) {
            sbOut.append(entry.getKey());
            sbOut.append(separator);
            sbOut.append(entry.getValue());
            sbOut.append('\n');
        }
        return IOUtil.saveTxt(path, sbOut.toString());
    }

    public static String dirname(String path) {
        int index = path.lastIndexOf(47);
        if (index == -1) {
            return path;
        }
        return path.substring(0, index + 1);
    }

    public static LineIterator readLine(String path) {
        return new LineIterator(path);
    }

    public static boolean deleteFile(String path) {
        return new File(path).delete();
    }

    public static String removeUTF8BOM(String line) {
        if (line != null && line.startsWith("\ufeff")) {
            line = line.substring(1);
        }
        return line;
    }

    public static List<File> fileList(String path) {
        LinkedList<File> fileList = new LinkedList<File>();
        File folder = new File(path);
        if (folder.isDirectory()) {
            IOUtil.enumerate(folder, fileList);
        } else {
            fileList.add(folder);
        }
        return fileList;
    }

    private static void enumerate(File folder, List<File> fileList) {
        File[] fileArray = folder.listFiles();
        if (fileArray != null) {
            for (File file : fileArray) {
                if (file.isFile() && !file.getName().startsWith(".")) {
                    fileList.add(file);
                    continue;
                }
                IOUtil.enumerate(file, fileList);
            }
        }
    }

    public static boolean isFileExisted(String path) {
        File file = new File(path);
        return file.isFile() && file.exists();
    }

    public static boolean isResource(String path) {
        return path.startsWith("data/");
    }

    public static BufferedWriter newBufferedWriter(String path) throws IOException {
        return new BufferedWriter(new OutputStreamWriter(IOUtil.newOutputStream(path), "UTF-8"));
    }

    public static BufferedReader newBufferedReader(String path) throws IOException {
        return new BufferedReader(new InputStreamReader(IOUtil.newInputStream(path), "UTF-8"));
    }

    public static BufferedWriter newBufferedWriter(String path, boolean append) throws FileNotFoundException, UnsupportedEncodingException {
        return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(path, append), "UTF-8"));
    }

    public static InputStream newInputStream(String path) throws IOException {
        if (HanLP.Config.IOAdapter == null) {
            return new FileInputStream(path);
        }
        return HanLP.Config.IOAdapter.open(path);
    }

    public static OutputStream newOutputStream(String path) throws IOException {
        if (HanLP.Config.IOAdapter == null) {
            return new FileOutputStream(path);
        }
        return HanLP.Config.IOAdapter.create(path);
    }

    public static String getSuffix(String name, String delimiter) {
        return name.substring(name.lastIndexOf(delimiter) + 1);
    }

    public static void writeLine(BufferedWriter bw, String ... params) throws IOException {
        for (int i = 0; i < params.length - 1; ++i) {
            bw.write(params[i]);
            bw.write(9);
        }
        bw.write(params[params.length - 1]);
    }

    public static TreeMap<String, CoreDictionary.Attribute> loadDictionary(String ... pathArray) throws IOException {
        TreeMap<String, CoreDictionary.Attribute> map = new TreeMap<String, CoreDictionary.Attribute>();
        for (String path : pathArray) {
            int natureIndex = path.lastIndexOf(32);
            Nature defaultNature = Nature.n;
            if (natureIndex > 0) {
                String natureString = path.substring(natureIndex + 1);
                path = path.substring(0, natureIndex);
                if (natureString.length() > 0 && !natureString.endsWith(".txt") && !natureString.endsWith(".csv")) {
                    defaultNature = Nature.create(natureString);
                }
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(IOUtil.newInputStream(path), "UTF-8"));
            IOUtil.loadDictionary(br, map, path.endsWith(".csv"), defaultNature);
        }
        return map;
    }

    public static void loadDictionary(BufferedReader br, TreeMap<String, CoreDictionary.Attribute> storage, boolean isCSV, Nature defaultNature) throws IOException {
        String line;
        String splitter = "\\s";
        if (isCSV) {
            splitter = ",";
        }
        boolean firstLine = true;
        while ((line = br.readLine()) != null) {
            CoreDictionary.Attribute attribute;
            String[] param;
            int natureCount;
            if (firstLine) {
                line = IOUtil.removeUTF8BOM(line);
                firstLine = false;
            }
            if ((natureCount = ((param = line.split(splitter)).length - 1) / 2) == 0) {
                attribute = new CoreDictionary.Attribute(defaultNature);
            } else {
                attribute = new CoreDictionary.Attribute(natureCount);
                for (int i = 0; i < natureCount; ++i) {
                    attribute.nature[i] = LexiconUtility.convertStringToNature(param[1 + 2 * i]);
                    attribute.frequency[i] = Integer.parseInt(param[2 + 2 * i]);
                    attribute.totalFrequency += attribute.frequency[i];
                }
            }
            storage.put(param[0], attribute);
        }
        br.close();
    }

    public static void writeCustomNature(DataOutputStream out, LinkedHashSet<Nature> customNatureCollector) throws IOException {
        if (customNatureCollector.size() == 0) {
            return;
        }
        out.writeInt(-customNatureCollector.size());
        for (Nature nature : customNatureCollector) {
            TextUtility.writeString(nature.toString(), out);
        }
    }

    public static InputStream getResourceAsStream(String path) throws FileNotFoundException {
        InputStream is = IOUtil.class.getResourceAsStream(path);
        if (is == null) {
            throw new FileNotFoundException("\u8d44\u6e90\u6587\u4ef6" + path + "\u4e0d\u5b58\u5728\u4e8ejar\u4e2d");
        }
        return is;
    }

    public static class LineIterator
    implements Iterator<String>,
    Iterable<String> {
        BufferedReader bw;
        String line;

        public LineIterator(BufferedReader bw) {
            this.bw = bw;
            try {
                this.line = bw.readLine();
                this.line = IOUtil.removeUTF8BOM(this.line);
            }
            catch (IOException e) {
                Predefine.logger.warning("\u5728\u8bfb\u53d6\u8fc7\u7a0b\u4e2d\u53d1\u751f\u9519\u8bef" + TextUtility.exceptionToString(e));
                bw = null;
            }
        }

        public LineIterator(String path) {
            try {
                this.bw = new BufferedReader(new InputStreamReader(IOUtil.newInputStream(path), "UTF-8"));
                this.line = this.bw.readLine();
                this.line = IOUtil.removeUTF8BOM(this.line);
            }
            catch (FileNotFoundException e) {
                Predefine.logger.warning("\u6587\u4ef6" + path + "\u4e0d\u5b58\u5728\uff0c\u63a5\u4e0b\u6765\u7684\u8c03\u7528\u4f1a\u8fd4\u56denull\n" + TextUtility.exceptionToString(e));
                this.bw = null;
            }
            catch (Exception e) {
                Predefine.logger.warning("\u5728\u8bfb\u53d6\u8fc7\u7a0b\u4e2d\u53d1\u751f\u9519\u8bef" + TextUtility.exceptionToString(e));
                this.bw = null;
            }
        }

        public void close() {
            if (this.bw == null) {
                return;
            }
            try {
                this.bw.close();
                this.bw = null;
            }
            catch (IOException e) {
                Predefine.logger.warning("\u5173\u95ed\u6587\u4ef6\u5931\u8d25" + TextUtility.exceptionToString(e));
            }
        }

        @Override
        public boolean hasNext() {
            if (this.bw == null) {
                return false;
            }
            if (this.line == null) {
                try {
                    this.bw.close();
                    this.bw = null;
                }
                catch (IOException e) {
                    Predefine.logger.warning("\u5173\u95ed\u6587\u4ef6\u5931\u8d25" + TextUtility.exceptionToString(e));
                }
                return false;
            }
            return true;
        }

        @Override
        public String next() {
            String preLine = this.line;
            try {
                if (this.bw != null) {
                    this.line = this.bw.readLine();
                    if (this.line == null && this.bw != null) {
                        try {
                            this.bw.close();
                            this.bw = null;
                        }
                        catch (IOException e) {
                            Predefine.logger.warning("\u5173\u95ed\u6587\u4ef6\u5931\u8d25" + TextUtility.exceptionToString(e));
                        }
                    }
                } else {
                    this.line = null;
                }
            }
            catch (IOException e) {
                Predefine.logger.warning("\u5728\u8bfb\u53d6\u8fc7\u7a0b\u4e2d\u53d1\u751f\u9519\u8bef" + TextUtility.exceptionToString(e));
            }
            return preLine;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("\u53ea\u8bfb\uff0c\u4e0d\u53ef\u5199\uff01");
        }

        @Override
        public Iterator<String> iterator() {
            return this;
        }
    }
}

