/*
 * Decompiled with CFR 0.152.
 */
package proguard.shrink;

import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.ProgramClass;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Utf8Constant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.shrink.ClassUsageMarker;
import proguard.util.Processable;

public class InterfaceUsageMarker
implements ClassVisitor,
ConstantVisitor {
    private final ClassUsageMarker classUsageMarker;
    private boolean used;
    private boolean anyUsed;

    public InterfaceUsageMarker(ClassUsageMarker classUsageMarker) {
        this.classUsageMarker = classUsageMarker;
    }

    public void visitAnyClass(Clazz clazz) {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support " + clazz.getClass().getName());
    }

    public void visitProgramClass(ProgramClass programClass) {
        boolean classUsed = this.classUsageMarker.isUsed((Processable)programClass);
        boolean classPossiblyUsed = this.classUsageMarker.isPossiblyUsed((Processable)programClass);
        if (classUsed || classPossiblyUsed) {
            boolean oldAnyUsed = this.anyUsed;
            this.anyUsed = false;
            programClass.interfaceConstantsAccept((ConstantVisitor)this);
            classUsed |= this.anyUsed;
            this.anyUsed = oldAnyUsed;
            if (classPossiblyUsed) {
                if (classUsed) {
                    this.classUsageMarker.markAsUsed((Processable)programClass);
                    programClass.thisClassConstantAccept((ConstantVisitor)this);
                    programClass.superClassConstantAccept((ConstantVisitor)this);
                } else {
                    this.classUsageMarker.markAsUnused((Processable)programClass);
                }
            }
        }
        this.used = classUsed;
    }

    public void visitLibraryClass(LibraryClass libraryClass) {
        this.used = true;
        this.anyUsed = true;
    }

    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        boolean classUsed = this.classUsageMarker.isUsed((Processable)classConstant);
        if (!classUsed) {
            classConstant.referencedClassAccept((ClassVisitor)this);
            classUsed = this.used;
            if (classUsed) {
                this.classUsageMarker.markAsUsed((Processable)classConstant);
                clazz.constantPoolEntryAccept(classConstant.u2nameIndex, (ConstantVisitor)this);
            }
        }
        this.used = classUsed;
        this.anyUsed |= classUsed;
    }

    public void visitUtf8Constant(Clazz clazz, Utf8Constant utf8Constant) {
        if (!this.classUsageMarker.isUsed((Processable)utf8Constant)) {
            this.classUsageMarker.markAsUsed((Processable)utf8Constant);
        }
    }
}

