/*
 * Decompiled with CFR 0.152.
 */
package proguard.backport;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.ListIterator;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.BootstrapMethodInfo;
import proguard.classfile.attribute.BootstrapMethodsAttribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.BootstrapMethodInfoVisitor;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.InvokeDynamicConstant;
import proguard.classfile.constant.MethodHandleConstant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.editor.InstructionSequenceBuilder;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.InternalTypeEnumeration;

public class StringConcatenationConverter
implements InstructionVisitor,
AttributeVisitor,
BootstrapMethodInfoVisitor,
ConstantVisitor {
    private static final int MAXIMUM_BOOLEAN_AS_STRING_LENGTH = 5;
    private static final int MAXIMUM_CHAR_AS_STRING_LENGTH = 1;
    private static final int MAXIMUM_BYTE_AS_STRING_LENGTH = 3;
    private static final int MAXIMUM_SHORT_AS_STRING_LENGTH = 6;
    private static final int MAXIMUM_INT_AS_STRING_LENGTH = 11;
    private static final int MAXIMUM_LONG_AS_STRING_LENGTH = 20;
    private static final int MAXIMUM_FLOAT_AS_STRING_LENGTH = 13;
    private static final int MAXIMUM_DOUBLE_AS_STRING_LENGTH = 23;
    private static final int MAXIMUM_AT_HASHCODE_LENGTH = 12;
    private static final int DEFAULT_STRINGBUILDER_INIT_SIZE = 16;
    private static final char C_VARIABLE_ARGUMENT = '\u0001';
    private static final char C_CONSTANT_ARGUMENT = '\u0002';
    private final InstructionVisitor extraInstructionVisitor;
    private final CodeAttributeEditor codeAttributeEditor;
    private InstructionSequenceBuilder appendChainComposer;
    private int estimatedStringLength;
    private int referencedBootstrapMethodIndex;
    private String concatenationRecipe;
    private int[] concatenationConstants;

    public StringConcatenationConverter(InstructionVisitor extraInstructionVisitor, CodeAttributeEditor codeAttributeEditor) {
        this.extraInstructionVisitor = extraInstructionVisitor;
        this.codeAttributeEditor = codeAttributeEditor;
    }

    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
    }

    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction) {
        if (constantInstruction.opcode == -70) {
            ProgramClass programClass = (ProgramClass)clazz;
            InvokeDynamicConstant invokeDynamicConstant = (InvokeDynamicConstant)programClass.getConstant(constantInstruction.constantIndex);
            this.referencedBootstrapMethodIndex = invokeDynamicConstant.getBootstrapMethodAttributeIndex();
            this.concatenationRecipe = null;
            this.concatenationConstants = null;
            programClass.attributesAccept((AttributeVisitor)this);
            if (this.concatenationRecipe != null) {
                String descriptor = invokeDynamicConstant.getType((Clazz)programClass);
                InstructionSequenceBuilder mainReplacementComposer = new InstructionSequenceBuilder(programClass);
                this.appendChainComposer = new InstructionSequenceBuilder(programClass);
                this.estimatedStringLength = 0;
                InternalTypeEnumeration typeEnumeration = new InternalTypeEnumeration(descriptor);
                ArrayList<String> types = new ArrayList<String>();
                while (typeEnumeration.hasMoreTypes()) {
                    types.add(typeEnumeration.nextType());
                }
                int variableIndex = codeAttribute.u2maxLocals;
                ListIterator typeIterator = types.listIterator(types.size());
                while (typeIterator.hasPrevious()) {
                    String type = (String)typeIterator.previous();
                    mainReplacementComposer.store(variableIndex, type);
                    variableIndex += ClassUtil.internalTypeSize((String)type);
                }
                typeIterator = types.listIterator();
                int constantCounter = 0;
                block6: for (int argIndex = 0; argIndex < this.concatenationRecipe.length(); ++argIndex) {
                    switch (this.concatenationRecipe.charAt(argIndex)) {
                        case '\u0001': {
                            String type = (String)typeIterator.next();
                            this.estimatedStringLength += StringConcatenationConverter.typicalStringLengthFromType(type);
                            int variableSize = ClassUtil.internalTypeSize((String)type);
                            this.appendChainComposer.load(variableIndex -= variableSize, type).invokevirtual("java/lang/StringBuilder", "append", StringConcatenationConverter.appendDescriptorFromInternalType(type));
                            continue block6;
                        }
                        case '\u0002': {
                            int constantIndex = this.concatenationConstants[constantCounter++];
                            this.appendChainComposer.ldc_(constantIndex);
                            programClass.constantPoolEntryAccept(constantIndex, (ConstantVisitor)this);
                            continue block6;
                        }
                        default: {
                            int nextArgIndex = StringConcatenationConverter.nextArgIndex(this.concatenationRecipe, argIndex);
                            this.estimatedStringLength += nextArgIndex - argIndex;
                            this.appendChainComposer.ldc(this.concatenationRecipe.substring(argIndex, nextArgIndex)).invokevirtual("java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                            argIndex = nextArgIndex - 1;
                        }
                    }
                }
                mainReplacementComposer.new_("java/lang/StringBuilder").dup().pushInt(this.estimatedStringLength).invokespecial("java/lang/StringBuilder", "<init>", "(I)V");
                mainReplacementComposer.appendInstructions(this.appendChainComposer.instructions());
                mainReplacementComposer.invokevirtual("java/lang/StringBuilder", "toString", "()Ljava/lang/String;");
                this.codeAttributeEditor.replaceInstruction(offset, mainReplacementComposer.instructions());
                if (this.extraInstructionVisitor != null) {
                    this.extraInstructionVisitor.visitConstantInstruction(clazz, method, codeAttribute, offset, constantInstruction);
                }
            }
        }
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitBootstrapMethodsAttribute(Clazz clazz, BootstrapMethodsAttribute bootstrapMethodsAttribute) {
        bootstrapMethodsAttribute.bootstrapMethodEntryAccept(clazz, this.referencedBootstrapMethodIndex, (BootstrapMethodInfoVisitor)this);
    }

    public void visitBootstrapMethodInfo(Clazz clazz, BootstrapMethodInfo bootstrapMethodInfo) {
        ProgramClass programClass = (ProgramClass)clazz;
        MethodHandleConstant bootstrapMethodHandle = (MethodHandleConstant)programClass.getConstant(bootstrapMethodInfo.u2methodHandleIndex);
        if (StringConcatenationConverter.isStringConcatFactory(bootstrapMethodHandle.getClassName(clazz))) {
            this.concatenationRecipe = ((StringConstant)programClass.getConstant(bootstrapMethodInfo.u2methodArguments[0])).getString((Clazz)programClass);
            this.concatenationConstants = bootstrapMethodInfo.u2methodArgumentCount > 1 ? Arrays.copyOfRange(bootstrapMethodInfo.u2methodArguments, 1, bootstrapMethodInfo.u2methodArgumentCount) : new int[]{};
        }
    }

    public void visitAnyConstant(Clazz clazz, Constant constant) {
        this.estimatedStringLength += 16;
        this.appendChainComposer.invokevirtual("java/lang/StringBuilder", "append", "(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
    }

    public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
        this.estimatedStringLength += stringConstant.getString(clazz).length();
        this.appendChainComposer.invokevirtual("java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;");
    }

    private static boolean isStringConcatFactory(String className) {
        return "java/lang/invoke/StringConcatFactory".equals(className);
    }

    private static boolean isMakeConcat(String methodName) {
        return "makeConcat".equals(methodName);
    }

    private static boolean isMakeConcatWithConstants(String methodName) {
        return "makeConcatWithConstants".equals(methodName);
    }

    private static int typicalStringLengthFromType(String internalTypeName) {
        return internalTypeName.equals(String.valueOf('Z')) ? 5 : (internalTypeName.equals(String.valueOf('C')) ? 1 : (internalTypeName.equals(String.valueOf('B')) ? 3 : (internalTypeName.equals(String.valueOf('S')) ? 6 : (internalTypeName.equals(String.valueOf('I')) ? 11 : (internalTypeName.equals(String.valueOf('J')) ? 20 : (internalTypeName.equals(String.valueOf('F')) ? 13 : (internalTypeName.equals(String.valueOf('D')) ? 23 : 16)))))));
    }

    private static String appendDescriptorFromInternalType(String internalTypeName) {
        return internalTypeName.equals(String.valueOf('Z')) ? "(Z)Ljava/lang/StringBuilder;" : (internalTypeName.equals(String.valueOf('C')) ? "(C)Ljava/lang/StringBuilder;" : (internalTypeName.equals(String.valueOf('B')) || internalTypeName.equals(String.valueOf('S')) || internalTypeName.equals(String.valueOf('I')) ? "(I)Ljava/lang/StringBuilder;" : (internalTypeName.equals(String.valueOf('J')) ? "(J)Ljava/lang/StringBuilder;" : (internalTypeName.equals(String.valueOf('F')) ? "(F)Ljava/lang/StringBuilder;" : (internalTypeName.equals(String.valueOf('D')) ? "(D)Ljava/lang/StringBuilder;" : (internalTypeName.equals("java/lang/String") ? "(Ljava/lang/String;)Ljava/lang/StringBuilder;" : "(Ljava/lang/Object;)Ljava/lang/StringBuilder;"))))));
    }

    private static int nextArgIndex(String recipe, int fromIndex) {
        for (int i = fromIndex; i < recipe.length(); ++i) {
            char c = recipe.charAt(i);
            if (c != '\u0001' && c != '\u0002') continue;
            return i;
        }
        return recipe.length();
    }
}

