/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.core.convert.support;

import com.gradle.maven.extension.internal.dep.org.springframework.core.convert.ConversionFailedException;
import com.gradle.maven.extension.internal.dep.org.springframework.core.convert.TypeDescriptor;
import com.gradle.maven.extension.internal.dep.org.springframework.core.convert.converter.ConditionalGenericConverter;
import com.gradle.maven.extension.internal.dep.org.springframework.core.convert.converter.GenericConverter;
import com.gradle.maven.extension.internal.dep.org.springframework.util.ClassUtils;
import com.gradle.maven.extension.internal.dep.org.springframework.util.ConcurrentReferenceHashMap;
import com.gradle.maven.extension.internal.dep.org.springframework.util.ReflectionUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

final class ObjectToObjectConverter
implements ConditionalGenericConverter {
    private static final Map<Class<?>, Executable> conversionExecutableCache = new ConcurrentReferenceHashMap(32);

    ObjectToObjectConverter() {
    }

    @Override
    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return Collections.singleton(new GenericConverter.ConvertiblePair(Object.class, Object.class));
    }

    @Override
    public boolean matches(TypeDescriptor typeDescriptor, TypeDescriptor typeDescriptor2) {
        return typeDescriptor.getType() != typeDescriptor2.getType() && ObjectToObjectConverter.hasConversionMethodOrConstructor(typeDescriptor2.getType(), typeDescriptor.getType());
    }

    @Override
    public Object convert(Object object, TypeDescriptor typeDescriptor, TypeDescriptor typeDescriptor2) {
        if (object == null) {
            return null;
        }
        Class<?> clazz = typeDescriptor.getType();
        Class<?> clazz2 = typeDescriptor2.getType();
        Executable executable = ObjectToObjectConverter.getValidatedExecutable(clazz2, clazz);
        try {
            if (executable instanceof Method) {
                Method method = (Method)executable;
                ReflectionUtils.makeAccessible(method);
                if (!Modifier.isStatic(method.getModifiers())) {
                    return method.invoke(object, new Object[0]);
                }
                return method.invoke(null, object);
            }
            if (executable instanceof Constructor) {
                Constructor constructor = (Constructor)executable;
                ReflectionUtils.makeAccessible(constructor);
                return constructor.newInstance(object);
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new ConversionFailedException(typeDescriptor, typeDescriptor2, object, invocationTargetException.getTargetException());
        }
        catch (Throwable throwable) {
            throw new ConversionFailedException(typeDescriptor, typeDescriptor2, object, throwable);
        }
        throw new IllegalStateException(String.format("No to%3$s() method exists on %1$s, and no static valueOf/of/from(%1$s) method or %3$s(%1$s) constructor exists on %2$s.", clazz.getName(), clazz2.getName(), clazz2.getSimpleName()));
    }

    static boolean hasConversionMethodOrConstructor(Class<?> clazz, Class<?> clazz2) {
        return ObjectToObjectConverter.getValidatedExecutable(clazz, clazz2) != null;
    }

    private static Executable getValidatedExecutable(Class<?> clazz, Class<?> clazz2) {
        Executable executable = conversionExecutableCache.get(clazz);
        if (ObjectToObjectConverter.isApplicable(executable, clazz2)) {
            return executable;
        }
        executable = ObjectToObjectConverter.determineToMethod(clazz, clazz2);
        if (executable == null && (executable = ObjectToObjectConverter.determineFactoryMethod(clazz, clazz2)) == null && (executable = ObjectToObjectConverter.determineFactoryConstructor(clazz, clazz2)) == null) {
            return null;
        }
        conversionExecutableCache.put(clazz, executable);
        return executable;
    }

    private static boolean isApplicable(Executable executable, Class<?> clazz) {
        if (executable instanceof Method) {
            Method method = (Method)executable;
            return !Modifier.isStatic(method.getModifiers()) ? ClassUtils.isAssignable(method.getDeclaringClass(), clazz) : method.getParameterTypes()[0] == clazz;
        }
        if (executable instanceof Constructor) {
            Constructor constructor = (Constructor)executable;
            return constructor.getParameterTypes()[0] == clazz;
        }
        return false;
    }

    private static Method determineToMethod(Class<?> clazz, Class<?> clazz2) {
        if (String.class == clazz || String.class == clazz2) {
            return null;
        }
        Method method = ClassUtils.getMethodIfAvailable(clazz2, "to" + clazz.getSimpleName(), new Class[0]);
        return method != null && !Modifier.isStatic(method.getModifiers()) && ClassUtils.isAssignable(clazz, method.getReturnType()) ? method : null;
    }

    private static Method determineFactoryMethod(Class<?> clazz, Class<?> clazz2) {
        if (String.class == clazz) {
            return null;
        }
        Method method = ClassUtils.getStaticMethod(clazz, "valueOf", clazz2);
        if (method == null && (method = ClassUtils.getStaticMethod(clazz, "of", clazz2)) == null) {
            method = ClassUtils.getStaticMethod(clazz, "from", clazz2);
        }
        return method != null && ObjectToObjectConverter.areRelatedTypes(clazz, method.getReturnType()) ? method : null;
    }

    private static boolean areRelatedTypes(Class<?> clazz, Class<?> clazz2) {
        return ClassUtils.isAssignable(clazz, clazz2) || ClassUtils.isAssignable(clazz2, clazz);
    }

    private static Constructor<?> determineFactoryConstructor(Class<?> clazz, Class<?> clazz2) {
        return ClassUtils.getConstructorIfAvailable(clazz, clazz2);
    }
}

