/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.springframework.asm;

import com.gradle.maven.extension.internal.dep.org.springframework.asm.ByteVector;

public final class TypePath {
    private final byte[] typePathContainer;
    private final int typePathOffset;

    TypePath(byte[] byArray, int n2) {
        this.typePathContainer = byArray;
        this.typePathOffset = n2;
    }

    public int getLength() {
        return this.typePathContainer[this.typePathOffset];
    }

    public int getStep(int n2) {
        return this.typePathContainer[this.typePathOffset + 2 * n2 + 1];
    }

    public int getStepArgument(int n2) {
        return this.typePathContainer[this.typePathOffset + 2 * n2 + 2];
    }

    public String toString() {
        int n2 = this.getLength();
        StringBuilder stringBuilder = new StringBuilder(n2 * 2);
        block6: for (int i2 = 0; i2 < n2; ++i2) {
            switch (this.getStep(i2)) {
                case 0: {
                    stringBuilder.append('[');
                    continue block6;
                }
                case 1: {
                    stringBuilder.append('.');
                    continue block6;
                }
                case 2: {
                    stringBuilder.append('*');
                    continue block6;
                }
                case 3: {
                    stringBuilder.append(this.getStepArgument(i2)).append(';');
                    continue block6;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        return stringBuilder.toString();
    }

    static void put(TypePath typePath, ByteVector byteVector) {
        if (typePath == null) {
            byteVector.putByte(0);
        } else {
            int n2 = typePath.typePathContainer[typePath.typePathOffset] * 2 + 1;
            byteVector.putByteArray(typePath.typePathContainer, typePath.typePathOffset, n2);
        }
    }
}

