/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.codehaus.stax2.ri.typed;

public final class NumberUtil {
    public static final int MAX_INT_CLEN = 11;
    public static final int MAX_LONG_CLEN = 21;
    public static final int MAX_DOUBLE_CLEN = 32;
    public static final int MAX_FLOAT_CLEN = 32;
    private static final char NULL_CHAR = '\u0000';
    private static final int MILLION = 1000000;
    private static final int BILLION = 1000000000;
    private static final long TEN_BILLION_L = 10000000000L;
    private static final long THOUSAND_L = 1000L;
    private static final byte BYTE_HYPHEN = 45;
    private static final byte BYTE_1 = 49;
    private static final byte BYTE_2 = 50;
    private static long MIN_INT_AS_LONG = -2147483647L;
    private static long MAX_INT_AS_LONG = Integer.MAX_VALUE;
    static final char[] LEADING_TRIPLETS = new char[4000];
    static final char[] FULL_TRIPLETS = new char[4000];

    public static int writeInt(int n2, char[] cArray, int n3) {
        boolean bl2;
        if (n2 < 0) {
            if (n2 == Integer.MIN_VALUE) {
                return NumberUtil.writeLong((long)n2, cArray, n3);
            }
            cArray[n3++] = 45;
            n2 = -n2;
        }
        if (n2 < 1000000) {
            if (n2 < 1000) {
                if (n2 < 10) {
                    cArray[n3++] = (char)(48 + n2);
                } else {
                    n3 = NumberUtil.writeLeadingTriplet(n2, cArray, n3);
                }
            } else {
                int n4 = n2 / 1000;
                n3 = NumberUtil.writeLeadingTriplet(n4, cArray, n3);
                n3 = NumberUtil.writeFullTriplet(n2 -= n4 * 1000, cArray, n3);
            }
            return n3;
        }
        boolean bl3 = bl2 = n2 >= 1000000000;
        if (bl2) {
            if ((n2 -= 1000000000) >= 1000000000) {
                n2 -= 1000000000;
                cArray[n3++] = 50;
            } else {
                cArray[n3++] = 49;
            }
        }
        int n5 = n2 / 1000;
        int n6 = n2 - n5 * 1000;
        n2 = n5;
        int n7 = n2 - (n5 /= 1000) * 1000;
        n3 = bl2 ? NumberUtil.writeFullTriplet(n5, cArray, n3) : NumberUtil.writeLeadingTriplet(n5, cArray, n3);
        n3 = NumberUtil.writeFullTriplet(n7, cArray, n3);
        n3 = NumberUtil.writeFullTriplet(n6, cArray, n3);
        return n3;
    }

    public static int writeInt(int n2, byte[] byArray, int n3) {
        boolean bl2;
        if (n2 < 0) {
            if (n2 == Integer.MIN_VALUE) {
                return NumberUtil.writeLong((long)n2, byArray, n3);
            }
            byArray[n3++] = 45;
            n2 = -n2;
        }
        if (n2 < 1000000) {
            if (n2 < 1000) {
                if (n2 < 10) {
                    byArray[n3++] = (byte)(48 + n2);
                } else {
                    n3 = NumberUtil.writeLeadingTriplet(n2, byArray, n3);
                }
            } else {
                int n4 = n2 / 1000;
                n3 = NumberUtil.writeLeadingTriplet(n4, byArray, n3);
                n3 = NumberUtil.writeFullTriplet(n2 -= n4 * 1000, byArray, n3);
            }
            return n3;
        }
        boolean bl3 = bl2 = n2 >= 1000000000;
        if (bl2) {
            if ((n2 -= 1000000000) >= 1000000000) {
                n2 -= 1000000000;
                byArray[n3++] = 50;
            } else {
                byArray[n3++] = 49;
            }
        }
        int n5 = n2 / 1000;
        int n6 = n2 - n5 * 1000;
        n2 = n5;
        int n7 = n2 - (n5 /= 1000) * 1000;
        n3 = bl2 ? NumberUtil.writeFullTriplet(n5, byArray, n3) : NumberUtil.writeLeadingTriplet(n5, byArray, n3);
        n3 = NumberUtil.writeFullTriplet(n7, byArray, n3);
        n3 = NumberUtil.writeFullTriplet(n6, byArray, n3);
        return n3;
    }

    public static int writeLong(long l2, char[] cArray, int n2) {
        int n3;
        if (l2 < 0L) {
            if (l2 >= MIN_INT_AS_LONG) {
                return NumberUtil.writeInt((int)l2, cArray, n2);
            }
            if (l2 == Long.MIN_VALUE) {
                return NumberUtil.getChars(String.valueOf(l2), cArray, n2);
            }
            cArray[n2++] = 45;
            l2 = -l2;
        } else if (l2 <= MAX_INT_AS_LONG) {
            return NumberUtil.writeInt((int)l2, cArray, n2);
        }
        int n4 = n2;
        int n5 = n2 += NumberUtil.calcLongStrLength(l2);
        while (l2 > MAX_INT_AS_LONG) {
            long l3 = l2 / 1000L;
            n3 = (int)(l2 - l3 * 1000L);
            NumberUtil.writeFullTriplet(n3, cArray, n5 -= 3);
            l2 = l3;
        }
        int n6 = (int)l2;
        while (n6 >= 1000) {
            int n7 = n6 / 1000;
            n3 = n6 - n7 * 1000;
            NumberUtil.writeFullTriplet(n3, cArray, n5 -= 3);
            n6 = n7;
        }
        NumberUtil.writeLeadingTriplet(n6, cArray, n4);
        return n2;
    }

    public static int writeLong(long l2, byte[] byArray, int n2) {
        int n3;
        if (l2 < 0L) {
            if (l2 >= MIN_INT_AS_LONG) {
                return NumberUtil.writeInt((int)l2, byArray, n2);
            }
            if (l2 == Long.MIN_VALUE) {
                return NumberUtil.getAsciiBytes(String.valueOf(l2), byArray, n2);
            }
            byArray[n2++] = 45;
            l2 = -l2;
        } else if (l2 <= MAX_INT_AS_LONG) {
            return NumberUtil.writeInt((int)l2, byArray, n2);
        }
        int n4 = n2;
        int n5 = n2 += NumberUtil.calcLongStrLength(l2);
        while (l2 > MAX_INT_AS_LONG) {
            long l3 = l2 / 1000L;
            n3 = (int)(l2 - l3 * 1000L);
            NumberUtil.writeFullTriplet(n3, byArray, n5 -= 3);
            l2 = l3;
        }
        int n6 = (int)l2;
        while (n6 >= 1000) {
            int n7 = n6 / 1000;
            n3 = n6 - n7 * 1000;
            NumberUtil.writeFullTriplet(n3, byArray, n5 -= 3);
            n6 = n7;
        }
        NumberUtil.writeLeadingTriplet(n6, byArray, n4);
        return n2;
    }

    public static int writeFloat(float f2, char[] cArray, int n2) {
        return NumberUtil.getChars(String.valueOf(f2), cArray, n2);
    }

    public static int writeFloat(float f2, byte[] byArray, int n2) {
        return NumberUtil.getAsciiBytes(String.valueOf(f2), byArray, n2);
    }

    public static int writeDouble(double d2, char[] cArray, int n2) {
        return NumberUtil.getChars(String.valueOf(d2), cArray, n2);
    }

    public static int writeDouble(double d2, byte[] byArray, int n2) {
        return NumberUtil.getAsciiBytes(String.valueOf(d2), byArray, n2);
    }

    private static int writeLeadingTriplet(int n2, char[] cArray, int n3) {
        char c2;
        int n4 = n2 << 2;
        if ((c2 = LEADING_TRIPLETS[n4++]) != '\u0000') {
            cArray[n3++] = c2;
        }
        if ((c2 = LEADING_TRIPLETS[n4++]) != '\u0000') {
            cArray[n3++] = c2;
        }
        cArray[n3++] = LEADING_TRIPLETS[n4];
        return n3;
    }

    private static int writeLeadingTriplet(int n2, byte[] byArray, int n3) {
        char c2;
        int n4 = n2 << 2;
        if ((c2 = LEADING_TRIPLETS[n4++]) != '\u0000') {
            byArray[n3++] = (byte)c2;
        }
        if ((c2 = LEADING_TRIPLETS[n4++]) != '\u0000') {
            byArray[n3++] = (byte)c2;
        }
        byArray[n3++] = (byte)LEADING_TRIPLETS[n4];
        return n3;
    }

    private static int writeFullTriplet(int n2, char[] cArray, int n3) {
        int n4 = n2 << 2;
        cArray[n3++] = FULL_TRIPLETS[n4++];
        cArray[n3++] = FULL_TRIPLETS[n4++];
        cArray[n3++] = FULL_TRIPLETS[n4];
        return n3;
    }

    private static int writeFullTriplet(int n2, byte[] byArray, int n3) {
        int n4 = n2 << 2;
        byArray[n3++] = (byte)FULL_TRIPLETS[n4++];
        byArray[n3++] = (byte)FULL_TRIPLETS[n4++];
        byArray[n3++] = (byte)FULL_TRIPLETS[n4];
        return n3;
    }

    private static int calcLongStrLength(long l2) {
        int n2;
        long l3 = 10000000000L;
        for (n2 = 10; l2 >= l3 && n2 != 19; ++n2) {
            l3 = (l3 << 3) + (l3 << 1);
        }
        return n2;
    }

    private static int getChars(String string, char[] cArray, int n2) {
        int n3 = string.length();
        string.getChars(0, n3, cArray, n2);
        return n2 + n3;
    }

    private static int getAsciiBytes(String string, byte[] byArray, int n2) {
        int n3 = string.length();
        for (int i2 = 0; i2 < n3; ++i2) {
            byArray[n2++] = (byte)string.charAt(i2);
        }
        return n2;
    }

    static {
        int n2 = 0;
        for (int i2 = 0; i2 < 10; ++i2) {
            char c2 = (char)(48 + i2);
            char c3 = i2 == 0 ? (char)'\u0000' : c2;
            for (int i3 = 0; i3 < 10; ++i3) {
                char c4 = (char)(48 + i3);
                char c5 = i2 == 0 && i3 == 0 ? (char)'\u0000' : c4;
                for (int i4 = 0; i4 < 10; ++i4) {
                    char c6 = (char)(48 + i4);
                    NumberUtil.LEADING_TRIPLETS[n2] = c3;
                    NumberUtil.LEADING_TRIPLETS[n2 + 1] = c5;
                    NumberUtil.LEADING_TRIPLETS[n2 + 2] = c6;
                    NumberUtil.FULL_TRIPLETS[n2] = c2;
                    NumberUtil.FULL_TRIPLETS[n2 + 1] = c4;
                    NumberUtil.FULL_TRIPLETS[n2 + 2] = c6;
                    n2 += 4;
                }
            }
        }
    }
}

