/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.type;

import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.library.ClassLibrary;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaClass;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TypeResolver {
    private static final Set<String> PRIMITIVE_TYPES = new HashSet<String>();
    private final Map<String, String> resolvedTypeCache = new HashMap<String, String>();
    private final String pckg;
    private final String declaringClass;
    private final ClassLibrary classLibrary;
    private final Collection<String> imports;

    private TypeResolver(String string, String string2, ClassLibrary classLibrary, Collection<String> collection) {
        this.pckg = string;
        this.declaringClass = string2;
        this.classLibrary = classLibrary;
        this.imports = collection != null ? collection : Collections.emptyList();
    }

    public static TypeResolver byPackageName(String string, ClassLibrary classLibrary, Collection<String> collection) {
        return new TypeResolver(string, null, classLibrary, collection);
    }

    public static TypeResolver byClassName(String string, ClassLibrary classLibrary, Collection<String> collection) {
        int n2 = string.lastIndexOf(46);
        String string2 = n2 > 0 ? string.substring(0, n2) : null;
        return new TypeResolver(string2, string, classLibrary, collection);
    }

    public JavaClass getJavaClass(String string) {
        return this.classLibrary.getJavaClass(string);
    }

    public String resolveType(String string) {
        String string2 = this.resolvedTypeCache.get(string);
        if (string2 == null) {
            if (this.declaringClass != null) {
                String string3;
                int n2 = this.declaringClass.indexOf(36);
                while (string2 == null && n2 > 0) {
                    string3 = this.declaringClass.substring(0, n2 + 1) + string;
                    string2 = this.resolveFromLibrary(string3);
                    n2 = this.declaringClass.indexOf(36, n2 + 1);
                }
                if (string2 == null) {
                    string3 = this.declaringClass + '$' + string.replace('.', '$');
                    string2 = this.resolveFromLibrary(string3);
                }
            }
            if (string2 == null) {
                string2 = this.resolveTypeInternal(string);
            }
            if (string2 != null) {
                this.resolvedTypeCache.put(string, string2);
            }
        }
        return string2;
    }

    private String resolveTypeInternal(String string) {
        String string2 = null;
        if (PRIMITIVE_TYPES.contains(string)) {
            string2 = string;
        } else {
            String string3 = string;
            String string4 = string.replace('.', '$');
            int n2 = string.indexOf(46);
            if (n2 >= 0) {
                string3 = string.substring(0, n2);
            }
            if ((string2 = this.resolveImportedType(string, string4, true)) != null || (string2 = this.resolveImportedType(string3, string4, false)) != null || this.pckg != null && (string2 = this.resolveFullyQualifiedType(this.pckg + '.' + string)) != null || (string2 = this.resolveFullyQualifiedType(string)) != null || this.pckg != null && (string2 = this.resolveFromLibrary(this.pckg + "$" + string4)) != null || (string2 = this.resolveFromLibrary("java.lang." + string4)) != null || (string2 = this.resolveImportedType("*", string4, false)) == null) {
                // empty if block
            }
        }
        return string2;
    }

    private String resolveImportedType(String string, String string2, boolean bl2) {
        String string3 = null;
        String string4 = "." + string;
        for (String string5 : this.imports) {
            if (string5.startsWith("static ")) {
                string5 = string5.substring(7);
            }
            if (!string5.equals(string) && (bl2 || !string5.endsWith(string4))) continue;
            String string6 = string5.equals(string) ? string5 : string5.substring(0, string5.length() - string.length()) + string2;
            string3 = this.resolveFullyQualifiedType(string6);
            if (string3 == null && !"*".equals(string)) {
                string3 = string6;
            }
            if (string3 == null) continue;
            break;
        }
        return string3;
    }

    private String resolveFromLibrary(String string) {
        return this.classLibrary.hasClassReference(string) ? string : null;
    }

    private String resolveFullyQualifiedType(String string) {
        int n2 = string.lastIndexOf(46);
        if (n2 >= 0) {
            String string2 = string.substring(0, n2);
            String string3 = string.substring(n2 + 1);
            String string4 = this.resolveFullyQualifiedType(string2 + '$' + string3);
            if (string4 != null) {
                return string4;
            }
        }
        if (this.classLibrary.hasClassReference(string)) {
            return string;
        }
        return null;
    }

    static {
        PRIMITIVE_TYPES.add("boolean");
        PRIMITIVE_TYPES.add("byte");
        PRIMITIVE_TYPES.add("char");
        PRIMITIVE_TYPES.add("double");
        PRIMITIVE_TYPES.add("float");
        PRIMITIVE_TYPES.add("int");
        PRIMITIVE_TYPES.add("long");
        PRIMITIVE_TYPES.add("short");
        PRIMITIVE_TYPES.add("void");
    }
}

