/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.parser.impl;

import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.builder.Builder;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.parser.structs.ClassDef;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.parser.structs.FieldDef;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.parser.structs.MethodDef;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.parser.structs.PackageDef;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.parser.structs.TypeDef;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Set;
import java.util.StringTokenizer;

public class BinaryClassParser {
    private Class<?> declaringClazz;
    private Builder binaryBuilder;

    public BinaryClassParser(Class<?> clazz, Builder builder) {
        this.declaringClazz = clazz;
        this.binaryBuilder = builder;
    }

    public boolean parse() {
        try {
            if (this.declaringClazz.getPackage() != null && !"".equals(this.declaringClazz.getPackage().getName())) {
                this.binaryBuilder.addPackage(new PackageDef(this.declaringClazz.getPackage().getName()));
            }
            this.addClass(this.declaringClazz);
            return true;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return false;
        }
    }

    private void addClass(Class<?> clazz) {
        Class<?> clazz2;
        ClassDef classDef = new ClassDef(clazz.getSimpleName());
        Class<?>[] classArray = clazz.getInterfaces();
        if (clazz.isEnum()) {
            classDef.setType("enum");
        } else if (clazz.isAnnotation()) {
            classDef.setType("@interface");
        } else if (clazz.isInterface()) {
            classDef.setType("interface");
            for (int i2 = 0; i2 < classArray.length; ++i2) {
                clazz2 = classArray[i2];
                classDef.getExtends().add(new TypeDef(clazz2.getName()));
            }
        } else {
            for (int i3 = 0; i3 < classArray.length; ++i3) {
                clazz2 = classArray[i3];
                classDef.getImplements().add(new TypeDef(clazz2.getName()));
            }
            Class<?> clazz3 = clazz.getSuperclass();
            if (clazz3 != null) {
                classDef.getExtends().add(new TypeDef(clazz3.getName()));
            }
        }
        BinaryClassParser.addModifiers(classDef.getModifiers(), clazz.getModifiers());
        this.binaryBuilder.beginClass(classDef);
        Constructor<?>[] constructorArray = clazz.getDeclaredConstructors();
        for (int i4 = 0; i4 < constructorArray.length; ++i4) {
            this.binaryBuilder.beginConstructor();
            MethodDef methodDef = this.createMethodDef(constructorArray[i4]);
            this.binaryBuilder.endConstructor(methodDef);
        }
        Method[] methodArray = clazz.getDeclaredMethods();
        for (int i5 = 0; i5 < methodArray.length; ++i5) {
            this.binaryBuilder.beginMethod();
            MethodDef methodDef = this.createMethodDef(methodArray[i5]);
            this.binaryBuilder.endMethod(methodDef);
        }
        Field[] fieldArray = clazz.getDeclaredFields();
        for (int i6 = 0; i6 < fieldArray.length; ++i6) {
            this.addField(fieldArray[i6]);
        }
        Class<?>[] classArray2 = clazz.getDeclaredClasses();
        for (int i7 = 0; i7 < classArray2.length; ++i7) {
            this.addClass(classArray2[i7]);
        }
        this.binaryBuilder.endClass();
    }

    private static void addModifiers(Set<String> set, int n2) {
        String string = Modifier.toString(n2);
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            set.add(stringTokenizer.nextToken());
        }
    }

    private void addField(Field field) {
        FieldDef fieldDef = new FieldDef(field.getName());
        Class<?> clazz = field.getType();
        fieldDef.setType(BinaryClassParser.getTypeDef(clazz));
        fieldDef.setDimensions(BinaryClassParser.getDimension(clazz));
        fieldDef.setEnumConstant(field.isEnumConstant());
        BinaryClassParser.addModifiers(fieldDef.getModifiers(), field.getModifiers());
        this.binaryBuilder.beginField(fieldDef);
        this.binaryBuilder.endField();
    }

    private MethodDef createMethodDef(Member member) {
        Object object;
        int n2;
        Class<?>[] classArray;
        Class<?>[] classArray2;
        MethodDef methodDef = new MethodDef();
        int n3 = member.getName().lastIndexOf(46);
        methodDef.setName(member.getName().substring(n3 + 1));
        BinaryClassParser.addModifiers(methodDef.getModifiers(), member.getModifiers());
        if (member instanceof Method) {
            methodDef.setConstructor(false);
            classArray2 = ((Method)member).getExceptionTypes();
            classArray = ((Method)member).getParameterTypes();
            Class<?> clazz = ((Method)member).getReturnType();
            methodDef.setReturnType(BinaryClassParser.getTypeDef(clazz));
            methodDef.setDimensions(BinaryClassParser.getDimension(clazz));
        } else {
            methodDef.setConstructor(true);
            classArray2 = ((Constructor)member).getExceptionTypes();
            classArray = ((Constructor)member).getParameterTypes();
        }
        for (n2 = 0; n2 < classArray2.length; ++n2) {
            object = classArray2[n2];
            methodDef.getExceptions().add(BinaryClassParser.getTypeDef(object));
        }
        for (n2 = 0; n2 < classArray.length; ++n2) {
            object = new FieldDef("p" + n2);
            Class<?> clazz = classArray[n2];
            ((FieldDef)object).setType(BinaryClassParser.getTypeDef(clazz));
            ((FieldDef)object).setDimensions(BinaryClassParser.getDimension(clazz));
            this.binaryBuilder.addParameter((FieldDef)object);
        }
        return methodDef;
    }

    private static int getDimension(Class<?> clazz) {
        return clazz.getName().lastIndexOf(91) + 1;
    }

    private static String getTypeName(Class<?> clazz) {
        return clazz.getComponentType() != null ? clazz.getComponentType().getName() : clazz.getName();
    }

    private static TypeDef getTypeDef(Class<?> clazz) {
        return new TypeDef(BinaryClassParser.getTypeName(clazz));
    }
}

