/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.impl;

import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.library.ClassLibrary;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaClass;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaConstructor;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaField;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaInitializer;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaMethod;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaPackage;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaSource;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.JavaType;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.impl.AbstractInheritableJavaEntity;
import com.gradle.maven.extension.internal.dep.com.thoughtworks.qdox.model.impl.DefaultJavaTypeVariable;
import java.util.LinkedList;
import java.util.List;

public class DefaultJavaClass
extends AbstractInheritableJavaEntity
implements JavaClass {
    private List<JavaConstructor> constructors = new LinkedList<JavaConstructor>();
    private List<JavaMethod> methods = new LinkedList<JavaMethod>();
    private List<JavaField> fields = new LinkedList<JavaField>();
    private List<JavaClass> classes = new LinkedList<JavaClass>();
    private boolean anInterface;
    private boolean anEnum;
    private boolean anAnnotation;
    private JavaType superClass;
    private List<JavaClass> implementz = new LinkedList<JavaClass>();
    private List<JavaInitializer> initializers = new LinkedList<JavaInitializer>();
    private List<DefaultJavaTypeVariable<JavaClass>> typeParameters = new LinkedList<DefaultJavaTypeVariable<JavaClass>>();
    private JavaPackage javaPackage;

    protected DefaultJavaClass() {
    }

    public DefaultJavaClass(String string) {
        this.setName(string);
    }

    public DefaultJavaClass(JavaSource javaSource) {
        this.setSource(javaSource);
    }

    @Override
    public boolean isInterface() {
        return this.anInterface;
    }

    public boolean isPrimitive() {
        String string = this.getName();
        return "void".equals(string) || "boolean".equals(string) || "byte".equals(string) || "char".equals(string) || "short".equals(string) || "int".equals(string) || "long".equals(string) || "float".equals(string) || "double".equals(string);
    }

    @Override
    public boolean isEnum() {
        return this.anEnum;
    }

    @Override
    public boolean isAnnotation() {
        return this.anAnnotation;
    }

    @Override
    public JavaType getSuperClass() {
        JavaType javaType = null;
        if (this.isPrimitive()) {
            return null;
        }
        JavaClass javaClass = this.getJavaClassLibrary().getJavaClass("java.lang.Object");
        JavaClass javaClass2 = this.getJavaClassLibrary().getJavaClass("java.lang.Enum");
        boolean bl2 = javaClass.equals(this);
        javaType = this.anEnum ? javaClass2 : (!this.anInterface && !this.anAnnotation && this.superClass == null && !bl2 ? javaClass : this.superClass);
        return javaType;
    }

    @Override
    public List<JavaType> getImplements() {
        return new LinkedList<JavaType>(this.implementz);
    }

    public void setInterface(boolean bl2) {
        this.anInterface = bl2;
    }

    public void setEnum(boolean bl2) {
        this.anEnum = bl2;
    }

    public void setAnnotation(boolean bl2) {
        this.anAnnotation = bl2;
    }

    public void addConstructor(JavaConstructor javaConstructor) {
        this.constructors.add(javaConstructor);
    }

    public void addMethod(JavaMethod javaMethod) {
        this.methods.add(javaMethod);
    }

    public void setSuperClass(JavaType javaType) {
        if (this.anEnum) {
            throw new IllegalArgumentException("enums cannot extend other classes");
        }
        this.superClass = javaType;
    }

    public void setImplementz(List<JavaClass> list) {
        this.implementz = list;
    }

    public List<DefaultJavaTypeVariable<JavaClass>> getTypeParameters() {
        return this.typeParameters;
    }

    public void setTypeParameters(List<DefaultJavaTypeVariable<JavaClass>> list) {
        this.typeParameters = list;
    }

    public void addField(JavaField javaField) {
        this.fields.add(javaField);
    }

    @Override
    public JavaSource getParentSource() {
        return this.getDeclaringClass() != null ? this.getDeclaringClass().getParentSource() : super.getSource();
    }

    @Override
    public JavaSource getSource() {
        return this.getParentSource();
    }

    public JavaPackage getPackage() {
        return this.getParentSource() != null ? this.getParentSource().getPackage() : this.javaPackage;
    }

    @Override
    public String getPackageName() {
        JavaPackage javaPackage = this.getPackage();
        return javaPackage != null && javaPackage.getName() != null ? javaPackage.getName() : "";
    }

    public String getSimpleName() {
        return this.getName();
    }

    @Override
    public String getBinaryName() {
        return this.getDeclaringClass() == null ? this.getCanonicalName() : this.getDeclaringClass().getBinaryName() + '$' + this.getSimpleName();
    }

    @Override
    public String getFullyQualifiedName() {
        if (this.isPrimitive()) {
            return this.getName();
        }
        if (this.getDeclaringClass() == null) {
            return (this.getPackage() == null ? "" : this.getPackage().getName() + '.') + this.getSimpleName();
        }
        return this.getDeclaringClass().getFullyQualifiedName() + "." + this.getSimpleName();
    }

    @Override
    public String getCanonicalName() {
        return this.getFullyQualifiedName().replace('$', '.');
    }

    @Override
    public String getGenericCanonicalName() {
        return this.getCanonicalName();
    }

    @Override
    public String getValue() {
        return this.getCanonicalName().substring(this.getSource().getClassNamePrefix().length());
    }

    @Override
    public List<JavaConstructor> getConstructors() {
        return this.constructors;
    }

    @Override
    public List<JavaMethod> getMethods() {
        return this.methods;
    }

    @Override
    public List<JavaField> getFields() {
        return this.fields;
    }

    @Override
    public JavaField getFieldByName(String string) {
        for (JavaField javaField : this.getFields()) {
            if (!javaField.getName().equals(string)) continue;
            return javaField;
        }
        return null;
    }

    public void addInitializer(JavaInitializer javaInitializer) {
        this.initializers.add(javaInitializer);
    }

    public void addClass(JavaClass javaClass) {
        this.classes.add(javaClass);
    }

    @Override
    public List<JavaClass> getNestedClasses() {
        return this.classes;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.isPrimitive()) {
            stringBuilder.append(this.getName());
        } else {
            stringBuilder.append(this.isInterface() ? "interface" : "class");
            stringBuilder.append(" ");
            stringBuilder.append(this.getFullyQualifiedName());
        }
        return stringBuilder.toString();
    }

    public int hashCode() {
        return 2 + this.getFullyQualifiedName().hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof JavaClass)) {
            return false;
        }
        JavaClass javaClass = (JavaClass)object;
        return this.getFullyQualifiedName().equals(javaClass.getFullyQualifiedName());
    }

    public ClassLibrary getJavaClassLibrary() {
        return this.getSource().getJavaClassLibrary();
    }
}

