/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv.relaxng_datatype.Datatype;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.AnyURIType;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.BuiltinAtomicType;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.DurationType;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.GDayType;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.GMonthDayType;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.GMonthType;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.GYearMonthType;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.GYearType;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.NormalizedStringType;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.NumberType;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.datatype.xsd.XSDatatype;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.Expression;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.ExpressionPool;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.Grammar;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.IDContextProvider2;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.ReferenceContainer;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.grammar.ReferenceExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.AbortException;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.Controller;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.DOMLSInput;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.GrammarReaderController;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.State;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.reader.datatype.xsd.XSDatatypeExp;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.util.StartTagInfo;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.util.Uri;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.shaded.msv_core.verifier.regexp.StringToken;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import org.w3c.dom.ls.LSInput;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.LocatorImpl;
import org.xml.sax.helpers.XMLFilterImpl;

public abstract class GrammarReader
extends XMLFilterImpl
implements IDContextProvider2 {
    private Locator locator;
    public final Controller controller;
    public final SAXParserFactory parserFactory;
    public final ExpressionPool pool;
    public static final PrefixResolver basePrefixResolver = new PrefixResolver(){

        public String resolve(String string) {
            if (string.equals("xml")) {
                return "http://www.w3.org/XML/1998/namespace";
            }
            return null;
        }
    };
    public PrefixResolver prefixResolver = basePrefixResolver;
    private InclusionContext pendingIncludes;
    public final BackwardReferenceMap backwardReference = new BackwardReferenceMap();
    private final Map declaredLocations = new HashMap();
    private final Vector backPatchJobs = new Vector();
    private final Vector delayedBackPatchJobs = new Vector();
    public static final String ERR_MALPLACED_ELEMENT = "GrammarReader.MalplacedElement";
    public static final String ERR_CHARACTERS = "GrammarReader.Characters";
    public static final String ERR_DISALLOWED_ATTRIBUTE = "GrammarReader.DisallowedAttribute";
    public static final String ERR_MISSING_ATTRIBUTE = "GrammarReader.MissingAttribute";
    public static final String ERR_BAD_ATTRIBUTE_VALUE = "GrammarReader.BadAttributeValue";
    public static final String ERR_MISSING_ATTRIBUTE_2 = "GrammarReader.MissingAttribute.2";
    public static final String ERR_CONFLICTING_ATTRIBUTES = "GrammarReader.ConflictingAttribute";
    public static final String ERR_RECURSIVE_INCLUDE = "GrammarReader.RecursiveInclude";
    public static final String ERR_FRAGMENT_IDENTIFIER = "GrammarReader.FragmentIdentifier";
    public static final String ERR_UNDEFINED_DATATYPE = "GrammarReader.UndefinedDataType";
    public static final String ERR_DATATYPE_ALREADY_DEFINED = "GrammarReader.DataTypeAlreadyDefined";
    public static final String ERR_MISSING_CHILD_EXPRESSION = "GrammarReader.Abstract.MissingChildExpression";
    public static final String ERR_MORE_THAN_ONE_CHILD_EXPRESSION = "GrammarReader.Abstract.MoreThanOneChildExpression";
    public static final String ERR_MORE_THAN_ONE_CHILD_TYPE = "GrammarReader.Abstract.MoreThanOneChildType";
    public static final String ERR_MISSING_CHILD_TYPE = "GrammarReader.Abstract.MissingChildType";
    public static final String ERR_ILLEGAL_FINAL_VALUE = "GrammarReader.IllegalFinalValue";
    public static final String ERR_RUNAWAY_EXPRESSION = "GrammarReader.Abstract.RunAwayExpression";
    public static final String ERR_MISSING_TOPLEVEL = "GrammarReader.Abstract.MissingTopLevel";
    public static final String WRN_MAYBE_WRONG_NAMESPACE = "GrammarReader.Warning.MaybeWrongNamespace";
    public static final String WRN_DEPRECATED_TYPENAME = "GrammarReader.Warning.DeprecatedTypeName";
    public static final String ERR_BAD_TYPE = "GrammarReader.BadType";
    public static final String ERR_RECURSIVE_DATATYPE = "GrammarReader.RecursiveDatatypeDefinition";

    protected static SAXParserFactory createParserFactory() {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setNamespaceAware(true);
        return sAXParserFactory;
    }

    protected GrammarReader(GrammarReaderController grammarReaderController, SAXParserFactory sAXParserFactory, ExpressionPool expressionPool, State state) {
        this.controller = new Controller(grammarReaderController);
        this.parserFactory = sAXParserFactory;
        if (sAXParserFactory != null && !sAXParserFactory.isNamespaceAware()) {
            throw new IllegalArgumentException("parser factory must be namespace-aware");
        }
        this.pool = expressionPool;
        this.pushState(state, null, null);
    }

    public abstract Grammar getResultAsGrammar();

    protected abstract boolean isGrammarElement(StartTagInfo var1);

    public void startPrefixMapping(String string, String string2) throws SAXException {
        this.prefixResolver = new ChainPrefixResolver(string, string2);
        super.startPrefixMapping(string, string2);
    }

    public void endPrefixMapping(String string) throws SAXException {
        this.prefixResolver = ((ChainPrefixResolver)this.prefixResolver).previous;
        super.endPrefixMapping(string);
    }

    public Iterator iterateInscopeNamespaces() {
        return new Iterator(){
            private PrefixResolver resolver;
            {
                this.resolver = this.proceed(GrammarReader.this.prefixResolver);
            }

            public Object next() {
                final ChainPrefixResolver chainPrefixResolver = (ChainPrefixResolver)this.resolver;
                this.resolver = this.proceed(chainPrefixResolver.previous);
                return new Map.Entry(){

                    public Object getKey() {
                        return chainPrefixResolver.prefix;
                    }

                    public Object getValue() {
                        return chainPrefixResolver.uri;
                    }

                    public Object setValue(Object object) {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            public boolean hasNext() {
                return this.resolver instanceof ChainPrefixResolver;
            }

            private PrefixResolver proceed(PrefixResolver prefixResolver) {
                while (prefixResolver instanceof ChainPrefixResolver) {
                    ChainPrefixResolver chainPrefixResolver = (ChainPrefixResolver)prefixResolver;
                    if (GrammarReader.this.resolveNamespacePrefix(chainPrefixResolver.prefix) == chainPrefixResolver.uri) {
                        return prefixResolver;
                    }
                    prefixResolver = chainPrefixResolver.previous;
                }
                return prefixResolver;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public String[] splitQName(String string) {
        int n2 = string.indexOf(58);
        if (n2 < 0) {
            String string2 = this.prefixResolver.resolve("");
            if (string2 == null) {
                string2 = "";
            }
            return new String[]{string2, string, string};
        }
        String string3 = this.prefixResolver.resolve(string.substring(0, n2));
        if (string3 == null) {
            return null;
        }
        return new String[]{string3, string.substring(n2 + 1), string};
    }

    protected Expression interceptExpression(State state, Expression expression) {
        return expression;
    }

    public XSDatatype getBackwardCompatibleType(String string) {
        BuiltinAtomicType builtinAtomicType = null;
        if (string.equals("uriReference")) {
            builtinAtomicType = AnyURIType.theInstance;
        } else if (string.equals("number")) {
            builtinAtomicType = NumberType.theInstance;
        } else if (string.equals("timeDuration")) {
            builtinAtomicType = DurationType.theInstance;
        } else if (string.equals("CDATA")) {
            builtinAtomicType = NormalizedStringType.theInstance;
        } else if (string.equals("year")) {
            builtinAtomicType = GYearType.theInstance;
        } else if (string.equals("yearMonth")) {
            builtinAtomicType = GYearMonthType.theInstance;
        } else if (string.equals("month")) {
            builtinAtomicType = GMonthType.theInstance;
        } else if (string.equals("monthDay")) {
            builtinAtomicType = GMonthDayType.theInstance;
        } else if (string.equals("day")) {
            builtinAtomicType = GDayType.theInstance;
        }
        if (builtinAtomicType != null) {
            this.reportWarning(WRN_DEPRECATED_TYPENAME, string, builtinAtomicType.displayName());
        }
        return builtinAtomicType;
    }

    private void pushInclusionContext() {
        this.pendingIncludes = new InclusionContext(this.prefixResolver, this.getLocator(), this.getLocator().getSystemId(), this.pendingIncludes);
        this.prefixResolver = basePrefixResolver;
        this.setLocator(null);
    }

    private void popInclusionContext() {
        this.prefixResolver = this.pendingIncludes.prefixResolver;
        this.setLocator(this.pendingIncludes.locator);
        this.pendingIncludes = this.pendingIncludes.previousContext;
    }

    public final InputSource resolveLocation(State state, String string) throws AbortException {
        try {
            string = this.combineURI(state.getBaseURI(), string);
            InputSource inputSource = this.controller.resolveEntity(null, string);
            if (inputSource == null) {
                return new InputSource(string);
            }
            return inputSource;
        }
        catch (IOException iOException) {
            this.controller.error(iOException, this.getLocator());
        }
        catch (SAXException sAXException) {
            this.controller.error(sAXException, this.getLocator());
        }
        throw AbortException.theInstance;
    }

    public final String combineURI(String string, String string2) {
        return Uri.resolve(string, string2);
    }

    public final String combineURL(String string, String string2) {
        return Uri.resolve(string, string2);
    }

    public void switchSource(State state, String string, State state2) throws AbortException {
        if (string.indexOf(35) >= 0) {
            this.reportError(ERR_FRAGMENT_IDENTIFIER, (Object)string);
            throw AbortException.theInstance;
        }
        this.switchSource(this.resolveLocation(state, string), state2);
    }

    public void switchSource(InputSource inputSource, State state) {
        this.switchSource(new SAXSource(inputSource), state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchSource(Source source, State state) {
        String string = source.getSystemId();
        Object object = this.pendingIncludes;
        while (object != null) {
            if (((InclusionContext)object).systemId != null && ((InclusionContext)object).systemId.equals(string)) {
                String string2 = "";
                InclusionContext inclusionContext = this.pendingIncludes;
                while (inclusionContext != object) {
                    string2 = inclusionContext.systemId + " > " + string2;
                    inclusionContext = inclusionContext.previousContext;
                }
                string2 = string + " > " + string2 + string;
                this.reportError(ERR_RECURSIVE_INCLUDE, (Object)string2);
                return;
            }
            object = ((InclusionContext)object).previousContext;
        }
        this.pushInclusionContext();
        object = this.getCurrentState();
        try {
            this.pushState(state, null, null);
            try {
                this.parse(source);
            }
            catch (TransformerConfigurationException transformerConfigurationException) {
                this.controller.error("transform error", transformerConfigurationException);
            }
            catch (TransformerException transformerException) {
                this.controller.error("transform error", transformerException);
            }
        }
        finally {
            super.setContentHandler((ContentHandler)object);
            this.popInclusionContext();
        }
    }

    public final void parse(String string) {
        this._parse(string, null);
    }

    public final void parse(InputSource inputSource) {
        this._parse(inputSource, null);
    }

    public void parse(Source source) throws TransformerConfigurationException, TransformerException {
        InputSource inputSource = SAXSource.sourceToInputSource(source);
        if (inputSource != null) {
            this.parse(inputSource);
        } else {
            LocatorImpl locatorImpl = new LocatorImpl();
            locatorImpl.setSystemId(source.getSystemId());
            this.setLocator(locatorImpl);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            SAXResult sAXResult = new SAXResult(this);
            transformerFactory.newTransformer().transform(source, sAXResult);
        }
    }

    public final void _parse(Object object, Locator locator) {
        try {
            XMLReader xMLReader = this.parserFactory.newSAXParser().getXMLReader();
            xMLReader.setContentHandler(this);
            xMLReader.setErrorHandler(this.controller);
            xMLReader.setEntityResolver(this.controller);
            if (object instanceof InputSource) {
                xMLReader.parse((InputSource)object);
            }
            if (object instanceof String) {
                xMLReader.parse((String)object);
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            this.controller.error(parserConfigurationException, locator);
        }
        catch (IOException iOException) {
            this.controller.error(iOException, locator);
        }
        catch (SAXParseException sAXParseException) {
            this.controller.error(sAXParseException);
        }
        catch (SAXException sAXException) {
            this.controller.error(sAXException, locator);
        }
    }

    public void setDeclaredLocationOf(Object object) {
        this.declaredLocations.put(object, new LocatorImpl(this.getLocator()));
    }

    public Locator getDeclaredLocationOf(Object object) {
        return (Locator)this.declaredLocations.get(object);
    }

    public void detectUndefinedOnes(ReferenceContainer referenceContainer, String string) {
        Iterator iterator = referenceContainer.iterator();
        while (iterator.hasNext()) {
            ReferenceExp referenceExp = (ReferenceExp)iterator.next();
            if (referenceExp.isDefined()) continue;
            this.reportError(this.backwardReference.getReferer(referenceExp), string, new Object[]{referenceExp.name});
            referenceExp.exp = Expression.nullSet;
        }
    }

    public void pushState(State state, State state2, StartTagInfo startTagInfo) {
        super.setContentHandler(state);
        state.init(this, state2, startTagInfo);
    }

    public void popState() {
        State state = this.getCurrentState();
        if (state.parentState != null) {
            super.setContentHandler(state.parentState);
        } else {
            super.setContentHandler(new DefaultHandler());
        }
    }

    public final State getCurrentState() {
        return (State)super.getContentHandler();
    }

    public abstract State createExpressionChildState(State var1, StartTagInfo var2);

    public void setDocumentLocator(Locator locator) {
        super.setDocumentLocator(locator);
        this.setLocator(locator);
    }

    public String resolveNamespacePrefix(String string) {
        return this.prefixResolver.resolve(string);
    }

    public boolean isUnparsedEntity(String string) {
        return true;
    }

    public boolean isNotation(String string) {
        return true;
    }

    public String getBaseUri() {
        return this.getCurrentState().getBaseURI();
    }

    public final void onID(Datatype datatype, StringToken stringToken) {
    }

    public final void addBackPatchJob(BackPatch backPatch) {
        this.backPatchJobs.add(backPatch);
    }

    public final void addBackPatchJob(XSDatatypeExp xSDatatypeExp) {
        this.delayedBackPatchJobs.add(xSDatatypeExp);
    }

    public final void runBackPatchJob() {
        Locator locator = this.getLocator();
        this.runBackPatchJob(this.backPatchJobs);
        this.runBackPatchJob(this.delayedBackPatchJobs);
        this.setLocator(locator);
    }

    private final void runBackPatchJob(Vector vector) {
        for (BackPatch backPatch : vector) {
            this.setLocator(backPatch.getOwnerState().getLocation());
            backPatch.patch();
        }
    }

    public final void reportError(String string) {
        this.reportError(string, null, null, null);
    }

    public final void reportError(String string, Object object) {
        this.reportError(string, new Object[]{object}, null, null);
    }

    public final void reportError(String string, Object object, Object object2) {
        this.reportError(string, new Object[]{object, object2}, null, null);
    }

    public final void reportError(String string, Object object, Object object2, Object object3) {
        this.reportError(string, new Object[]{object, object2, object3}, null, null);
    }

    public final void reportError(Exception exception, String string) {
        this.reportError(string, null, exception, null);
    }

    public final void reportError(Exception exception, String string, Object object) {
        this.reportError(string, new Object[]{object}, exception, null);
    }

    public final void reportError(Locator[] locatorArray, String string, Object[] objectArray) {
        this.reportError(string, objectArray, null, locatorArray);
    }

    public final void reportWarning(String string) {
        this.reportWarning(string, null, null);
    }

    public final void reportWarning(String string, Object object) {
        this.reportWarning(string, new Object[]{object}, null);
    }

    public final void reportWarning(String string, Object object, Object object2) {
        this.reportWarning(string, new Object[]{object, object2}, null);
    }

    private Locator[] prepareLocation(Locator[] locatorArray) {
        if (locatorArray != null) {
            int n2 = 0;
            for (int i2 = 0; i2 < locatorArray.length; ++i2) {
                if (locatorArray[i2] == null) continue;
                ++n2;
            }
            if (locatorArray.length == n2) {
                return locatorArray;
            }
            Locator[] locatorArray2 = new Locator[n2];
            n2 = 0;
            for (int i3 = 0; i3 < locatorArray.length; ++i3) {
                if (locatorArray[i3] == null) continue;
                locatorArray2[n2++] = locatorArray[i3];
            }
            return locatorArray2;
        }
        if (this.getLocator() != null) {
            return new Locator[]{this.getLocator()};
        }
        return new Locator[0];
    }

    public final void reportError(String string, Object[] objectArray, Exception exception, Locator[] locatorArray) {
        this.controller.error(this.prepareLocation(locatorArray), this.localizeMessage(string, objectArray), exception);
    }

    public final void reportWarning(String string, Object[] objectArray, Locator[] locatorArray) {
        this.controller.warning(this.prepareLocation(locatorArray), this.localizeMessage(string, objectArray));
    }

    public static Source inputSourceFromLSInput(LSInput lSInput) {
        Source source;
        if (lSInput instanceof DOMLSInput) {
            DOMLSInput dOMLSInput = (DOMLSInput)((Object)lSInput);
            source = new DOMSource(dOMLSInput.getElement());
        } else {
            InputSource inputSource = new InputSource();
            if (lSInput.getCharacterStream() != null) {
                inputSource.setCharacterStream(lSInput.getCharacterStream());
            }
            if (lSInput.getByteStream() != null) {
                inputSource.setByteStream(lSInput.getByteStream());
            }
            if (lSInput.getStringData() != null) {
                inputSource.setCharacterStream(new StringReader(lSInput.getStringData()));
            }
            if (lSInput.getPublicId() != null) {
                inputSource.setPublicId(lSInput.getPublicId());
            }
            source = new SAXSource(inputSource);
        }
        if (lSInput.getSystemId() != null) {
            source.setSystemId(lSInput.getSystemId());
        }
        return source;
    }

    protected abstract String localizeMessage(String var1, Object[] var2);

    public void setLocator(Locator locator) {
        this.locator = locator;
    }

    public Locator getLocator() {
        return this.locator;
    }

    public static interface BackPatch {
        public void patch();

        public State getOwnerState();
    }

    public class BackwardReferenceMap {
        private final Map impl = new HashMap();

        public void memorizeLink(Object object) {
            ArrayList arrayList;
            if (this.impl.containsKey(object)) {
                arrayList = (ArrayList)this.impl.get(object);
            } else {
                arrayList = new ArrayList();
                this.impl.put(object, arrayList);
            }
            arrayList.add(new LocatorImpl(GrammarReader.this.getLocator()));
        }

        public Locator[] getReferer(Object object) {
            if (this.impl.containsKey(object)) {
                ArrayList arrayList = (ArrayList)this.impl.get(object);
                Locator[] locatorArray = new Locator[arrayList.size()];
                arrayList.toArray(locatorArray);
                return locatorArray;
            }
            return null;
        }
    }

    private class InclusionContext {
        final PrefixResolver prefixResolver;
        final Locator locator;
        final String systemId;
        final InclusionContext previousContext;

        InclusionContext(PrefixResolver prefixResolver, Locator locator, String string, InclusionContext inclusionContext) {
            this.prefixResolver = prefixResolver;
            this.locator = locator;
            this.systemId = string;
            this.previousContext = inclusionContext;
        }
    }

    public class ChainPrefixResolver
    implements PrefixResolver {
        public final PrefixResolver previous;
        public final String prefix;
        public final String uri;

        public ChainPrefixResolver(String string, String string2) {
            this.prefix = string;
            this.uri = string2;
            this.previous = GrammarReader.this.prefixResolver;
        }

        public String resolve(String string) {
            if (string.equals(this.prefix)) {
                return this.uri;
            }
            return this.previous.resolve(string);
        }
    }

    public static interface PrefixResolver {
        public String resolve(String var1);
    }
}

