/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.ctc.wstx.io;

import com.gradle.maven.extension.internal.dep.com.ctc.wstx.api.ReaderConfig;
import com.gradle.maven.extension.internal.dep.com.ctc.wstx.io.BaseReader;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;

public final class UTF32Reader
extends BaseReader {
    protected final boolean mBigEndian;
    protected boolean mXml11;
    protected char mSurrogate = '\u0000';
    protected int mCharCount = 0;
    protected int mByteCount = 0;

    public UTF32Reader(ReaderConfig readerConfig, InputStream inputStream, byte[] byArray, int n2, int n3, boolean bl2, boolean bl3) {
        super(readerConfig, inputStream, byArray, n2, n3, bl2);
        this.mBigEndian = bl3;
    }

    @Override
    public void setXmlCompliancy(int n2) {
        this.mXml11 = n2 == 272;
    }

    @Override
    public int read(char[] cArray, int n2, int n3) throws IOException {
        if (n2 < 0 || n2 + n3 > cArray.length) {
            this.reportBounds(cArray, n2, n3);
        }
        if (this.mByteBuffer == null) {
            return -1;
        }
        if (n3 < 1) {
            return 0;
        }
        n3 += n2;
        int n4 = n2;
        if (this.mSurrogate != '\u0000') {
            cArray[n4++] = this.mSurrogate;
            this.mSurrogate = '\u0000';
        } else {
            int n5 = this.mByteBufferEnd - this.mBytePtr;
            if (n5 < 4 && !this.loadMore(n5)) {
                if (n5 == 0) {
                    return -1;
                }
                this.reportUnexpectedEOF(this.mByteBufferEnd - this.mBytePtr, 4);
            }
        }
        byte[] byArray = this.mByteBuffer;
        int n6 = this.mByteBufferEnd - 4;
        while (n4 < n3) {
            int n7 = this.mBytePtr;
            if (this.mBytePtr > n6) break;
            int n8 = this.mBigEndian ? byArray[n7] << 24 | (byArray[n7 + 1] & 0xFF) << 16 | (byArray[n7 + 2] & 0xFF) << 8 | byArray[n7 + 3] & 0xFF : byArray[n7] & 0xFF | (byArray[n7 + 1] & 0xFF) << 8 | (byArray[n7 + 2] & 0xFF) << 16 | byArray[n7 + 3] << 24;
            this.mBytePtr += 4;
            if (n8 >= 127) {
                if (n8 <= 159) {
                    if (this.mXml11) {
                        if (n8 != 133) {
                            this.reportInvalid(n8, n4 - n2, "(can only be included via entity in xml 1.1)");
                        }
                        n8 = 10;
                    }
                } else if (n8 >= 55296) {
                    if (n8 > 0x10FFFF) {
                        this.reportInvalid(n8, n4 - n2, "(above " + Integer.toHexString(0x10FFFF) + ") ");
                    }
                    if (n8 > 65535) {
                        cArray[n4++] = (char)(55296 + ((n8 -= 65536) >> 10));
                        n8 = 0xDC00 | n8 & 0x3FF;
                        if (n4 >= n3) {
                            this.mSurrogate = (char)n8;
                            break;
                        }
                    } else if (n8 < 57344) {
                        this.reportInvalid(n8, n4 - n2, "(a surrogate char) ");
                    } else if (n8 >= 65534) {
                        this.reportInvalid(n8, n4 - n2, "");
                    }
                } else if (n8 == 8232 && this.mXml11) {
                    n8 = 10;
                }
            }
            cArray[n4++] = (char)n8;
        }
        n3 = n4 - n2;
        this.mCharCount += n3;
        return n3;
    }

    private void reportUnexpectedEOF(int n2, int n3) throws IOException {
        int n4 = this.mByteCount + n2;
        int n5 = this.mCharCount;
        throw new CharConversionException("Unexpected EOF in the middle of a 4-byte UTF-32 char: got " + n2 + ", needed " + n3 + ", at char #" + n5 + ", byte #" + n4 + ")");
    }

    private void reportInvalid(int n2, int n3, String string) throws IOException {
        int n4 = this.mByteCount + this.mBytePtr - 1;
        int n5 = this.mCharCount + n3;
        throw new CharConversionException("Invalid UTF-32 character 0x" + Integer.toHexString(n2) + string + " at char #" + n5 + ", byte #" + n4 + ")");
    }

    private boolean loadMore(int n2) throws IOException {
        int n3;
        this.mByteCount += this.mByteBufferEnd - n2;
        if (n2 > 0) {
            if (this.mBytePtr > 0 && this.canModifyBuffer()) {
                for (n3 = 0; n3 < n2; ++n3) {
                    this.mByteBuffer[n3] = this.mByteBuffer[this.mBytePtr + n3];
                }
                this.mBytePtr = 0;
                this.mByteBufferEnd = n2;
            }
        } else {
            n3 = this.readBytes();
            if (n3 < 1) {
                if (n3 < 0) {
                    this.freeBuffers();
                    return false;
                }
                this.reportStrangeStream();
            }
        }
        while (this.mByteBufferEnd - this.mBytePtr < 4) {
            n3 = this.readBytesAt(this.mByteBufferEnd);
            if (n3 >= 1) continue;
            if (n3 < 0) {
                this.freeBuffers();
                this.reportUnexpectedEOF(this.mByteBufferEnd, 4);
            }
            this.reportStrangeStream();
        }
        return true;
    }
}

