/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;

public abstract class JsonSerializable {
    protected static final ObjectMapper objectMapper = new ObjectMapper();

    protected static String toJsonString(Object object) {
        try {
            return objectMapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
    }

    public String toJson() {
        return JsonSerializable.toJsonString(this);
    }

    protected static JsonNode toJsonNode(Object object) {
        return objectMapper.valueToTree(object);
    }

    public static <T extends JsonSerializable> T fromJsonString(String jsonString, Class<T> clazz) {
        try {
            return (T)((JsonSerializable)objectMapper.readValue(jsonString, clazz));
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
    }

    public static <T extends JsonSerializable> T fromJsonNode(JsonNode jsonNode, Class<T> clazz) {
        try {
            return (T)((JsonSerializable)objectMapper.treeToValue((TreeNode)jsonNode, clazz));
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
    }

    static {
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_ABSENT);
        objectMapper.registerModule((Module)new Jdk8Module());
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

