/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.genai.ApiResponse;
import com.google.genai.JsonSerializable;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.util.EntityUtils;

final class HttpApiResponse
extends ApiResponse {
    private final CloseableHttpResponse response;

    public HttpApiResponse(CloseableHttpResponse response) {
        this.response = response;
    }

    private String getErrorMessage() {
        HttpEntity entity = this.response.getEntity();
        try {
            JsonNode messageNode;
            String responseBody = EntityUtils.toString((HttpEntity)entity);
            if (responseBody == null || responseBody.isEmpty()) {
                return "";
            }
            JsonNode errorNode = JsonSerializable.objectMapper.readTree(responseBody).get("error");
            if (errorNode != null && errorNode.isObject() && (messageNode = errorNode.get("message")) != null && messageNode.isTextual()) {
                return messageNode.asText();
            }
            return "";
        }
        catch (IOException ignored) {
            return "";
        }
    }

    @Override
    public HttpEntity getEntity() throws HttpException {
        StatusLine statusLine = this.response.getStatusLine();
        if (statusLine.getStatusCode() != 200) {
            throw new HttpException(String.format("%s %s. %s", statusLine.getStatusCode(), statusLine.getReasonPhrase(), this.getErrorMessage()));
        }
        return this.response.getEntity();
    }

    @Override
    public void close() throws IOException {
        this.response.close();
    }
}

