/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.genai.JsonSerializable;
import java.util.Iterator;
import java.util.Map;

public final class Common {
    private Common() {
    }

    static void setValueByPath(ObjectNode jsonObject, String[] path, Object value) {
        if (path == null || path.length == 0) {
            throw new IllegalArgumentException("Path cannot be empty.");
        }
        if (jsonObject == null) {
            throw new IllegalArgumentException("JsonObject cannot be null.");
        }
        ObjectNode currentObject = jsonObject;
        for (int i = 0; i < path.length - 1; ++i) {
            String key = path[i];
            if (!currentObject.has(key)) {
                currentObject.putObject(key);
            }
            currentObject = (ObjectNode)currentObject.get(key);
        }
        currentObject.put(path[path.length - 1], JsonSerializable.toJsonNode(value));
    }

    static String formatMap(String template, JsonNode data) {
        Iterator fields = data.fields();
        while (fields.hasNext()) {
            Map.Entry field = (Map.Entry)fields.next();
            String key = (String)field.getKey();
            String placeholder = "{" + key + "}";
            if (!template.contains(placeholder)) continue;
            template = template.replace(placeholder, data.get(key).asText());
        }
        return template;
    }

    static boolean isZero(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof Number) {
            Number num = (Number)obj;
            return num.doubleValue() == 0.0;
        }
        if (obj instanceof Character) {
            Character ch = (Character)obj;
            return ch.charValue() == '\u0000';
        }
        if (obj instanceof Boolean) {
            Boolean bool = (Boolean)obj;
            return bool == false;
        }
        return false;
    }

    static Object getValueByPath(JsonNode object, String[] keys) {
        if (object == null || keys == null) {
            return null;
        }
        if (keys.length == 1 && keys[0].equals("_self")) {
            return object;
        }
        JsonNode currentObject = object;
        for (String key : keys) {
            if (currentObject instanceof ObjectNode) {
                currentObject = currentObject.get(key);
                continue;
            }
            if (currentObject instanceof ArrayNode) {
                try {
                    int index = Integer.parseInt(key);
                    currentObject = currentObject.get(index);
                    continue;
                }
                catch (IndexOutOfBoundsException | NumberFormatException e) {
                    return null;
                }
            }
            return null;
        }
        return currentObject;
    }
}

