/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1alpha.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.discoveryengine.v1alpha.AclConfig;
import com.google.cloud.discoveryengine.v1alpha.GetAclConfigRequest;
import com.google.cloud.discoveryengine.v1alpha.UpdateAclConfigRequest;
import com.google.cloud.discoveryengine.v1alpha.stub.AclConfigServiceStub;
import com.google.cloud.discoveryengine.v1alpha.stub.AclConfigServiceStubSettings;
import com.google.cloud.discoveryengine.v1alpha.stub.GrpcAclConfigServiceCallableFactory;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcAclConfigServiceStub
extends AclConfigServiceStub {
    private static final MethodDescriptor<UpdateAclConfigRequest, AclConfig> updateAclConfigMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.discoveryengine.v1alpha.AclConfigService/UpdateAclConfig").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateAclConfigRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)AclConfig.getDefaultInstance())).build();
    private static final MethodDescriptor<GetAclConfigRequest, AclConfig> getAclConfigMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.discoveryengine.v1alpha.AclConfigService/GetAclConfig").setRequestMarshaller(ProtoUtils.marshaller((Message)GetAclConfigRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)AclConfig.getDefaultInstance())).build();
    private final UnaryCallable<UpdateAclConfigRequest, AclConfig> updateAclConfigCallable;
    private final UnaryCallable<GetAclConfigRequest, AclConfig> getAclConfigCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcAclConfigServiceStub create(AclConfigServiceStubSettings settings) throws IOException {
        return new GrpcAclConfigServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcAclConfigServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcAclConfigServiceStub(AclConfigServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcAclConfigServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcAclConfigServiceStub(AclConfigServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcAclConfigServiceStub(AclConfigServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcAclConfigServiceCallableFactory());
    }

    protected GrpcAclConfigServiceStub(AclConfigServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings updateAclConfigTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateAclConfigMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("acl_config.name", String.valueOf(request.getAclConfig().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getAclConfigTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getAclConfigMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.updateAclConfigCallable = callableFactory.createUnaryCallable(updateAclConfigTransportSettings, settings.updateAclConfigSettings(), clientContext);
        this.getAclConfigCallable = callableFactory.createUnaryCallable(getAclConfigTransportSettings, settings.getAclConfigSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<UpdateAclConfigRequest, AclConfig> updateAclConfigCallable() {
        return this.updateAclConfigCallable;
    }

    @Override
    public UnaryCallable<GetAclConfigRequest, AclConfig> getAclConfigCallable() {
        return this.getAclConfigCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

