/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1alpha;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.OperationsClient;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.discoveryengine.v1alpha.ListCustomModelsRequest;
import com.google.cloud.discoveryengine.v1alpha.ListCustomModelsResponse;
import com.google.cloud.discoveryengine.v1alpha.SearchTuningServiceSettings;
import com.google.cloud.discoveryengine.v1alpha.TrainCustomModelMetadata;
import com.google.cloud.discoveryengine.v1alpha.TrainCustomModelRequest;
import com.google.cloud.discoveryengine.v1alpha.TrainCustomModelResponse;
import com.google.cloud.discoveryengine.v1alpha.stub.SearchTuningServiceStub;
import com.google.cloud.discoveryengine.v1alpha.stub.SearchTuningServiceStubSettings;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.OperationsStub;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class SearchTuningServiceClient
implements BackgroundResource {
    private final SearchTuningServiceSettings settings;
    private final SearchTuningServiceStub stub;
    private final OperationsClient httpJsonOperationsClient;
    private final com.google.longrunning.OperationsClient operationsClient;

    public static final SearchTuningServiceClient create() throws IOException {
        return SearchTuningServiceClient.create(SearchTuningServiceSettings.newBuilder().build());
    }

    public static final SearchTuningServiceClient create(SearchTuningServiceSettings settings) throws IOException {
        return new SearchTuningServiceClient(settings);
    }

    public static final SearchTuningServiceClient create(SearchTuningServiceStub stub) {
        return new SearchTuningServiceClient(stub);
    }

    protected SearchTuningServiceClient(SearchTuningServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((SearchTuningServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = com.google.longrunning.OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = OperationsClient.create((com.google.api.gax.httpjson.longrunning.stub.OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected SearchTuningServiceClient(SearchTuningServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = com.google.longrunning.OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = OperationsClient.create((com.google.api.gax.httpjson.longrunning.stub.OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final SearchTuningServiceSettings getSettings() {
        return this.settings;
    }

    public SearchTuningServiceStub getStub() {
        return this.stub;
    }

    public final com.google.longrunning.OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final OperationFuture<TrainCustomModelResponse, TrainCustomModelMetadata> trainCustomModelAsync(TrainCustomModelRequest request) {
        return this.trainCustomModelOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<TrainCustomModelRequest, TrainCustomModelResponse, TrainCustomModelMetadata> trainCustomModelOperationCallable() {
        return this.stub.trainCustomModelOperationCallable();
    }

    public final UnaryCallable<TrainCustomModelRequest, Operation> trainCustomModelCallable() {
        return this.stub.trainCustomModelCallable();
    }

    public final ListCustomModelsResponse listCustomModels(ListCustomModelsRequest request) {
        return (ListCustomModelsResponse)this.listCustomModelsCallable().call((Object)request);
    }

    public final UnaryCallable<ListCustomModelsRequest, ListCustomModelsResponse> listCustomModelsCallable() {
        return this.stub.listCustomModelsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

