/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.http;

import io.cloudevents.SpecVersion;
import io.cloudevents.core.format.EventFormat;
import io.cloudevents.core.message.MessageReader;
import io.cloudevents.core.message.impl.GenericStructuredMessageReader;
import io.cloudevents.core.message.impl.MessageUtils;
import io.cloudevents.http.impl.CloudEventsHeaders;
import io.cloudevents.http.impl.HttpMessageReader;
import io.cloudevents.http.impl.HttpMessageWriter;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public final class HttpMessageFactory {
    private HttpMessageFactory() {
    }

    public static MessageReader createReader(Consumer<BiConsumer<String, String>> forEachHeader, byte[] body) {
        AtomicReference contentType = new AtomicReference();
        AtomicReference specVersion = new AtomicReference();
        forEachHeader.accept((k, v) -> {
            if ("Content-Type".equalsIgnoreCase((String)k)) {
                contentType.set(v);
            } else if (CloudEventsHeaders.SPEC_VERSION.equalsIgnoreCase((String)k)) {
                specVersion.set(v);
            }
        });
        return MessageUtils.parseStructuredOrBinaryMessage(contentType::get, format -> new GenericStructuredMessageReader((EventFormat)format, body), specVersion::get, sv -> new HttpMessageReader((SpecVersion)((Object)sv), forEachHeader, body));
    }

    public static MessageReader createReader(Map<String, String> headers, byte[] body) {
        return HttpMessageFactory.createReader(headers::forEach, body);
    }

    public static MessageReader createReaderFromMultimap(Map<String, List<String>> headers, byte[] body) {
        Consumer<BiConsumer<String, String>> forEachHeader = processHeader -> headers.forEach((key, values) -> values.forEach(value -> processHeader.accept(key, value)));
        return HttpMessageFactory.createReader(forEachHeader, body);
    }

    public static HttpMessageWriter createWriter(BiConsumer<String, String> putHeader, Consumer<byte[]> sendBody) {
        return new HttpMessageWriter(putHeader, sendBody);
    }
}

