/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.client.datastoreservice.app;

import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.base.Function;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.base.Predicate;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.net.util.error.Codes;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.repackaged.com.google.protobuf.CodedOutputStream;
import com.google.appengine.repackaged.org.joda.time.Instant;
import com.google.apphosting.client.datastoreservice.app.EntityTranslator;
import com.google.apphosting.client.datastoreservice.app.InternDatastoreRpcService;
import com.google.apphosting.client.datastoreservice.proto.DatastoreService;
import com.google.apphosting.client.serviceapp.Clock;
import com.google.apphosting.client.serviceapp.RpcException;
import com.google.apphosting.client.serviceapp.RpcHandler;
import com.google.apphosting.client.serviceapp.Utils;
import com.google.apphosting.datastore.DatastoreV4;
import com.google.apphosting.datastore.EntityV4;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;

public class DatastoreV4Client {
    public static final EntityTranslator.Format INTERNAL_FORMAT = EntityTranslator.Format.V1BETA2;
    @VisibleForTesting
    public static final int INTERN_MAX_KEYS_PER_REQUEST = 300;
    @VisibleForTesting
    public static final InternDatastoreRpcService.RpcSpec<DatastoreV4.BeginTransactionResponse> BT_RPC_SPEC = InternDatastoreRpcService.createRpcSpec("datastore_v4", "BeginTransaction", DatastoreV4.BeginTransactionResponse.parser());
    @VisibleForTesting
    public static final InternDatastoreRpcService.RpcSpec<DatastoreV4.LookupResponse> LOOKUP_RPC_SPEC = InternDatastoreRpcService.createRpcSpec("datastore_v4", "Lookup", DatastoreV4.LookupResponse.parser());
    @VisibleForTesting
    public static final InternDatastoreRpcService.RpcSpec<DatastoreV4.CommitResponse> COMMIT_RPC_SPEC = InternDatastoreRpcService.createRpcSpec("datastore_v4", "Commit", DatastoreV4.CommitResponse.parser());
    @VisibleForTesting
    public static final InternDatastoreRpcService.RpcSpec<DatastoreV4.AllocateIdsResponse> ALLOC_RPC_SPEC = InternDatastoreRpcService.createRpcSpec("datastore_v4", "AllocateIds", DatastoreV4.AllocateIdsResponse.parser());
    @VisibleForTesting
    public static final InternDatastoreRpcService.RpcSpec<DatastoreV4.RollbackResponse> ROLLBACK_RPC_SPEC = InternDatastoreRpcService.createRpcSpec("datastore_v4", "Rollback", DatastoreV4.RollbackResponse.parser());
    @VisibleForTesting
    public static final InternDatastoreRpcService.RpcSpec<DatastoreV4.ContinueQueryResponse> CONTINUE_RPC_SPEC = InternDatastoreRpcService.createRpcSpec("datastore_v4", "ContinueQuery", DatastoreV4.ContinueQueryResponse.parser());
    @VisibleForTesting
    public static final InternDatastoreRpcService.RpcSpec<DatastoreV4.RunQueryResponse> RUNQUERY_RPC_SPEC = InternDatastoreRpcService.createRpcSpec("datastore_v4", "RunQuery", DatastoreV4.RunQueryResponse.parser());
    private final InternDatastoreRpcService internService;
    private final Clock clock;
    @VisibleForTesting
    public static final DatastoreV4.BeginTransactionRequest BEGIN_TXN_REQUEST = DatastoreV4.BeginTransactionRequest.newBuilder().setCrossGroup(true).setCrossRequest(true).build();

    public DatastoreV4Client(InternDatastoreRpcService internService, Clock clock) {
        this.internService = internService;
        this.clock = Preconditions.checkNotNull(clock);
    }

    public ByteString beginTransaction(RpcHandler.CallOptions callOptions) throws RpcException {
        Double remainingDeadline = this.getRemainingDeadlineInSeconds(callOptions.getDeadline());
        InternDatastoreRpcService.ResponseFutureWrapper<DatastoreV4.BeginTransactionResponse> internResponse = this.internService.call(BT_RPC_SPEC, BEGIN_TXN_REQUEST, remainingDeadline);
        ByteString transaction = null;
        if (internResponse != null && internResponse.getResponse() != null) {
            transaction = internResponse.getResponse().getTransaction();
        }
        if (transaction == null) {
            throw new RpcException(Codes.Code.ABORTED, "Internal Datastore error.  Could not get transaction handle.");
        }
        return transaction;
    }

    public DatastoreService.LookupResponse lookup(RpcHandler.CallOptions callOptions, Function<DatastoreV4.EntityResult, DatastoreV4.EntityResult> resultTransform, DatastoreV4.ReadOptions readOptions, Collection<EntityV4.Key> keys) throws RpcException {
        int remainingApiResponseBytes = callOptions.getMaxResponseBytes();
        ArrayList<EntityV4.Key> normalizedKeys = Lists.newArrayList(keys);
        for (EntityV4.Key key : normalizedKeys) {
            remainingApiResponseBytes -= this.getMaxResponseBytes(key);
        }
        if (remainingApiResponseBytes < 0) {
            throw new RpcException(Codes.Code.INVALID_ARGUMENT, "Too many keys for the response size limit.");
        }
        Double remainingDeadline = this.getRemainingDeadlineInSeconds(callOptions.getDeadline());
        if (this.hasDeadlineExpired(remainingDeadline)) {
            throw new RpcException(Codes.Code.DEADLINE_EXCEEDED, "Deadline was exceeded before execution");
        }
        DatastoreV4.LookupRequest internReq = this.createInternRequest(readOptions, normalizedKeys);
        InternDatastoreRpcService.ResponseFutureWrapper<DatastoreV4.LookupResponse> internRpc = this.internService.call(LOOKUP_RPC_SPEC, internReq, remainingDeadline);
        DatastoreService.LookupResponse.Builder res = DatastoreService.LookupResponse.newBuilder();
        do {
            DatastoreV4.LookupResponse internRes = null;
            try {
                internRes = internRpc.getResponse();
            }
            catch (RpcException e) {
                if (res.getFoundCount() > 0) break;
                throw e;
            }
            normalizedKeys.addAll(internRes.getDeferredList());
            if (normalizedKeys.isEmpty()) {
                internRpc = null;
            } else {
                internReq = this.createInternRequest(readOptions, normalizedKeys);
                internRpc = this.internService.call(LOOKUP_RPC_SPEC, internReq, remainingDeadline);
            }
            res.addAllMissing(Lists.transform(internRes.getMissingList(), resultTransform));
            for (DatastoreV4.EntityResult found : Lists.transform(internRes.getFoundList(), resultTransform)) {
                int nonKeyBytes = CodedOutputStream.computeMessageSize(1, found) - this.getMaxResponseBytes(found.getEntity().getKey());
                if (nonKeyBytes > remainingApiResponseBytes) {
                    internRpc = null;
                    res.addDeferred(found.getEntity().getKey());
                    continue;
                }
                res.addFound(found);
                remainingApiResponseBytes -= nonKeyBytes;
            }
            if (this.hasDeadlineExpired(remainingDeadline)) {
                internRpc = null;
                continue;
            }
            remainingDeadline = this.getRemainingDeadlineInSeconds(callOptions.getDeadline());
        } while (internRpc != null);
        res.addAllDeferred(normalizedKeys);
        return res.build();
    }

    public DatastoreV4.CommitResponse commit(RpcHandler.CallOptions callOptions, @Nullable ByteString transaction, DatastoreService.CommitRequest.Mode mode, @Nullable DatastoreV4.DeprecatedMutation deprecatedMutation) throws RpcException {
        DatastoreV4.CommitRequest.Builder internReq = DatastoreV4.CommitRequest.newBuilder();
        if (transaction != null) {
            internReq.setTransaction(transaction);
        }
        if (mode.getNumber() != DatastoreV4.CommitRequest.getDefaultInstance().getMode().getNumber()) {
            internReq.setMode(DatastoreV4.CommitRequest.Mode.forNumber(mode.getNumber()));
        }
        if (deprecatedMutation != null) {
            internReq.setDeprecatedMutation(deprecatedMutation);
        }
        Double remainingDeadline = this.getRemainingDeadlineInSeconds(callOptions.getDeadline());
        DatastoreV4.CommitResponse internRes = this.internService.call(COMMIT_RPC_SPEC, internReq.build(), remainingDeadline).getResponse();
        return internRes;
    }

    public DatastoreV4.CommitResponse commit(RpcHandler.CallOptions callOptions, @Nullable ByteString transaction, DatastoreService.CommitRequest.Mode mode, List<DatastoreV4.Mutation> mutationList) throws RpcException {
        DatastoreV4.CommitRequest.Builder internReq = DatastoreV4.CommitRequest.newBuilder();
        if (transaction != null) {
            internReq.setTransaction(transaction);
        }
        if (mode.getNumber() != DatastoreV4.CommitRequest.getDefaultInstance().getMode().getNumber()) {
            internReq.setMode(DatastoreV4.CommitRequest.Mode.forNumber(mode.getNumber()));
        }
        Double remainingDeadline = this.getRemainingDeadlineInSeconds(callOptions.getDeadline());
        internReq.addAllMutation(mutationList);
        DatastoreV4.CommitResponse internRes = this.internService.call(COMMIT_RPC_SPEC, internReq.build(), remainingDeadline).getResponse();
        return internRes;
    }

    public DatastoreService.AllocateIdsResponse allocateIds(RpcHandler.CallOptions callOptions, int maxKeysPerBatch, List<EntityV4.Key> keys) throws RpcException {
        ArrayList<InternDatastoreRpcService.ResponseFutureWrapper<DatastoreV4.AllocateIdsResponse>> futures = Lists.newArrayListWithExpectedSize(keys.size() / maxKeysPerBatch + 1);
        for (int fromIndex = 0; fromIndex < keys.size(); fromIndex += maxKeysPerBatch) {
            int toIndex = Math.min(keys.size(), fromIndex + maxKeysPerBatch);
            DatastoreV4.AllocateIdsRequest allocateIdsRequest = DatastoreV4.AllocateIdsRequest.newBuilder().addAllAllocate(keys.subList(fromIndex, toIndex)).build();
            Double remainingDeadline = this.getRemainingDeadlineInSeconds(callOptions.getDeadline());
            futures.add(this.internService.call(ALLOC_RPC_SPEC, allocateIdsRequest, remainingDeadline));
        }
        DatastoreService.AllocateIdsResponse.Builder res = DatastoreService.AllocateIdsResponse.newBuilder();
        for (InternDatastoreRpcService.ResponseFutureWrapper responseFutureWrapper : futures) {
            res.addAllKey(((DatastoreV4.AllocateIdsResponse)responseFutureWrapper.getResponse()).getAllocatedList());
        }
        return res.build();
    }

    public void rollback(RpcHandler.CallOptions callOptions, ByteString transaction) throws RpcException {
        DatastoreV4.RollbackRequest req = DatastoreV4.RollbackRequest.newBuilder().setTransaction(transaction).build();
        Double remainingDeadline = this.getRemainingDeadlineInSeconds(callOptions.getDeadline());
        this.internService.call(ROLLBACK_RPC_SPEC, req, remainingDeadline).getResponse();
    }

    public QueryResponseKey runQuery(RpcHandler.CallOptions options, Function<DatastoreV4.EntityResult, DatastoreV4.EntityResult> resultTransform, DatastoreV4.RunQueryRequest req, Predicate<? super DatastoreV4.EntityResult> predicate) throws RpcException {
        Preconditions.checkNotNull(predicate);
        DatastoreService.RunQueryResponse.Builder res = DatastoreService.RunQueryResponse.newBuilder();
        DatastoreV4.QueryResultBatch.Builder batch = res.getBatchBuilder();
        Double remainingDeadline = this.getRemainingDeadlineInSeconds(options.getDeadline());
        if (this.hasDeadlineExpired(remainingDeadline)) {
            throw new RpcException(Codes.Code.DEADLINE_EXCEEDED, "Deadline exceeded before execution");
        }
        InternDatastoreRpcService.ResponseFutureWrapper<DatastoreV4.RunQueryResponse> internRpc = this.internService.call(RUNQUERY_RPC_SPEC, req, remainingDeadline);
        DatastoreV4.RunQueryResponse initialInternResp = internRpc.getResponse();
        DatastoreV4.QueryResultBatch internBatch = initialInternResp.getBatch();
        batch.setEntityResultType(internBatch.getEntityResultType());
        DatastoreV4.ContinueQueryRequest continueReq = DatastoreV4.ContinueQueryRequest.newBuilder().setQueryHandle(initialInternResp.getQueryHandle()).build();
        int totalResultBytes = 0;
        int skippedResults = 0;
        EntityV4.Key lastEntityKey = null;
        block4: while (true) {
            remainingDeadline = this.getRemainingDeadlineInSeconds(options.getDeadline());
            InternDatastoreRpcService.ResponseFutureWrapper<DatastoreV4.ContinueQueryResponse> nextRpc = internBatch.getMoreResults() == DatastoreV4.QueryResultBatch.MoreResultsType.NOT_FINISHED && !this.hasDeadlineExpired(remainingDeadline) ? this.internService.call(CONTINUE_RPC_SPEC, continueReq, remainingDeadline) : null;
            ArrayList<DatastoreV4.EntityResult> results = Lists.newArrayListWithCapacity(internBatch.getEntityResultCount());
            for (DatastoreV4.EntityResult result : Lists.transform(internBatch.getEntityResultList(), resultTransform)) {
                try {
                    if (!predicate.apply(result)) {
                        ++skippedResults;
                        continue;
                    }
                }
                catch (RuntimeException e) {
                    if (e.getCause() instanceof RpcException) {
                        throw (RpcException)e.getCause();
                    }
                    throw e;
                }
                int resultBytes = CodedOutputStream.computeMessageSize(2, result);
                if (totalResultBytes + resultBytes > options.getMaxResponseBytes()) {
                    batch.setMoreResults(DatastoreV4.QueryResultBatch.MoreResultsType.NOT_FINISHED);
                    break block4;
                }
                lastEntityKey = result.getEntity().getKey();
                totalResultBytes += resultBytes;
                results.add(result);
            }
            skippedResults += internBatch.getSkippedResults();
            batch.addAllEntityResult(results);
            batch.setEndCursor(internBatch.getEndCursor());
            batch.setMoreResults(internBatch.getMoreResults());
            if (nextRpc == null) break;
            try {
                internBatch = nextRpc.getResponse().getBatch();
            }
            catch (RpcException e) {
                if (totalResultBytes > 0) break;
                throw e;
            }
        }
        if (skippedResults > 0) {
            batch.setSkippedResults(skippedResults);
        }
        return new QueryResponseKey(res.build(), lastEntityKey);
    }

    private int getMaxResponseBytes(EntityV4.Key key) {
        return CodedOutputStream.computeMessageSize(3, key);
    }

    private boolean hasDeadlineExpired(Double remainingDeadlineInSeconds) {
        return remainingDeadlineInSeconds == null ? false : remainingDeadlineInSeconds <= 0.0;
    }

    private Double getRemainingDeadlineInSeconds(Instant deadline) {
        return Utils.getRemainingDeadlineInSeconds(this.clock, deadline);
    }

    private DatastoreV4.LookupRequest createInternRequest(@Nullable DatastoreV4.ReadOptions readOptions, List<EntityV4.Key> keyList) {
        DatastoreV4.LookupRequest.Builder req = DatastoreV4.LookupRequest.newBuilder();
        if (readOptions != null) {
            req.setReadOptions(readOptions);
        }
        List<EntityV4.Key> limitedKeyList = keyList.size() <= 300 ? keyList : keyList.subList(0, 300);
        req.addAllKey(limitedKeyList);
        limitedKeyList.clear();
        return req.build();
    }

    public static final class QueryResponseKey {
        private final DatastoreService.RunQueryResponse response;

        QueryResponseKey(DatastoreService.RunQueryResponse response, EntityV4.Key lastKey) {
            this.response = response;
        }

        public DatastoreService.RunQueryResponse getQueryResponse() {
            return this.response;
        }
    }
}

