/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.hash;

import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.base.Verify;
import com.google.appengine.repackaged.com.google.common.hash.AbstractHashFunction;
import com.google.appengine.repackaged.com.google.common.hash.AbstractStreamingHasher;
import com.google.appengine.repackaged.com.google.common.hash.HashCode;
import com.google.appengine.repackaged.com.google.common.hash.Hasher;
import com.google.appengine.repackaged.com.google.common.primitives.Bytes;
import com.google.appengine.repackaged.com.google.common.primitives.Longs;
import com.google.appengine.repackaged.com.google.errorprone.annotations.Immutable;
import com.google.highwayhash.HighwayHash;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

@Immutable
@GoogleInternal
final class HighwayHashFunction
extends AbstractHashFunction {
    private final BitLength bitLength;
    private final long key0;
    private final long key1;
    private final long key2;
    private final long key3;

    HighwayHashFunction(BitLength bitLength, long key0, long key1, long key2, long key3) {
        this.bitLength = Preconditions.checkNotNull(bitLength);
        this.key0 = key0;
        this.key1 = key1;
        this.key2 = key2;
        this.key3 = key3;
    }

    @Override
    public int bits() {
        return this.bitLength.bits();
    }

    public String toString() {
        return String.format("Hashing.highwayHash%s(%s, %s, %s, %s)", this.bitLength.bits(), this.key0, this.key1, this.key2, this.key3);
    }

    @Override
    public Hasher newHasher() {
        return new HighwayHashHasher(this.bitLength, this.key0, this.key1, this.key2, this.key3);
    }

    public boolean equals(@NullableDecl Object object) {
        if (object instanceof HighwayHashFunction) {
            HighwayHashFunction that = (HighwayHashFunction)object;
            return this.bitLength == that.bitLength && this.key0 == that.key0 && this.key1 == that.key1 && this.key2 == that.key2 && this.key3 == that.key3;
        }
        return false;
    }

    public int hashCode() {
        return (int)((long)this.bitLength.hashCode() ^ this.key0 ^ this.key1 ^ this.key2 ^ this.key3);
    }

    private static final class HighwayHashHasher
    extends AbstractStreamingHasher {
        private final HighwayHash hash;
        private final BitLength bitLength;

        HighwayHashHasher(BitLength bitLength, long key0, long key1, long key2, long key3) {
            super(32);
            this.bitLength = bitLength;
            this.hash = new HighwayHash(key0, key1, key2, key3);
        }

        @Override
        protected void process(ByteBuffer bb) {
            Preconditions.checkArgument(bb.order() == ByteOrder.LITTLE_ENDIAN, "ByteBuffer order (%s) must be little endian", (Object)bb.order());
            long a0 = bb.getLong();
            long a1 = bb.getLong();
            long a2 = bb.getLong();
            long a3 = bb.getLong();
            this.hash.update(a0, a1, a2, a3);
        }

        @Override
        protected void processRemaining(ByteBuffer bb) {
            this.hash.updateRemainder(bb.array(), 0, bb.remaining());
        }

        @Override
        protected HashCode makeHash() {
            return this.bitLength.makeHash(this.hash);
        }
    }

    static enum BitLength {
        LENGTH64{

            @Override
            int bits() {
                return 64;
            }

            @Override
            HashCode makeHash(HighwayHash hash) {
                return HashCode.fromLong(hash.finalize64());
            }
        }
        ,
        LENGTH128{

            @Override
            int bits() {
                return 128;
            }

            @Override
            HashCode makeHash(HighwayHash hash) {
                long[] longs = hash.finalize128();
                Verify.verify(longs.length == 2, "expected 2 longs, but got %s", longs.length);
                return HashCode.fromBytesNoCopy(Bytes.concat(Longs.toByteArray(longs[0]), Longs.toByteArray(longs[1])));
            }
        }
        ,
        LENGTH256{

            @Override
            int bits() {
                return 256;
            }

            @Override
            HashCode makeHash(HighwayHash hash) {
                long[] longs = hash.finalize256();
                Verify.verify(longs.length == 4, "expected 4 longs, but got %s", longs.length);
                return HashCode.fromBytesNoCopy(Bytes.concat(Longs.toByteArray(longs[0]), Longs.toByteArray(longs[1]), Longs.toByteArray(longs[2]), Longs.toByteArray(longs[3])));
            }
        };


        abstract int bits();

        abstract HashCode makeHash(HighwayHash var1);
    }
}

