/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1beta;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ServingConfigName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_DATA_STORE_SERVING_CONFIG = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/dataStores/{data_store}/servingConfigs/{serving_config}");
    private static final PathTemplate PROJECT_LOCATION_COLLECTION_DATA_STORE_SERVING_CONFIG = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/servingConfigs/{serving_config}");
    private static final PathTemplate PROJECT_LOCATION_COLLECTION_ENGINE_SERVING_CONFIG = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/collections/{collection}/engines/{engine}/servingConfigs/{serving_config}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String location;
    private final String dataStore;
    private final String servingConfig;
    private final String collection;
    private final String engine;

    @Deprecated
    protected ServingConfigName() {
        this.project = null;
        this.location = null;
        this.dataStore = null;
        this.servingConfig = null;
        this.collection = null;
        this.engine = null;
    }

    private ServingConfigName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.dataStore = (String)Preconditions.checkNotNull((Object)builder.getDataStore());
        this.servingConfig = (String)Preconditions.checkNotNull((Object)builder.getServingConfig());
        this.collection = null;
        this.engine = null;
        this.pathTemplate = PROJECT_LOCATION_DATA_STORE_SERVING_CONFIG;
    }

    private ServingConfigName(ProjectLocationCollectionDataStoreServingConfigBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.collection = (String)Preconditions.checkNotNull((Object)builder.getCollection());
        this.dataStore = (String)Preconditions.checkNotNull((Object)builder.getDataStore());
        this.servingConfig = (String)Preconditions.checkNotNull((Object)builder.getServingConfig());
        this.engine = null;
        this.pathTemplate = PROJECT_LOCATION_COLLECTION_DATA_STORE_SERVING_CONFIG;
    }

    private ServingConfigName(ProjectLocationCollectionEngineServingConfigBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.collection = (String)Preconditions.checkNotNull((Object)builder.getCollection());
        this.engine = (String)Preconditions.checkNotNull((Object)builder.getEngine());
        this.servingConfig = (String)Preconditions.checkNotNull((Object)builder.getServingConfig());
        this.dataStore = null;
        this.pathTemplate = PROJECT_LOCATION_COLLECTION_ENGINE_SERVING_CONFIG;
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getDataStore() {
        return this.dataStore;
    }

    public String getServingConfig() {
        return this.servingConfig;
    }

    public String getCollection() {
        return this.collection;
    }

    public String getEngine() {
        return this.engine;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newProjectLocationDataStoreServingConfigBuilder() {
        return new Builder();
    }

    public static ProjectLocationCollectionDataStoreServingConfigBuilder newProjectLocationCollectionDataStoreServingConfigBuilder() {
        return new ProjectLocationCollectionDataStoreServingConfigBuilder();
    }

    public static ProjectLocationCollectionEngineServingConfigBuilder newProjectLocationCollectionEngineServingConfigBuilder() {
        return new ProjectLocationCollectionEngineServingConfigBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ServingConfigName of(String project, String location, String dataStore, String servingConfig) {
        return ServingConfigName.newBuilder().setProject(project).setLocation(location).setDataStore(dataStore).setServingConfig(servingConfig).build();
    }

    public static ServingConfigName ofProjectLocationDataStoreServingConfigName(String project, String location, String dataStore, String servingConfig) {
        return ServingConfigName.newBuilder().setProject(project).setLocation(location).setDataStore(dataStore).setServingConfig(servingConfig).build();
    }

    public static ServingConfigName ofProjectLocationCollectionDataStoreServingConfigName(String project, String location, String collection, String dataStore, String servingConfig) {
        return ServingConfigName.newProjectLocationCollectionDataStoreServingConfigBuilder().setProject(project).setLocation(location).setCollection(collection).setDataStore(dataStore).setServingConfig(servingConfig).build();
    }

    public static ServingConfigName ofProjectLocationCollectionEngineServingConfigName(String project, String location, String collection, String engine, String servingConfig) {
        return ServingConfigName.newProjectLocationCollectionEngineServingConfigBuilder().setProject(project).setLocation(location).setCollection(collection).setEngine(engine).setServingConfig(servingConfig).build();
    }

    public static String format(String project, String location, String dataStore, String servingConfig) {
        return ServingConfigName.newBuilder().setProject(project).setLocation(location).setDataStore(dataStore).setServingConfig(servingConfig).build().toString();
    }

    public static String formatProjectLocationDataStoreServingConfigName(String project, String location, String dataStore, String servingConfig) {
        return ServingConfigName.newBuilder().setProject(project).setLocation(location).setDataStore(dataStore).setServingConfig(servingConfig).build().toString();
    }

    public static String formatProjectLocationCollectionDataStoreServingConfigName(String project, String location, String collection, String dataStore, String servingConfig) {
        return ServingConfigName.newProjectLocationCollectionDataStoreServingConfigBuilder().setProject(project).setLocation(location).setCollection(collection).setDataStore(dataStore).setServingConfig(servingConfig).build().toString();
    }

    public static String formatProjectLocationCollectionEngineServingConfigName(String project, String location, String collection, String engine, String servingConfig) {
        return ServingConfigName.newProjectLocationCollectionEngineServingConfigBuilder().setProject(project).setLocation(location).setCollection(collection).setEngine(engine).setServingConfig(servingConfig).build().toString();
    }

    public static ServingConfigName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_LOCATION_DATA_STORE_SERVING_CONFIG.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_DATA_STORE_SERVING_CONFIG.match(formattedString);
            return ServingConfigName.ofProjectLocationDataStoreServingConfigName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("data_store"), (String)matchMap.get("serving_config"));
        }
        if (PROJECT_LOCATION_COLLECTION_DATA_STORE_SERVING_CONFIG.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_COLLECTION_DATA_STORE_SERVING_CONFIG.match(formattedString);
            return ServingConfigName.ofProjectLocationCollectionDataStoreServingConfigName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("collection"), (String)matchMap.get("data_store"), (String)matchMap.get("serving_config"));
        }
        if (PROJECT_LOCATION_COLLECTION_ENGINE_SERVING_CONFIG.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_COLLECTION_ENGINE_SERVING_CONFIG.match(formattedString);
            return ServingConfigName.ofProjectLocationCollectionEngineServingConfigName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("collection"), (String)matchMap.get("engine"), (String)matchMap.get("serving_config"));
        }
        throw new ValidationException("ServingConfigName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<ServingConfigName> parseList(List<String> formattedStrings) {
        ArrayList<ServingConfigName> list = new ArrayList<ServingConfigName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ServingConfigName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ServingConfigName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ServingConfigName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_DATA_STORE_SERVING_CONFIG.matches(formattedString) || PROJECT_LOCATION_COLLECTION_DATA_STORE_SERVING_CONFIG.matches(formattedString) || PROJECT_LOCATION_COLLECTION_ENGINE_SERVING_CONFIG.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ServingConfigName servingConfigName = this;
            synchronized (servingConfigName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.dataStore != null) {
                        fieldMapBuilder.put((Object)"data_store", (Object)this.dataStore);
                    }
                    if (this.servingConfig != null) {
                        fieldMapBuilder.put((Object)"serving_config", (Object)this.servingConfig);
                    }
                    if (this.collection != null) {
                        fieldMapBuilder.put((Object)"collection", (Object)this.collection);
                    }
                    if (this.engine != null) {
                        fieldMapBuilder.put((Object)"engine", (Object)this.engine);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ServingConfigName that = (ServingConfigName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.dataStore, that.dataStore) && Objects.equals(this.servingConfig, that.servingConfig) && Objects.equals(this.collection, that.collection) && Objects.equals(this.engine, that.engine);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.dataStore);
        h *= 1000003;
        h ^= Objects.hashCode(this.servingConfig);
        h *= 1000003;
        h ^= Objects.hashCode(this.collection);
        h *= 1000003;
        return h ^= Objects.hashCode(this.engine);
    }

    public static class ProjectLocationCollectionEngineServingConfigBuilder {
        private String project;
        private String location;
        private String collection;
        private String engine;
        private String servingConfig;

        protected ProjectLocationCollectionEngineServingConfigBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getCollection() {
            return this.collection;
        }

        public String getEngine() {
            return this.engine;
        }

        public String getServingConfig() {
            return this.servingConfig;
        }

        public ProjectLocationCollectionEngineServingConfigBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectLocationCollectionEngineServingConfigBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public ProjectLocationCollectionEngineServingConfigBuilder setCollection(String collection) {
            this.collection = collection;
            return this;
        }

        public ProjectLocationCollectionEngineServingConfigBuilder setEngine(String engine) {
            this.engine = engine;
            return this;
        }

        public ProjectLocationCollectionEngineServingConfigBuilder setServingConfig(String servingConfig) {
            this.servingConfig = servingConfig;
            return this;
        }

        public ServingConfigName build() {
            return new ServingConfigName(this);
        }
    }

    public static class ProjectLocationCollectionDataStoreServingConfigBuilder {
        private String project;
        private String location;
        private String collection;
        private String dataStore;
        private String servingConfig;

        protected ProjectLocationCollectionDataStoreServingConfigBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getCollection() {
            return this.collection;
        }

        public String getDataStore() {
            return this.dataStore;
        }

        public String getServingConfig() {
            return this.servingConfig;
        }

        public ProjectLocationCollectionDataStoreServingConfigBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectLocationCollectionDataStoreServingConfigBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public ProjectLocationCollectionDataStoreServingConfigBuilder setCollection(String collection) {
            this.collection = collection;
            return this;
        }

        public ProjectLocationCollectionDataStoreServingConfigBuilder setDataStore(String dataStore) {
            this.dataStore = dataStore;
            return this;
        }

        public ProjectLocationCollectionDataStoreServingConfigBuilder setServingConfig(String servingConfig) {
            this.servingConfig = servingConfig;
            return this;
        }

        public ServingConfigName build() {
            return new ServingConfigName(this);
        }
    }

    public static class Builder {
        private String project;
        private String location;
        private String dataStore;
        private String servingConfig;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getDataStore() {
            return this.dataStore;
        }

        public String getServingConfig() {
            return this.servingConfig;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setDataStore(String dataStore) {
            this.dataStore = dataStore;
            return this;
        }

        public Builder setServingConfig(String servingConfig) {
            this.servingConfig = servingConfig;
            return this;
        }

        private Builder(ServingConfigName servingConfigName) {
            Preconditions.checkArgument((boolean)Objects.equals(servingConfigName.pathTemplate, PROJECT_LOCATION_DATA_STORE_SERVING_CONFIG), (Object)"toBuilder is only supported when ServingConfigName has the pattern of projects/{project}/locations/{location}/dataStores/{data_store}/servingConfigs/{serving_config}");
            this.project = servingConfigName.project;
            this.location = servingConfigName.location;
            this.dataStore = servingConfigName.dataStore;
            this.servingConfig = servingConfigName.servingConfig;
        }

        public ServingConfigName build() {
            return new ServingConfigName(this);
        }
    }
}

