/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.util;

import androidx.annotation.NonNull;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.ShowFirstParty;

@ShowFirstParty
@KeepForSdk
public class Hex {
    private static final char[] zza = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final char[] zzb = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    @KeepForSdk
    @NonNull
    public static String bytesToStringLowercase(@NonNull byte[] bytes) {
        byte[] byArray;
        int n = bytes.length;
        char[] cArray = new char[n + n];
        int n2 = 0;
        for (int i = 0; i < byArray.length; ++i) {
            int n3 = byArray[i] & 0xFF;
            int n4 = n2 + 1;
            cArray[n2] = zzb[n3 >>> 4];
            cArray[n4] = zzb[n3 & 0xF];
            n2 = n4 + 1;
        }
        return new String(cArray);
    }

    @KeepForSdk
    @NonNull
    public static String bytesToStringUppercase(@NonNull byte[] bytes) {
        return Hex.bytesToStringUppercase(bytes, false);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    @NonNull
    public static String bytesToStringUppercase(@NonNull byte[] bytes, boolean zeroTerminated) {
        byte[] byArray;
        void var1_1;
        int n;
        int n2 = n = bytes.length;
        int n3 = n2 + n2;
        StringBuilder stringBuilder = new StringBuilder(n3);
        for (n3 = 0; n3 < n && (var1_1 == false || n3 != n + -1 || (byArray[n3] & 0xFF) != 0); ++n3) {
            stringBuilder.append(zza[(byArray[n3] & 0xF0) >>> 4]);
            stringBuilder.append(zza[byArray[n3] & 0xF]);
        }
        return stringBuilder.toString();
    }

    @KeepForSdk
    @NonNull
    public static byte[] stringToBytes(@NonNull String hex) throws IllegalArgumentException {
        int n = hex.length();
        if (n % 2 != 0) {
            throw new IllegalArgumentException("Hex string has odd number of characters");
        }
        byte[] byArray = new byte[n / 2];
        int n2 = 0;
        while (n2 < n) {
            String string2;
            int n3 = n2 + 2;
            byArray[n2 / 2] = (byte)Integer.parseInt(string2.substring(n2, n3), 16);
            n2 = n3;
        }
        return byArray;
    }
}

