/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal.safeparcel;

import android.content.Intent;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.Base64Utils;
import com.google.android.gms.internal.common.zzag;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

@KeepForSdk
public final class SafeParcelableSerializer {
    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    @NonNull
    public static <T extends SafeParcelable> T deserializeFromBytes(@NonNull byte[] serializedBytes, @NonNull Parcelable.Creator<T> safeParcelableCreator) {
        void var1_1;
        byte[] byArray;
        Preconditions.checkNotNull(safeParcelableCreator);
        Parcel parcel = Parcel.obtain();
        parcel.unmarshall(byArray, 0, byArray.length);
        parcel.setDataPosition(0);
        SafeParcelable safeParcelable = (SafeParcelable)var1_1.createFromParcel(parcel);
        parcel.recycle();
        return (T)safeParcelable;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    @KeepForSdk
    public static <T extends SafeParcelable> T deserializeFromIntentExtra(@NonNull Intent intent, @NonNull String extra, @NonNull Parcelable.Creator<T> safeParcelableCreator) {
        void var2_2;
        void var1_1;
        Object object = intent.getByteArrayExtra((String)var1_1);
        if (object == null) {
            return null;
        }
        return SafeParcelableSerializer.deserializeFromBytes((byte[])object, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    @NonNull
    public static <T extends SafeParcelable> T deserializeFromString(@NonNull String serializedString, @NonNull Parcelable.Creator<T> safeParcelableCreator) {
        void var1_1;
        return SafeParcelableSerializer.deserializeFromBytes(Base64Utils.decodeUrlSafe(serializedString), var1_1);
    }

    @KeepForSdk
    @NonNull
    public static <T extends SafeParcelable> String serializeToString(@NonNull T safeParcelable) {
        return Base64Utils.encodeUrlSafe(SafeParcelableSerializer.serializeToBytes(safeParcelable));
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @Nullable
    public static <T extends SafeParcelable> ArrayList<T> deserializeIterableFromBundle(@NonNull Bundle bundle, @NonNull String key, @NonNull Parcelable.Creator<T> safeParcelableCreator) {
        ArrayList arrayList;
        if ((arrayList = (ArrayList)bundle.getSerializable((String)((Object)arrayList))) == null) {
            return null;
        }
        ArrayList<T> arrayList2 = new ArrayList<T>(arrayList.size());
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            void var2_3;
            arrayList2.add(SafeParcelableSerializer.deserializeFromBytes((byte[])arrayList.get(i), var2_3));
        }
        return arrayList2;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    @KeepForSdk
    public static <T extends SafeParcelable> ArrayList<T> deserializeIterableFromBundleSafe(@NonNull Bundle bundle, @NonNull String key, @NonNull Parcelable.Creator<T> safeParcelableCreator) {
        void var2_2;
        void var1_1;
        return SafeParcelableSerializer.deserializeIterableFromBytes(bundle.getByteArray((String)var1_1), var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static <T extends SafeParcelable> ArrayList<T> deserializeIterableFromBytes(@Nullable byte[] serializedBytes, @NonNull Parcelable.Creator<T> safeParcelableCreator) {
        Object object;
        if (serializedBytes == null) {
            return null;
        }
        Parcel parcel = Parcel.obtain();
        parcel.unmarshall(object, 0, ((byte[])object).length);
        parcel.setDataPosition(0);
        try {
            void var1_1;
            object = new ArrayList;
            object();
            parcel.readTypedList((List)object, (Parcelable.Creator)var1_1);
        }
        catch (Throwable throwable) {
            parcel.recycle();
            throw throwable;
        }
        parcel.recycle();
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @Nullable
    @KeepForSdk
    public static <T extends SafeParcelable> ArrayList<T> deserializeIterableFromIntentExtra(@NonNull Intent intent, @NonNull String extra, @NonNull Parcelable.Creator<T> safeParcelableCreator) {
        ArrayList arrayList;
        if ((arrayList = (ArrayList)intent.getSerializableExtra((String)((Object)arrayList))) == null) {
            return null;
        }
        ArrayList<T> arrayList2 = new ArrayList<T>(arrayList.size());
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            void var2_3;
            arrayList2.add(SafeParcelableSerializer.deserializeFromBytes((byte[])arrayList.get(i), var2_3));
        }
        return arrayList2;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    @KeepForSdk
    public static <T extends SafeParcelable> ArrayList<T> deserializeIterableFromIntentExtraSafe(@NonNull Intent intent, @NonNull String extra, @NonNull Parcelable.Creator<T> safeParcelableCreator) {
        void var2_2;
        void var1_1;
        return SafeParcelableSerializer.deserializeIterableFromBytes(intent.getByteArrayExtra((String)var1_1), var2_2);
    }

    private SafeParcelableSerializer() {
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static <T extends SafeParcelable> void serializeIterableToBundle(@NonNull Iterable<T> safeParcelables, @NonNull Bundle bundle, @NonNull String key) {
        void var2_2;
        void var1_1;
        Iterator<T> iterator;
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            arrayList.add(SafeParcelableSerializer.serializeToBytes((SafeParcelable)iterator.next()));
        }
        var1_1.putSerializable((String)var2_2, arrayList);
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends SafeParcelable> void serializeIterableToBundleSafe(@NonNull Iterable<T> safeParcelables, @NonNull Bundle bundle, @NonNull String key) {
        Iterable<T> iterable;
        void var2_2;
        bundle.putByteArray((String)var2_2, SafeParcelableSerializer.zza(iterable));
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @KeepForSdk
    public static <T extends SafeParcelable> void serializeIterableToIntentExtra(@NonNull Iterable<T> safeParcelables, @NonNull Intent intent, @NonNull String extra) {
        void var2_2;
        void var1_1;
        Iterator<T> iterator;
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            arrayList.add(SafeParcelableSerializer.serializeToBytes((SafeParcelable)iterator.next()));
        }
        var1_1.putExtra((String)var2_2, arrayList);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public static <T extends SafeParcelable> void serializeIterableToIntentExtraSafe(@NonNull Iterable<T> safeParcelables, @NonNull Intent intent, @NonNull String extra) {
        Iterable<T> iterable;
        void var2_2;
        intent.putExtra((String)var2_2, SafeParcelableSerializer.zza(iterable));
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public static <T extends SafeParcelable> void serializeToIntentExtra(@NonNull T safeParcelable, @NonNull Intent intent, @NonNull String extra) {
        T t;
        void var2_2;
        intent.putExtra((String)var2_2, SafeParcelableSerializer.serializeToBytes(t));
    }

    @KeepForSdk
    @NonNull
    public static <T extends SafeParcelable> byte[] serializeToBytes(@NonNull T safeParcelable) {
        T t;
        Parcel parcel = Parcel.obtain();
        t.writeToParcel(parcel, 0);
        byte[] byArray = parcel.marshall();
        parcel.recycle();
        return byArray;
    }

    private static byte[] zza(Iterable object) {
        Parcel parcel = Parcel.obtain();
        try {
            parcel.writeTypedList((List)zzag.zzj((Iterable)object));
            object = parcel.marshall();
        }
        catch (Throwable throwable) {
            parcel.recycle();
            throw throwable;
        }
        parcel.recycle();
        return object;
    }
}

