/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.annotation.TargetApi;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageInstaller;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.os.UserManager;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.GooglePlayServicesIncorrectManifestValueException;
import com.google.android.gms.common.GooglePlayServicesMissingManifestValueException;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.GoogleSignatureVerifier;
import com.google.android.gms.common.R;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.HideFirstParty;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.internal.zzah;
import com.google.android.gms.common.util.ClientLibraryUtils;
import com.google.android.gms.common.util.DeviceProperties;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.common.util.UidVerifier;
import com.google.android.gms.common.util.zza;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.errorprone.annotations.InlineMe;
import com.google.errorprone.annotations.ResultIgnorabilityUnspecified;
import java.util.concurrent.atomic.AtomicBoolean;

@ShowFirstParty
@KeepForSdk
public class GooglePlayServicesUtilLight {
    @Deprecated
    @KeepForSdk
    public static final int GOOGLE_PLAY_SERVICES_VERSION_CODE = 12451000;
    @Deprecated
    @KeepForSdk
    @NonNull
    public static final String GOOGLE_PLAY_SERVICES_PACKAGE = "com.google.android.gms";
    @KeepForSdk
    @NonNull
    public static final String GOOGLE_PLAY_GAMES_PACKAGE = "com.google.android.play.games";
    @KeepForSdk
    @NonNull
    public static final String GOOGLE_PLAY_STORE_PACKAGE = "com.android.vending";
    @KeepForSdk
    static final int GMS_GENERAL_ERROR_NOTIFICATION_ID = 39789;
    @KeepForSdk
    static final int GMS_AVAILABILITY_NOTIFICATION_ID = 10436;
    @Deprecated
    @KeepForSdk
    static final AtomicBoolean sCanceledAvailabilityNotification;
    private static boolean zzb;
    @VisibleForTesting
    static boolean zza;
    private static final AtomicBoolean zzc;

    @Deprecated
    @ShowFirstParty
    @KeepForSdk
    public static int getApkVersion(@NonNull Context context) {
        try {
            Context context2 = context.getPackageManager().getPackageInfo(GOOGLE_PLAY_SERVICES_PACKAGE, 0);
            return context2.versionCode;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.w((String)"GooglePlayServicesUtil", (String)"Google Play services is missing.");
            return 0;
        }
    }

    @Deprecated
    @ShowFirstParty
    @KeepForSdk
    public static int getClientVersion(@NonNull Context context) {
        Context context2;
        Preconditions.checkState(true);
        Context context3 = context2;
        return ClientLibraryUtils.getClientVersion(context3, context3.getPackageName());
    }

    @ResultIgnorabilityUnspecified
    @Deprecated
    @HideFirstParty
    @KeepForSdk
    public static int isGooglePlayServicesAvailable(@NonNull Context context) {
        return GooglePlayServicesUtilLight.isGooglePlayServicesAvailable(context, GOOGLE_PLAY_SERVICES_VERSION_CODE);
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    @KeepForSdk
    public static int isGooglePlayServicesAvailable(@NonNull Context context, int minApkVersion) {
        PackageInfo packageInfo;
        PackageInfo packageInfo2;
        void var1_3;
        Object object;
        String string2;
        try {
            context.getResources().getString(R.string.common_google_play_services_unknown_issue);
        }
        catch (Throwable throwable) {
            Log.e((String)"GooglePlayServicesUtil", (String)"The Google Play services resources were not found. Check your project configuration to ensure that the resources are included.");
        }
        if (!GOOGLE_PLAY_SERVICES_PACKAGE.equals(string2 = object.getPackageName()) && !zzc.get()) {
            int n = zzah.zza((Context)object);
            if (n == 0) {
                throw new GooglePlayServicesMissingManifestValueException();
            }
            if (n != GOOGLE_PLAY_SERVICES_VERSION_CODE) {
                throw new GooglePlayServicesIncorrectManifestValueException(n);
            }
        }
        boolean bl = !DeviceProperties.isWearableWithoutPlayStore((Context)object) ? !DeviceProperties.zzb((Context)object) : false;
        boolean bl2 = var1_3 >= 0;
        Preconditions.checkArgument(bl2);
        String string3 = object.getPackageName();
        PackageManager packageManager = object.getPackageManager();
        if (bl) {
            packageInfo2 = packageManager.getPackageInfo(GOOGLE_PLAY_STORE_PACKAGE, 8256);
        }
        packageInfo2 = null;
        try {
            packageInfo = packageManager.getPackageInfo(GOOGLE_PLAY_SERVICES_PACKAGE, 64);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            object = String.valueOf(string3);
            String string4 = " requires Google Play services, but they are missing.";
            Log.w((String)"GooglePlayServicesUtil", (String)((String)object).concat(string4));
            return 1;
        }
        GoogleSignatureVerifier.getInstance((Context)object);
        if (!GoogleSignatureVerifier.zzb(packageInfo, true)) {
            object = String.valueOf(string3);
            String string5 = " requires Google Play services, but their signature is invalid.";
            Log.w((String)"GooglePlayServicesUtil", (String)((String)object).concat(string5));
            return 9;
        }
        if (bl) {
            Preconditions.checkNotNull(packageInfo2);
            if (!GoogleSignatureVerifier.zzb(packageInfo2, true)) {
                object = String.valueOf(string3);
                String string6 = " requires Google Play Store, but its signature is invalid.";
                Log.w((String)"GooglePlayServicesUtil", (String)((String)object).concat(string6));
                return 9;
            }
        }
        if (bl && packageInfo2 != null && !packageInfo2.signatures[0].equals((Object)packageInfo.signatures[0])) {
            object = String.valueOf(string3);
            String string7 = " requires Google Play Store, but its signature doesn't match that of Google Play services.";
            Log.w((String)"GooglePlayServicesUtil", (String)((String)object).concat(string7));
            return 9;
        }
        if (com.google.android.gms.common.util.zza.zza(packageInfo.versionCode) < com.google.android.gms.common.util.zza.zza((int)var1_3)) {
            int n = packageInfo.versionCode;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Google Play services out of date for ");
            stringBuilder.append(string3);
            stringBuilder.append(".  Requires ");
            stringBuilder.append((int)var1_3);
            stringBuilder.append(" but found ");
            stringBuilder.append(n);
            object = stringBuilder.toString();
            Log.w((String)"GooglePlayServicesUtil", (String)object);
            return 2;
        }
        object = packageInfo.applicationInfo;
        if (object == null) {
            object = packageManager.getApplicationInfo(GOOGLE_PLAY_SERVICES_PACKAGE, 0);
        }
        if (((ApplicationInfo)object).enabled) return 0;
        return 3;
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            object = String.valueOf(string3);
            String string8 = " requires the Google Play Store, but it is missing.";
            Log.w((String)"GooglePlayServicesUtil", (String)((String)object).concat(string8));
            return 9;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string9 = String.valueOf(string3);
            String string10 = " requires Google Play services, but they're missing when getting application info.";
            Log.wtf((String)"GooglePlayServicesUtil", (String)string9.concat(string10), (Throwable)nameNotFoundException);
            return 1;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @InlineMe(replacement="GoogleApiAvailabilityLight.getInstance().getErrorResolutionPendingIntent(context, errorCode, requestCode)", imports={"com.google.android.gms.common.GoogleApiAvailabilityLight"})
    @KeepForSdk
    @Nullable
    public static PendingIntent getErrorPendingIntent(int errorCode, @NonNull Context context, int requestCode) {
        void var2_2;
        int n;
        void var1_1;
        return GoogleApiAvailabilityLight.getInstance().getErrorResolutionPendingIntent((Context)var1_1, n, (int)var2_2);
    }

    @KeepForSdk
    @Nullable
    public static Context getRemoteContext(@NonNull Context context) {
        try {
            Context context2 = context.createPackageContext(GOOGLE_PLAY_SERVICES_PACKAGE, 3);
            return context2;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
    }

    @Deprecated
    @InlineMe(replacement="GoogleApiAvailabilityLight.getInstance().getErrorResolutionIntent(null, errorCode, null)", imports={"com.google.android.gms.common.GoogleApiAvailabilityLight"})
    @ShowFirstParty
    @KeepForSdk
    @Nullable
    public static Intent getGooglePlayServicesAvailabilityRecoveryIntent(int errorCode) {
        int n;
        return GoogleApiAvailabilityLight.getInstance().getErrorResolutionIntent(null, n, null);
    }

    @KeepForSdk
    @Nullable
    public static Resources getRemoteResource(@NonNull Context context) {
        try {
            Context context2 = context.getPackageManager().getResourcesForApplication(GOOGLE_PLAY_SERVICES_PACKAGE);
            return context2;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
    }

    @Deprecated
    @KeepForSdk
    @NonNull
    public static String getErrorString(int errorCode) {
        return ConnectionResult.zza(errorCode);
    }

    static {
        zzb = false;
        zza = false;
        sCanceledAvailabilityNotification = new AtomicBoolean();
        zzc = new AtomicBoolean();
    }

    @KeepForSdk
    GooglePlayServicesUtilLight() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    @KeepForSdk
    public static void cancelAvailabilityErrorNotifications(@NonNull Context context) {
        if (sCanceledAvailabilityNotification.getAndSet(true)) return;
        try {
            Context context2;
            if ((context2 = (NotificationManager)context2.getSystemService("notification")) == null) return;
            context2.cancel(10436);
            return;
        }
        catch (SecurityException securityException) {
            Log.d((String)"GooglePlayServicesUtil", (String)"Suppressing Security Exception %s in cancelAvailabilityErrorNotifications.", (Throwable)securityException);
            return;
        }
    }

    @ShowFirstParty
    @KeepForSdk
    public static void enableUsingApkIndependentContext() {
        zzc.set(true);
    }

    @Deprecated
    @KeepForSdk
    public static void ensurePlayServicesAvailable(@NonNull Context context, int minApkVersion) throws GooglePlayServicesRepairableException, GooglePlayServicesNotAvailableException {
        int n;
        Context context2;
        n = GoogleApiAvailabilityLight.getInstance().isGooglePlayServicesAvailable(context2, n);
        if (n != 0) {
            String string2 = "e";
            context2 = GoogleApiAvailabilityLight.getInstance().getErrorResolutionIntent(context2, n, string2);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("GooglePlayServices not available due to error ");
            stringBuilder.append(n);
            string2 = stringBuilder.toString();
            Log.e((String)"GooglePlayServicesUtil", (String)string2);
            if (context2 == null) {
                throw new GooglePlayServicesNotAvailableException(n);
            }
            string2 = "Google Play Services not available";
            throw new GooglePlayServicesRepairableException(n, string2, (Intent)context2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @ShowFirstParty
    @KeepForSdk
    public static boolean honorsDebugCertificates(@NonNull Context context) {
        if (zza) return zzb || !DeviceProperties.isUserBuild();
        try {
            boolean bl;
            Context context2;
            PackageInfo packageInfo = Wrappers.packageManager(context2).getPackageInfo(GOOGLE_PLAY_SERVICES_PACKAGE, 64);
            GoogleSignatureVerifier.getInstance(context2);
            if (packageInfo != null && !(bl = GoogleSignatureVerifier.zzb(packageInfo, false)) && (bl = GoogleSignatureVerifier.zzb(packageInfo, true))) {
                zzb = true;
            } else {
                zzb = false;
            }
            zza = true;
            return zzb || !DeviceProperties.isUserBuild();
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.w((String)"GooglePlayServicesUtil", (String)"Cannot find Google Play services package name.", (Throwable)nameNotFoundException);
        }
        catch (Throwable throwable) {
            zza = true;
            throw throwable;
        }
        zza = true;
        return zzb || !DeviceProperties.isUserBuild();
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @InlineMe(replacement="UidVerifier.isGooglePlayServicesUid(context, uid)", imports={"com.google.android.gms.common.util.UidVerifier"})
    @KeepForSdk
    public static boolean isGooglePlayServicesUid(@NonNull Context context, int uid) {
        void var1_1;
        return UidVerifier.isGooglePlayServicesUid(context, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @ShowFirstParty
    @KeepForSdk
    public static boolean isPlayServicesPossiblyUpdating(@NonNull Context context, int connectionStatusCode) {
        void var1_1;
        if (connectionStatusCode == 18) {
            return true;
        }
        if (var1_1 == true) {
            Context context2;
            return GooglePlayServicesUtilLight.zza(context2, GOOGLE_PLAY_SERVICES_PACKAGE);
        }
        return false;
    }

    @Deprecated
    @ShowFirstParty
    @KeepForSdk
    public static boolean isPlayStorePossiblyUpdating(@NonNull Context context, int connectionStatusCode) {
        if (connectionStatusCode == 9) {
            Context context2;
            return GooglePlayServicesUtilLight.zza(context2, GOOGLE_PLAY_STORE_PACKAGE);
        }
        return false;
    }

    @TargetApi(value=18)
    @KeepForSdk
    public static boolean isRestrictedUserProfile(@NonNull Context context) {
        if (PlatformVersion.isAtLeastJellyBeanMR2()) {
            String string2;
            Context context2;
            Object object = context2.getSystemService("user");
            Preconditions.checkNotNull(object);
            context2 = ((UserManager)object).getApplicationRestrictions(context2.getPackageName());
            if (context2 != null && "true".equals(context2.getString(string2 = "restricted_profile"))) {
                return true;
            }
        }
        return false;
    }

    @Deprecated
    @InlineMe(replacement="DeviceProperties.isSidewinder(context)", imports={"com.google.android.gms.common.util.DeviceProperties"})
    @ShowFirstParty
    @KeepForSdk
    public static boolean isSidewinderDevice(@NonNull Context context) {
        return DeviceProperties.isSidewinder(context);
    }

    @Deprecated
    @KeepForSdk
    public static boolean isUserRecoverableError(int errorCode) {
        switch (errorCode) {
            default: {
                return false;
            }
            case 1: 
            case 2: 
            case 3: 
            case 9: 
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @InlineMe(replacement="UidVerifier.uidHasPackageName(context, uid, packageName)", imports={"com.google.android.gms.common.util.UidVerifier"})
    @TargetApi(value=19)
    @KeepForSdk
    public static boolean uidHasPackageName(@NonNull Context context, int uid, @NonNull String packageName) {
        void var2_2;
        void var1_1;
        return UidVerifier.uidHasPackageName(context, (int)var1_1, (String)var2_2);
    }

    /*
     * Loose catch block
     */
    @TargetApi(value=21)
    static boolean zza(Context context, String string2) {
        block10: {
            block9: {
                Object object;
                boolean bl = string2.equals(GOOGLE_PLAY_SERVICES_PACKAGE);
                if (PlatformVersion.isAtLeastLollipop()) {
                    object = context.getPackageManager().getPackageInstaller().getAllSessions();
                    object = object.iterator();
                    while (object.hasNext()) {
                        if (!string2.equals(((PackageInstaller.SessionInfo)object.next()).getAppPackageName())) continue;
                        return true;
                    }
                }
                object = context.getPackageManager();
                try {
                    string2 = object.getApplicationInfo(string2, 8192);
                    if (!bl) break block9;
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    return false;
                }
                boolean bl2 = ((ApplicationInfo)string2).enabled;
                return bl2;
            }
            boolean bl = ((ApplicationInfo)string2).enabled;
            if (!bl) break block10;
            boolean bl3 = GooglePlayServicesUtilLight.isRestrictedUserProfile(context);
            if (bl3) break block10;
            return true;
        }
        return false;
        catch (Exception exception) {
            return false;
        }
    }
}

