/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.HideFirstParty;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.util.DeviceProperties;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.common.zzd;
import com.google.errorprone.annotations.ResultIgnorabilityUnspecified;

@ShowFirstParty
@KeepForSdk
public class GoogleApiAvailabilityLight {
    @KeepForSdk
    public static final int GOOGLE_PLAY_SERVICES_VERSION_CODE = GooglePlayServicesUtilLight.GOOGLE_PLAY_SERVICES_VERSION_CODE;
    @KeepForSdk
    @NonNull
    public static final String GOOGLE_PLAY_SERVICES_PACKAGE = "com.google.android.gms";
    @KeepForSdk
    @NonNull
    public static final String GOOGLE_PLAY_STORE_PACKAGE = "com.android.vending";
    @KeepForSdk
    static final String TRACKING_SOURCE_DIALOG = "d";
    @KeepForSdk
    static final String TRACKING_SOURCE_NOTIFICATION = "n";
    private static final GoogleApiAvailabilityLight zza = new GoogleApiAvailabilityLight();

    @ShowFirstParty
    @KeepForSdk
    public int getApkVersion(@NonNull Context context) {
        return GooglePlayServicesUtilLight.getApkVersion(context);
    }

    @ShowFirstParty
    @KeepForSdk
    public int getClientVersion(@NonNull Context context) {
        return GooglePlayServicesUtilLight.getClientVersion(context);
    }

    /*
     * WARNING - void declaration
     */
    @ResultIgnorabilityUnspecified
    @HideFirstParty
    @KeepForSdk
    public int isGooglePlayServicesAvailable(@NonNull Context context) {
        void var1_1;
        return this.isGooglePlayServicesAvailable((Context)var1_1, GOOGLE_PLAY_SERVICES_VERSION_CODE);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public int isGooglePlayServicesAvailable(@NonNull Context context, int minApkVersion) {
        void var1_2;
        void var2_3;
        int n = GooglePlayServicesUtilLight.isGooglePlayServicesAvailable(context, (int)var2_3);
        if (GooglePlayServicesUtilLight.isPlayServicesPossiblyUpdating((Context)var1_2, n)) {
            return 18;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    @KeepForSdk
    public PendingIntent getErrorResolutionPendingIntent(@NonNull Context context, int errorCode, int requestCode) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.getErrorResolutionPendingIntent((Context)var1_1, (int)var2_2, (int)var3_3, null);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    @ShowFirstParty
    @KeepForSdk
    public PendingIntent getErrorResolutionPendingIntent(@NonNull Context context, int errorCode, int requestCode, @Nullable String trackingSource) {
        void var3_3;
        void var4_4;
        void var2_2;
        void var1_1;
        if ((this = this.getErrorResolutionIntent((Context)var1_1, (int)var2_2, (String)var4_4)) == null) {
            return null;
        }
        return PendingIntent.getActivity((Context)var1_1, (int)var3_3, (Intent)this, (int)(zzd.zza | 0x8000000));
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @Nullable
    @ShowFirstParty
    @KeepForSdk
    public Intent getErrorResolutionIntent(int errorCode) {
        void var1_1;
        return this.getErrorResolutionIntent(null, (int)var1_1, null);
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    @ShowFirstParty
    @KeepForSdk
    public Intent getErrorResolutionIntent(@Nullable Context context, int errorCode, @Nullable String trackingSource) {
        Object object;
        Intent intent;
        block10: {
            switch (errorCode) {
                case 3: {
                    Intent intent2 = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
                    intent2.setData(Uri.fromParts((String)"package", (String)GOOGLE_PLAY_SERVICES_PACKAGE, null));
                    return intent2;
                }
                case 1: 
                case 2: {
                    void var3_4;
                    if (intent != null && DeviceProperties.isWearableWithoutPlayStore((Context)intent)) {
                        Intent intent3 = new Intent("com.google.android.clockwork.home.UPDATE_ANDROID_WEAR_ACTION");
                        intent3.setPackage("com.google.android.wearable.app");
                        return intent3;
                    }
                    object = new StringBuilder();
                    ((StringBuilder)object).append("gcore_");
                    ((StringBuilder)object).append(GOOGLE_PLAY_SERVICES_VERSION_CODE);
                    ((StringBuilder)object).append("-");
                    if (!TextUtils.isEmpty((CharSequence)var3_4)) {
                        ((StringBuilder)object).append((String)var3_4);
                    }
                    ((StringBuilder)object).append("-");
                    if (intent != null) {
                        ((StringBuilder)object).append(intent.getPackageName());
                    }
                    ((StringBuilder)object).append("-");
                    if (intent == null) break block10;
                    ((StringBuilder)object).append(Wrappers.packageManager((Context)intent).getPackageInfo((String)intent.getPackageName(), (int)0).versionCode);
                    break block10;
                }
                default: {
                    return null;
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        }
        object = ((StringBuilder)object).toString();
        intent = new Intent("android.intent.action.VIEW");
        Uri.Builder builder = Uri.parse((String)"market://details").buildUpon().appendQueryParameter("id", GOOGLE_PLAY_SERVICES_PACKAGE);
        if (!TextUtils.isEmpty((CharSequence)object)) {
            builder.appendQueryParameter("pcampaignid", (String)object);
        }
        intent.setData(builder.build());
        intent.setPackage(GOOGLE_PLAY_STORE_PACKAGE);
        intent.addFlags(524288);
        return intent;
    }

    @KeepForSdk
    @ShowFirstParty
    @NonNull
    public static GoogleApiAvailabilityLight getInstance() {
        return zza;
    }

    @KeepForSdk
    @NonNull
    public String getErrorString(int errorCode) {
        return GooglePlayServicesUtilLight.getErrorString(errorCode);
    }

    @KeepForSdk
    GoogleApiAvailabilityLight() {
    }

    @KeepForSdk
    public void cancelAvailabilityErrorNotifications(@NonNull Context context) {
        GooglePlayServicesUtilLight.cancelAvailabilityErrorNotifications(context);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public void verifyGooglePlayServicesIsAvailable(@NonNull Context context, int minApkVersion) throws GooglePlayServicesRepairableException, GooglePlayServicesNotAvailableException {
        void var2_2;
        GooglePlayServicesUtilLight.ensurePlayServicesAvailable(context, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @ShowFirstParty
    @KeepForSdk
    public boolean isPlayServicesPossiblyUpdating(@NonNull Context context, int errorCode) {
        void var2_2;
        return GooglePlayServicesUtilLight.isPlayServicesPossiblyUpdating(context, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @ShowFirstParty
    @KeepForSdk
    public boolean isPlayStorePossiblyUpdating(@NonNull Context context, int errorCode) {
        void var2_2;
        return GooglePlayServicesUtilLight.isPlayStorePossiblyUpdating(context, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public boolean isUninstalledAppPossiblyUpdating(@NonNull Context context, @NonNull String packageName) {
        void var2_2;
        return GooglePlayServicesUtilLight.zza(context, (String)var2_2);
    }

    @KeepForSdk
    public boolean isUserResolvableError(int errorCode) {
        return GooglePlayServicesUtilLight.isUserRecoverableError(errorCode);
    }
}

