/*
 * Decompiled with CFR 0.152.
 */
package com.github.yulichang.wrapper;

import com.baomidou.mybatisplus.core.conditions.SharedString;
import com.baomidou.mybatisplus.core.conditions.segments.MergeSegments;
import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.ArrayUtils;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.github.yulichang.toolkit.LambdaUtils;
import com.github.yulichang.wrapper.MPJAbstractLambdaWrapper;
import com.github.yulichang.wrapper.interfaces.LambdaJoin;
import com.github.yulichang.wrapper.interfaces.SFunctionQuery;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class MPJLambdaWrapper<T>
extends MPJAbstractLambdaWrapper<T, MPJLambdaWrapper<T>>
implements SFunctionQuery<MPJLambdaWrapper<T>>,
LambdaJoin<MPJLambdaWrapper<T>> {
    private SharedString sqlSelect = new SharedString();
    private final SharedString from = new SharedString();
    private final SharedString alias = new SharedString("t");
    private final List<SelectColumn> selectColumns = new ArrayList<SelectColumn>();
    private final List<SelectColumn> ignoreColumns = new ArrayList<SelectColumn>();
    private int tableIndex = 1;

    public MPJLambdaWrapper() {
    }

    MPJLambdaWrapper(T entity, Class<T> entityClass, SharedString sqlSelect, AtomicInteger paramNameSeq, Map<String, Object> paramNameValuePairs, MergeSegments mergeSegments, SharedString lastSql, SharedString sqlComment, SharedString sqlFirst, Map<Class<?>, Integer> subTable) {
        super.setEntity(entity);
        super.setEntityClass(entityClass);
        this.paramNameSeq = paramNameSeq;
        this.paramNameValuePairs = paramNameValuePairs;
        this.expression = mergeSegments;
        this.sqlSelect = sqlSelect;
        this.lastSql = lastSql;
        this.sqlComment = sqlComment;
        this.sqlFirst = sqlFirst;
        this.subTable = subTable;
    }

    @Override
    @SafeVarargs
    public final <S> MPJLambdaWrapper<T> select(SFunction<S, ?> ... columns) {
        if (ArrayUtils.isNotEmpty((Object[])columns)) {
            for (SFunction<S, ?> s : columns) {
                this.selectColumns.add(new SelectColumn(LambdaUtils.getEntityClass(s), LambdaUtils.getColumn(s), null));
            }
        }
        return (MPJLambdaWrapper)this.typedThis;
    }

    @Override
    public <E> MPJLambdaWrapper<T> select(Class<E> entityClass, Predicate<TableFieldInfo> predicate) {
        TableInfo info = TableInfoHelper.getTableInfo(entityClass);
        Assert.notNull((Object)info, (String)"table can not be find", (Object[])new Object[0]);
        info.getFieldList().stream().filter(predicate).collect(Collectors.toList()).forEach(i -> this.selectColumns.add(new SelectColumn(entityClass, i.getColumn(), null)));
        return (MPJLambdaWrapper)this.typedThis;
    }

    public final <S, X> MPJLambdaWrapper<T> selectAs(SFunction<S, ?> columns, SFunction<X, ?> alias) {
        return this.selectAs(columns, LambdaUtils.getName(alias));
    }

    public final <S, X> MPJLambdaWrapper<T> selectAs(SFunction<S, ?> columns, String alias) {
        this.selectColumns.add(new SelectColumn(LambdaUtils.getEntityClass(columns), LambdaUtils.getColumn(columns), alias));
        return (MPJLambdaWrapper)this.typedThis;
    }

    public final MPJLambdaWrapper<T> selectAll(Class<?> clazz) {
        TableInfo info = TableInfoHelper.getTableInfo(clazz);
        Assert.notNull((Object)info, (String)"table can not be find -> %s", (Object[])new Object[]{clazz});
        if (info.havePK()) {
            this.selectColumns.add(new SelectColumn(clazz, info.getKeyColumn(), null));
        }
        info.getFieldList().forEach(c -> this.selectColumns.add(new SelectColumn(clazz, c.getColumn(), null)));
        return (MPJLambdaWrapper)this.typedThis;
    }

    @SafeVarargs
    public final <S> MPJLambdaWrapper<T> selectIgnore(SFunction<S, ?> ... columns) {
        if (ArrayUtils.isNotEmpty((Object[])columns)) {
            for (SFunction<S, ?> s : columns) {
                this.ignoreColumns.add(new SelectColumn(LambdaUtils.getEntityClass(s), LambdaUtils.getColumn(s), null));
            }
        }
        return (MPJLambdaWrapper)this.typedThis;
    }

    @Override
    public String getSqlSelect() {
        if (StringUtils.isBlank((CharSequence)this.sqlSelect.getStringValue())) {
            if (CollectionUtils.isNotEmpty(this.ignoreColumns)) {
                this.selectColumns.removeIf(c -> this.ignoreColumns.stream().anyMatch(i -> i.getClazz() == c.getClazz() && Objects.equals(c.getColumnName(), i.getColumnName())));
            }
            String s = this.selectColumns.stream().map(i -> "t" + this.getDefault((Integer)this.subTable.get(i.getClazz())) + "." + i.getColumnName() + (StringUtils.isBlank((CharSequence)i.getAlias()) ? "" : " AS " + i.getAlias())).collect(Collectors.joining(","));
            this.sqlSelect.setStringValue(s);
        }
        return this.sqlSelect.getStringValue();
    }

    public String getFrom() {
        return this.from.getStringValue();
    }

    public String getAlias() {
        return this.alias.getStringValue();
    }

    @Override
    protected MPJLambdaWrapper<T> instance() {
        return new MPJLambdaWrapper(this.getEntity(), this.getEntityClass(), null, this.paramNameSeq, this.paramNameValuePairs, new MergeSegments(), SharedString.emptyString(), SharedString.emptyString(), SharedString.emptyString(), this.subTable);
    }

    @Override
    public void clear() {
        super.clear();
        this.sqlSelect.toNull();
    }

    @Override
    public <L, X> MPJLambdaWrapper<T> join(String keyWord, boolean condition, Class<L> clazz, SFunction<L, ?> left, SFunction<X, ?> right) {
        if (condition) {
            this.subTable.put(clazz, this.tableIndex);
            TableInfo leftInfo = TableInfoHelper.getTableInfo(clazz);
            StringBuilder sb = new StringBuilder(keyWord).append(leftInfo.getTableName()).append(" t").append(this.tableIndex).append(" ON t").append(this.tableIndex).append(".").append(LambdaUtils.getColumn(left)).append(" = t").append(this.getDefault((Integer)this.subTable.get(LambdaUtils.getEntityClass(right)))).append(".").append(LambdaUtils.getColumn(right));
            ++this.tableIndex;
            if (StringUtils.isBlank((CharSequence)this.from.getStringValue())) {
                this.from.setStringValue(sb.toString());
            } else {
                this.from.setStringValue(this.from.getStringValue() + sb.toString());
            }
        }
        return (MPJLambdaWrapper)this.typedThis;
    }

    public static class SelectColumn {
        private Class<?> clazz;
        private String columnName;
        private String alias;

        public SelectColumn(Class<?> clazz, String columnName, String alias) {
            this.clazz = clazz;
            this.columnName = columnName;
            this.alias = alias;
        }

        public Class<?> getClazz() {
            return this.clazz;
        }

        public void setClazz(Class<?> clazz) {
            this.clazz = clazz;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        public String getAlias() {
            return this.alias;
        }

        public void setAlias(String alias) {
            this.alias = alias;
        }
    }
}

