/*
 * Decompiled with CFR 0.152.
 */
package com.github.yulichang.wrapper;

import com.baomidou.mybatisplus.core.conditions.ISqlSegment;
import com.baomidou.mybatisplus.core.conditions.SharedString;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.interfaces.Join;
import com.baomidou.mybatisplus.core.conditions.interfaces.Nested;
import com.baomidou.mybatisplus.core.conditions.segments.MergeSegments;
import com.baomidou.mybatisplus.core.enums.SqlKeyword;
import com.baomidou.mybatisplus.core.enums.SqlLike;
import com.baomidou.mybatisplus.core.enums.WrapperKeyword;
import com.baomidou.mybatisplus.core.toolkit.ArrayUtils;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.SerializationUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.sql.SqlUtils;
import com.baomidou.mybatisplus.core.toolkit.sql.StringEscape;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.github.yulichang.wrapper.interfaces.Compare;
import com.github.yulichang.wrapper.interfaces.Func;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public abstract class MPJAbstractWrapper<T, Children extends MPJAbstractWrapper<T, Children>>
extends Wrapper<T>
implements Compare<Children>,
Nested<Children, Children>,
Join<Children>,
Func<Children> {
    protected final Children typedThis = this;
    protected AtomicInteger paramNameSeq;
    protected Map<String, Object> paramNameValuePairs;
    protected SharedString lastSql;
    protected SharedString sqlComment;
    protected SharedString sqlFirst;
    private T entity;
    protected MergeSegments expression;
    private Class<T> entityClass;

    public T getEntity() {
        return this.entity;
    }

    public Children setEntity(T entity) {
        this.entity = entity;
        return this.typedThis;
    }

    public Class<T> getEntityClass() {
        if (this.entityClass == null && this.entity != null) {
            this.entityClass = this.entity.getClass();
        }
        return this.entityClass;
    }

    public Children setEntityClass(Class<T> entityClass) {
        if (entityClass != null) {
            this.entityClass = entityClass;
        }
        return this.typedThis;
    }

    @Override
    public <X, V> Children allEq(boolean condition, Map<SFunction<X, ?>, V> params, boolean null2IsNull) {
        if (condition && CollectionUtils.isNotEmpty(params)) {
            params.forEach((k, v) -> {
                if (StringUtils.checkValNotNull((Object)v)) {
                    this.eq((SFunction)k, v);
                } else if (null2IsNull) {
                    this.isNull((SFunction)k);
                }
            });
        }
        return this.typedThis;
    }

    @Override
    public <X, V> Children allEq(boolean condition, BiPredicate<SFunction<X, ?>, V> filter, Map<SFunction<X, ?>, V> params, boolean null2IsNull) {
        if (condition && CollectionUtils.isNotEmpty(params)) {
            params.forEach((k, v) -> {
                if (filter.test((SFunction)k, (Object)v)) {
                    if (StringUtils.checkValNotNull((Object)v)) {
                        this.eq((SFunction)k, v);
                    } else if (null2IsNull) {
                        this.isNull((SFunction)k);
                    }
                }
            });
        }
        return this.typedThis;
    }

    @Override
    public <X> Children eq(boolean condition, SFunction<X, ?> column, Object val) {
        return this.addCondition(condition, column, SqlKeyword.EQ, val);
    }

    @Override
    public <X> Children ne(boolean condition, SFunction<X, ?> column, Object val) {
        return this.addCondition(condition, column, SqlKeyword.NE, val);
    }

    @Override
    public <X> Children gt(boolean condition, SFunction<X, ?> column, Object val) {
        return this.addCondition(condition, column, SqlKeyword.GT, val);
    }

    @Override
    public <X> Children ge(boolean condition, SFunction<X, ?> column, Object val) {
        return this.addCondition(condition, column, SqlKeyword.GE, val);
    }

    @Override
    public <X> Children lt(boolean condition, SFunction<X, ?> column, Object val) {
        return this.addCondition(condition, column, SqlKeyword.LT, val);
    }

    @Override
    public <X> Children le(boolean condition, SFunction<X, ?> column, Object val) {
        return this.addCondition(condition, column, SqlKeyword.LE, val);
    }

    @Override
    public <X> Children like(boolean condition, SFunction<X, ?> column, Object val) {
        return this.likeValue(condition, SqlKeyword.LIKE, column, val, SqlLike.DEFAULT);
    }

    @Override
    public <X> Children notLike(boolean condition, SFunction<X, ?> column, Object val) {
        return this.likeValue(condition, SqlKeyword.NOT_LIKE, column, val, SqlLike.DEFAULT);
    }

    @Override
    public <X> Children likeLeft(boolean condition, SFunction<X, ?> column, Object val) {
        return this.likeValue(condition, SqlKeyword.LIKE, column, val, SqlLike.LEFT);
    }

    @Override
    public <X> Children likeRight(boolean condition, SFunction<X, ?> column, Object val) {
        return this.likeValue(condition, SqlKeyword.LIKE, column, val, SqlLike.RIGHT);
    }

    @Override
    public <X> Children between(boolean condition, SFunction<X, ?> column, Object val1, Object val2) {
        return this.doIt(condition, new ISqlSegment[]{(ISqlSegment & Serializable)() -> this.columnToString(column), SqlKeyword.BETWEEN, (ISqlSegment & Serializable)() -> this.formatSql("{0}", val1), SqlKeyword.AND, (ISqlSegment & Serializable)() -> this.formatSql("{0}", val2)});
    }

    @Override
    public <X> Children notBetween(boolean condition, SFunction<X, ?> column, Object val1, Object val2) {
        return this.doIt(condition, new ISqlSegment[]{(ISqlSegment & Serializable)() -> this.columnToString(column), SqlKeyword.NOT_BETWEEN, (ISqlSegment & Serializable)() -> this.formatSql("{0}", val1), SqlKeyword.AND, (ISqlSegment & Serializable)() -> this.formatSql("{0}", val2)});
    }

    public Children and(boolean condition, Consumer<Children> consumer) {
        return ((MPJAbstractWrapper)this.and(condition)).addNestedCondition(condition, consumer);
    }

    public Children or(boolean condition, Consumer<Children> consumer) {
        return ((MPJAbstractWrapper)this.or(condition)).addNestedCondition(condition, consumer);
    }

    public Children nested(boolean condition, Consumer<Children> consumer) {
        return this.addNestedCondition(condition, consumer);
    }

    public Children not(boolean condition, Consumer<Children> consumer) {
        return ((MPJAbstractWrapper)this.not(condition)).addNestedCondition(condition, consumer);
    }

    public Children or(boolean condition) {
        return this.doIt(condition, new ISqlSegment[]{SqlKeyword.OR});
    }

    public Children apply(boolean condition, String applySql, Object ... value) {
        return this.doIt(condition, new ISqlSegment[]{WrapperKeyword.APPLY, (ISqlSegment & Serializable)() -> this.formatSql(applySql, value)});
    }

    public Children last(boolean condition, String lastSql) {
        if (condition) {
            this.lastSql.setStringValue(" " + lastSql);
        }
        return this.typedThis;
    }

    public Children comment(boolean condition, String comment) {
        if (condition) {
            this.sqlComment.setStringValue(comment);
        }
        return this.typedThis;
    }

    public Children first(boolean condition, String firstSql) {
        if (condition) {
            this.sqlFirst.setStringValue(firstSql);
        }
        return this.typedThis;
    }

    public Children exists(boolean condition, String existsSql) {
        return this.doIt(condition, new ISqlSegment[]{SqlKeyword.EXISTS, (ISqlSegment & Serializable)() -> String.format("(%s)", existsSql)});
    }

    public Children notExists(boolean condition, String existsSql) {
        return (Children)((MPJAbstractWrapper)this.not(condition)).exists(condition, existsSql);
    }

    @Override
    public <X> Children isNull(boolean condition, SFunction<X, ?> column) {
        return this.doIt(condition, new ISqlSegment[]{(ISqlSegment & Serializable)() -> this.columnToString(column), SqlKeyword.IS_NULL});
    }

    @Override
    public <X> Children isNotNull(boolean condition, SFunction<X, ?> column) {
        return this.doIt(condition, new ISqlSegment[]{(ISqlSegment & Serializable)() -> this.columnToString(column), SqlKeyword.IS_NOT_NULL});
    }

    @Override
    public <X> Children in(boolean condition, SFunction<X, ?> column, Collection<?> coll) {
        return this.doIt(condition, new ISqlSegment[]{(ISqlSegment & Serializable)() -> this.columnToString(column), SqlKeyword.IN, this.inExpression(coll)});
    }

    @Override
    public <X> Children notIn(boolean condition, SFunction<X, ?> column, Collection<?> coll) {
        return this.doIt(condition, new ISqlSegment[]{(ISqlSegment & Serializable)() -> this.columnToString(column), SqlKeyword.NOT_IN, this.inExpression(coll)});
    }

    @Override
    public <X> Children inSql(boolean condition, SFunction<X, ?> column, String inValue) {
        return this.doIt(condition, new ISqlSegment[]{(ISqlSegment & Serializable)() -> this.columnToString(column), SqlKeyword.IN, (ISqlSegment & Serializable)() -> String.format("(%s)", inValue)});
    }

    @Override
    public <X> Children notInSql(boolean condition, SFunction<X, ?> column, String inValue) {
        return this.doIt(condition, new ISqlSegment[]{(ISqlSegment & Serializable)() -> this.columnToString(column), SqlKeyword.NOT_IN, (ISqlSegment & Serializable)() -> String.format("(%s)", inValue)});
    }

    @Override
    public <X> Children groupBy(boolean condition, SFunction<X, ?> ... columns) {
        if (ArrayUtils.isEmpty((Object[])columns)) {
            return this.typedThis;
        }
        return this.doIt(condition, new ISqlSegment[]{SqlKeyword.GROUP_BY, (ISqlSegment & Serializable)() -> columns.length == 1 ? this.columnToString(columns[0]) : this.columnsToString(columns)});
    }

    @Override
    public <X> Children orderBy(boolean condition, boolean isAsc, SFunction<X, ?> ... columns) {
        if (ArrayUtils.isEmpty((Object[])columns)) {
            return this.typedThis;
        }
        SqlKeyword mode = isAsc ? SqlKeyword.ASC : SqlKeyword.DESC;
        for (SFunction column : columns) {
            this.doIt(condition, new ISqlSegment[]{SqlKeyword.ORDER_BY, (ISqlSegment & Serializable)() -> this.columnToString(column), mode});
        }
        return this.typedThis;
    }

    @Override
    public Children having(boolean condition, String sqlHaving, Object ... params) {
        return this.doIt(condition, new ISqlSegment[]{SqlKeyword.HAVING, (ISqlSegment & Serializable)() -> this.formatSqlIfNeed(condition, sqlHaving, params)});
    }

    @Override
    public Children func(boolean condition, Consumer<Children> consumer) {
        if (condition) {
            consumer.accept(this.typedThis);
        }
        return this.typedThis;
    }

    protected Children not(boolean condition) {
        return this.doIt(condition, new ISqlSegment[]{SqlKeyword.NOT});
    }

    protected Children and(boolean condition) {
        return this.doIt(condition, new ISqlSegment[]{SqlKeyword.AND});
    }

    protected <X> Children likeValue(boolean condition, SqlKeyword keyword, SFunction<X, ?> column, Object val, SqlLike sqlLike) {
        return this.doIt(condition, new ISqlSegment[]{(ISqlSegment & Serializable)() -> this.columnToString(column), keyword, (ISqlSegment & Serializable)() -> this.formatSql("{0}", SqlUtils.concatLike((Object)val, (SqlLike)sqlLike))});
    }

    protected <X> Children addCondition(boolean condition, SFunction<X, ?> column, SqlKeyword sqlKeyword, Object val) {
        return this.doIt(condition, new ISqlSegment[]{(ISqlSegment & Serializable)() -> this.columnToString(column), sqlKeyword, (ISqlSegment & Serializable)() -> this.formatSql("{0}", val)});
    }

    protected Children addNestedCondition(boolean condition, Consumer<Children> consumer) {
        if (condition) {
            Children instance = this.instance();
            consumer.accept(instance);
            return this.doIt(true, new ISqlSegment[]{WrapperKeyword.APPLY, instance});
        }
        return this.typedThis;
    }

    protected abstract Children instance();

    protected final String formatSql(String sqlStr, Object ... params) {
        return this.formatSqlIfNeed(true, sqlStr, params);
    }

    protected final String formatSqlIfNeed(boolean need, String sqlStr, Object ... params) {
        if (!need || StringUtils.isBlank((CharSequence)sqlStr)) {
            return null;
        }
        if (ArrayUtils.isNotEmpty((Object[])params)) {
            for (int i = 0; i < params.length; ++i) {
                String genParamName = "MPGENVAL" + this.paramNameSeq.incrementAndGet();
                sqlStr = sqlStr.replace(String.format("{%s}", i), String.format("#{%s.paramNameValuePairs.%s}", "ew", genParamName));
                this.paramNameValuePairs.put(genParamName, params[i]);
            }
        }
        return sqlStr;
    }

    private ISqlSegment inExpression(Collection<?> value) {
        return (ISqlSegment & Serializable)() -> value.stream().map(i -> this.formatSql("{0}", i)).collect(Collectors.joining(",", "(", ")"));
    }

    protected void initNeed() {
        this.paramNameSeq = new AtomicInteger(0);
        this.paramNameValuePairs = new HashMap<String, Object>(16);
        this.expression = new MergeSegments();
        this.lastSql = SharedString.emptyString();
        this.sqlComment = SharedString.emptyString();
        this.sqlFirst = SharedString.emptyString();
    }

    public void clear() {
        this.entity = null;
        this.paramNameSeq.set(0);
        this.paramNameValuePairs.clear();
        this.expression.clear();
        this.lastSql.toEmpty();
        this.sqlComment.toEmpty();
        this.sqlFirst.toEmpty();
    }

    protected Children doIt(boolean condition, ISqlSegment ... sqlSegments) {
        if (condition) {
            this.expression.add(sqlSegments);
        }
        return this.typedThis;
    }

    public String getSqlSegment() {
        return this.expression.getSqlSegment() + this.lastSql.getStringValue();
    }

    public String getSqlComment() {
        if (StringUtils.isNotBlank((CharSequence)this.sqlComment.getStringValue())) {
            return "/*" + StringEscape.escapeRawString((String)this.sqlComment.getStringValue()) + "*/";
        }
        return null;
    }

    public String getSqlFirst() {
        if (StringUtils.isNotBlank((CharSequence)this.sqlFirst.getStringValue())) {
            return StringEscape.escapeRawString((String)this.sqlFirst.getStringValue());
        }
        return null;
    }

    public MergeSegments getExpression() {
        return this.expression;
    }

    public Map<String, Object> getParamNameValuePairs() {
        return this.paramNameValuePairs;
    }

    protected <X> String columnToString(X column) {
        return (String)column;
    }

    protected <X> String columnsToString(X ... columns) {
        return Arrays.stream(columns).map(this::columnToString).collect(Collectors.joining(","));
    }

    public Children clone() {
        return (Children)((MPJAbstractWrapper)SerializationUtils.clone(this.typedThis));
    }
}

