/*
 * Decompiled with CFR 0.152.
 */
package org.math.R;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.math.R.BusyListener;
import org.math.R.EvalListener;
import org.math.R.Logger;
import org.math.R.Rdaemon;
import org.math.R.RserverConf;
import org.math.R.Slf4jLogger;
import org.math.R.UpdateObjectsListener;
import org.rosuda.REngine.REXP;
import org.rosuda.REngine.REXPDouble;
import org.rosuda.REngine.REXPInteger;
import org.rosuda.REngine.REXPList;
import org.rosuda.REngine.REXPLogical;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.REngine.REXPNull;
import org.rosuda.REngine.REXPString;
import org.rosuda.REngine.REngineException;
import org.rosuda.REngine.RList;
import org.rosuda.REngine.Rserve.RConnection;
import org.rosuda.REngine.Rserve.RFileInputStream;
import org.rosuda.REngine.Rserve.RFileOutputStream;
import org.rosuda.REngine.Rserve.RserveException;

public class Rsession
implements Logger {
    public static final String HEAD_TRY = "";
    public boolean TRY_MODE_DEFAULT = true;
    public boolean TRY_MODE = false;
    public static final String CAST_ERROR = "Cannot cast ";
    private static final String __ = "  ";
    private static final String _PACKAGE_ = "  package ";
    public RConnection connection;
    Logger console;
    boolean tryLocalRServe;
    public static final String PACKAGEINSTALLED = "Package installed.";
    public static final String PACKAGELOADED = "Package loaded.";
    public boolean connected = false;
    static String separator = ",";
    public static final int MinRserveVersion = 103;
    Rdaemon localRserve;
    public RserverConf RserveConf;
    public static final String STATUS_NOT_SET = "Unknown status";
    public static final String STATUS_READY = "Ready";
    public static final String STATUS_ERROR = "Error";
    public static final String STATUS_ENDED = "End";
    public static final String STATUS_NOT_CONNECTED = "Not connected";
    public static final String STATUS_CONNECTING = "Connecting...";
    public String status = "Unknown status";
    List<Logger> loggers;
    public boolean debug;
    List<BusyListener> busy = new LinkedList<BusyListener>();
    List<UpdateObjectsListener> updateObjects = new LinkedList<UpdateObjectsListener>();
    List<EvalListener> eval = new LinkedList<EvalListener>();
    public static final boolean UNIX_OPTIMIZE = true;
    String lastmessage = "";
    int repeated = 0;
    public static String DEFAULT_REPOS = "http://cran.irsn.fr/";
    public String repos = DEFAULT_REPOS;
    private static String loadedpacks = "loadedpacks";
    private static String packs = "packs";
    static final String HEAD_EVAL = "[eval] ";
    static final String HEAD_EXCEPTION = "[exception] ";
    static final String HEAD_ERROR = "[error] ";
    static final String HEAD_CACHE = "[cache] ";
    boolean SINK_OUTPUT = true;
    String SINK_FILE = ".Rout";
    String lastOuput = "";
    public boolean SAVE_ASCII = false;
    static final String[] types = new String[]{"data.frame", "null", "function", "array", "integer", "character", "double"};
    public static final String HEAD_SET = "[set] ";
    public static final String GRAPHIC_PNG = "png";
    public static final String GRAPHIC_JPEG = "jpeg";
    public static final String GRAPHIC_BMP = "bmp";
    public static final String GRAPHIC_TIFF = "tiff";
    static final String IO_HEAD = "[IO] ";
    static final String testExpression = "1+pi";
    static final double testResult = 4.141592653589793;
    Map<String, Object> noVarsEvals = new HashMap<String, Object>();
    static final String AW = "((\\A)|(\\W))(";
    static final String Az = ")((\\W)|(\\z))";

    void cleanupListeners() {
        if (this.loggers != null) {
            while (!this.loggers.isEmpty()) {
                this.removeLogger(this.loggers.get(0));
            }
        }
        if (this.busy != null) {
            while (!this.busy.isEmpty()) {
                this.removeBusyListener(this.busy.get(0));
            }
        }
        if (this.updateObjects != null) {
            while (!this.updateObjects.isEmpty()) {
                this.removeUpdateObjectsListener(this.updateObjects.get(0));
            }
        }
        if (this.eval != null) {
            while (!this.eval.isEmpty()) {
                this.removeEvalListener(this.eval.get(0));
            }
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public void addLogger(Logger l) {
        if (!this.loggers.contains(l)) {
            this.loggers.add(l);
        }
    }

    public void removeLogger(Logger l) {
        if (this.loggers.contains(l)) {
            l.close();
            this.loggers.remove(l);
        }
    }

    @Override
    public void close() {
        for (Logger l : this.loggers) {
            l.close();
        }
    }

    @Override
    public void println(String message, Logger.Level level) {
        if (level == Logger.Level.ERROR) {
            try {
                message = message + "\n R> " + this.getLastLogEntry() + "\n R! " + this.getLastError();
            }
            catch (Exception e) {
                message = message + "\n ! " + e.getMessage();
            }
        }
        for (Logger l : this.loggers) {
            l.println(message, level);
        }
    }

    public void addBusyListener(BusyListener b) {
        if (!this.busy.contains(b)) {
            this.busy.add(b);
        }
    }

    public void removeBusyListener(BusyListener b) {
        if (this.busy.contains(b)) {
            this.busy.remove(b);
        }
    }

    public void setBusy(boolean bb) {
        for (BusyListener b : this.busy) {
            b.setBusy(bb);
        }
    }

    public void addUpdateObjectsListener(UpdateObjectsListener b) {
        if (!this.updateObjects.contains(b)) {
            this.updateObjects.add(b);
        }
    }

    public void removeUpdateObjectsListener(UpdateObjectsListener b) {
        if (this.updateObjects.contains(b)) {
            b.setTarget(null);
            this.updateObjects.remove(b);
        }
    }

    public void addEvalListener(EvalListener b) {
        if (!this.eval.contains(b)) {
            this.eval.add(b);
        }
    }

    public void removeEvalListener(EvalListener b) {
        if (this.eval.contains(b)) {
            this.eval.remove(b);
        }
    }

    public static String toString(Object o) {
        if (o == null) {
            return "NULL";
        }
        if (o instanceof double[]) {
            return Rsession.cat((double[])o);
        }
        if (o instanceof double[][]) {
            return Rsession.cat((double[][])o);
        }
        if (o instanceof int[]) {
            return Rsession.cat((int[])o);
        }
        if (o instanceof int[][]) {
            return Rsession.cat((int[][])o);
        }
        if (o instanceof Object[]) {
            return Rsession.cat((Object[])o);
        }
        if (o instanceof Object[][]) {
            return Rsession.cat((Object[][])o);
        }
        if (o instanceof RList) {
            return Rsession.cat((RList)o);
        }
        return o.toString();
    }

    public static String cat(RList list) {
        try {
            int i;
            StringBuffer sb = new StringBuffer("\t");
            double[][] data = new double[list.names.size()][];
            for (i = 0; i < list.size(); ++i) {
                String n = list.keyAt(i);
                sb.append(n + "\t");
                data[i] = list.at(n).asDoubles();
            }
            sb.append("\n");
            for (i = 0; i < data[0].length; ++i) {
                sb.append(i + 1 + "\t");
                for (int j = 0; j < data.length; ++j) {
                    sb.append(data[j][i] + "\t");
                }
                sb.append("\n");
            }
            return sb.toString();
        }
        catch (REXPMismatchException r) {
            return "(Not a numeric dataframe)\n" + new REXPList(list).toDebugString();
        }
    }

    public static String cat(double[] array) {
        if (array == null || array.length == 0) {
            return "NA";
        }
        String o = array[0] + HEAD_TRY;
        if (array.length > 1) {
            for (int i = 1; i < array.length; ++i) {
                o = o + separator + array[i] + HEAD_TRY;
            }
        }
        return o;
    }

    public static String cat(int[] array) {
        if (array == null || array.length == 0) {
            return "NA";
        }
        String o = array[0] + HEAD_TRY;
        if (array.length > 1) {
            for (int i = 1; i < array.length; ++i) {
                o = o + separator + array[i] + HEAD_TRY;
            }
        }
        return o;
    }

    public static String cat(double[][] array) {
        if (array == null || array.length == 0 || array[0].length == 0) {
            return "NA";
        }
        String o = Rsession.cat(array[0]);
        if (array.length > 1) {
            for (int i = 1; i < array.length; ++i) {
                o = o + "\n" + Rsession.cat(array[i]);
            }
        }
        return o;
    }

    public static String cat(int[][] array) {
        if (array == null || array.length == 0 || array[0].length == 0) {
            return "NA";
        }
        String o = Rsession.cat(array[0]);
        if (array.length > 1) {
            for (int i = 1; i < array.length; ++i) {
                o = o + "\n" + Rsession.cat(array[i]);
            }
        }
        return o;
    }

    public static String cat(Object[] array) {
        if (array == null || array.length == 0 || array[0] == null) {
            return HEAD_TRY;
        }
        String o = array[0].toString();
        if (array.length > 1) {
            for (int i = 1; i < array.length; ++i) {
                o = o + separator + (array[i] == null ? HEAD_TRY : array[i].toString());
            }
        }
        return o;
    }

    public static String cat(String sep, String[] array) {
        if (array == null || array.length == 0 || array[0] == null) {
            return HEAD_TRY;
        }
        String o = array[0].toString();
        if (array.length > 1) {
            for (int i = 1; i < array.length; ++i) {
                o = o + sep + (array[i] == null ? HEAD_TRY : array[i].toString());
            }
        }
        return o;
    }

    public static String cat(Object[][] array) {
        if (array == null || array.length == 0 || array[0].length == 0) {
            return "NA";
        }
        String o = Rsession.cat(array[0]);
        if (array.length > 1) {
            for (int i = 1; i < array.length; ++i) {
                o = o + "\n" + Rsession.cat(array[i]);
            }
        }
        return o;
    }

    public static String toRpath(File path) {
        return Rsession.toRpath(path.getAbsolutePath());
    }

    public static String toRpath(String path) {
        return path.replaceAll("\\\\", "/");
    }

    public static Rsession newLocalInstance(Logger console, Properties localRProperties) {
        return new Rsession(console, RserverConf.newLocalInstance(localRProperties), false);
    }

    public static Rsession newRemoteInstance(Logger console, RserverConf serverconf) {
        return new Rsession(console, serverconf, false);
    }

    public static Rsession newInstanceTry(Logger console, RserverConf serverconf) {
        return new Rsession(console, serverconf, true);
    }

    public static Rsession newLocalInstance(PrintStream pconsole, Properties localRProperties) {
        return new Rsession(pconsole, RserverConf.newLocalInstance(localRProperties), false);
    }

    public static Rsession newRemoteInstance(PrintStream pconsole, RserverConf serverconf) {
        return new Rsession(pconsole, serverconf, false);
    }

    public static Rsession newInstanceTry(PrintStream pconsole, RserverConf serverconf) {
        return new Rsession(pconsole, serverconf, true);
    }

    public Rsession(Logger console, RserverConf serverconf, boolean tryLocalRServe) {
        this.console = console;
        this.RserveConf = serverconf;
        this.tryLocalRServe = tryLocalRServe;
        this.loggers = new LinkedList<Logger>();
        this.loggers.add(console);
        this.startup();
    }

    public Rsession(final PrintStream p, RserverConf serverconf, boolean tryLocalRServe) {
        this(new Logger(){

            @Override
            public void println(String string, Logger.Level level) {
                if (level == Logger.Level.WARNING) {
                    p.print("(!) ");
                } else if (level == Logger.Level.ERROR) {
                    p.print("(!!) ");
                }
                p.println(string);
            }

            @Override
            public void close() {
                p.close();
            }
        }, serverconf, tryLocalRServe);
    }

    public Rsession(RserverConf serverconf, boolean tryLocalRServe) {
        this(new Slf4jLogger(), serverconf, tryLocalRServe);
    }

    void startup() {
        if (this.RserveConf == null) {
            if (this.tryLocalRServe) {
                this.RserveConf = RserverConf.newLocalInstance(null);
                this.println("No Rserve conf given. Trying to use " + this.RserveConf.toString(), Logger.Level.WARNING);
                this.begin(true);
            } else {
                this.println("No Rserve conf given. Failed to start session.", Logger.Level.ERROR);
                this.status = STATUS_ERROR;
            }
        } else {
            this.begin(this.tryLocalRServe);
        }
    }

    public String getStatus() {
        return this.status;
    }

    void begin(boolean tryLocal) {
        String message;
        this.status = STATUS_NOT_CONNECTED;
        this.status = STATUS_CONNECTING;
        this.connection = this.RserveConf.connect();
        boolean bl = this.connected = this.connection != null;
        if (!this.connected) {
            this.status = STATUS_ERROR;
            message = "Rserve " + this.RserveConf + " is not accessible.";
            this.println(message, Logger.Level.ERROR);
        } else if (this.connection.getServerVersion() < 103) {
            this.status = STATUS_ERROR;
            message = "Rserve " + this.RserveConf + " version is too old.";
            this.println(message, Logger.Level.ERROR);
        } else {
            this.status = STATUS_READY;
            return;
        }
        if (tryLocal) {
            this.status = STATUS_CONNECTING;
            this.RserveConf = RserverConf.newLocalInstance(this.RserveConf.properties);
            this.println("Trying to spawn " + this.RserveConf.toString(), Logger.Level.INFO);
            this.localRserve = new Rdaemon(this.RserveConf, this);
            String http_proxy = null;
            if (this.RserveConf != null && this.RserveConf.properties != null && this.RserveConf.properties.containsKey("http_proxy")) {
                http_proxy = this.RserveConf.properties.getProperty("http_proxy");
            }
            this.localRserve.start(http_proxy);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
            this.connection = this.RserveConf.connect();
            boolean bl2 = this.connected = this.connection != null;
            if (!this.connected) {
                String message2 = "Failed to launch local Rserve. Unable to initialize Rsession.";
                this.println(message2, Logger.Level.ERROR);
                System.err.println(message2);
                throw new IllegalArgumentException(message2);
            }
            this.println("Local Rserve started. (Version " + this.connection.getServerVersion() + ")", Logger.Level.INFO);
        }
    }

    public void end() {
        if (this.connection == null) {
            this.log("Void session terminated.", Logger.Level.INFO);
            this.cleanupListeners();
            return;
        }
        if (!System.getProperty("os.name").contains("Win") && this.localRserve != null) {
            this.log("Ending local session...", Logger.Level.INFO);
            this.localRserve.stop();
            this.connection.close();
        } else {
            this.log("Ending remote session...", Logger.Level.INFO);
            this.connection.close();
        }
        this.log("Session teminated.", Logger.Level.INFO);
        this.connection = null;
        this.cleanupListeners();
    }

    public String getLastLogEntry() {
        return this.lastmessage;
    }

    public String getLastError() {
        return this.connection.getLastError();
    }

    public void log(String message, Logger.Level level) {
        if (message != null && message.trim().length() > 0 && !message.trim().equals("\n") && level == Logger.Level.OUTPUT) {
            this.println(message, level);
        } else {
            if (message == null) {
                return;
            }
            if ((message = message.trim()).equals(this.lastmessage) && this.repeated < 100) {
                ++this.repeated;
            } else if (this.repeated > 0) {
                this.println("    Repeated " + this.repeated + " times.", level);
                this.repeated = 0;
                this.lastmessage = message;
                this.println(message, level);
            } else {
                this.lastmessage = message;
                this.println(message, level);
            }
        }
    }

    public String[] listCommands() {
        this.silentlyEval(".keyWords <- function() {n <- length(search());result <- c();for (i in 1:n) {result <- c(result,ls(pos=i,all.names=TRUE))}; result}");
        REXP rexp = this.silentlyEval(".keyWords()");
        String[] as = null;
        try {
            if (rexp != null && (as = rexp.asStrings()) != null) {
                return as;
            }
            return null;
        }
        catch (REXPMismatchException ex) {
            this.log(HEAD_ERROR + ex.getMessage() + "\n  listCommands()", Logger.Level.ERROR);
            return null;
        }
    }

    public void setCRANRepository(String url) {
        this.repos = url;
    }

    public String getCRANRepository() {
        return this.repos;
    }

    public boolean isPackageLoaded(String pack) {
        this.silentlyVoidEval(loadedpacks + "<-.packages()", false);
        boolean isloaded = false;
        try {
            REXP i = this.silentlyEval("is.element(set=" + loadedpacks + ",el='" + pack + "')");
            if (i != null) {
                isloaded = i.asInteger() == 1;
            }
        }
        catch (REXPMismatchException ex) {
            this.log(HEAD_ERROR + ex.getMessage() + "\n  isPackageLoaded(String pack=" + pack + ")", Logger.Level.ERROR);
        }
        if (isloaded) {
            this.log(_PACKAGE_ + pack + " is loaded.", Logger.Level.INFO);
        } else {
            this.log(_PACKAGE_ + pack + " is not loaded.", Logger.Level.INFO);
        }
        return isloaded;
    }

    public boolean isPackageInstalled(String pack, String version) {
        this.silentlyVoidEval(packs + "<-installed.packages(noCache=TRUE)", false);
        boolean isinstalled = false;
        REXP r = this.silentlyEval("is.element(set=" + packs + ",el='" + pack + "')");
        try {
            if (r != null) {
                isinstalled = r.asInteger() == 1;
            } else {
                this.log("[error] Could not list installed packages\n  isPackageInstalled(String pack=" + pack + ", String version=" + version + ")", Logger.Level.ERROR);
            }
        }
        catch (REXPMismatchException ex) {
            this.log(HEAD_ERROR + ex.getMessage() + "\n  isPackageInstalled(String pack=" + pack + ", String version=" + version + ")", Logger.Level.ERROR);
        }
        if (isinstalled) {
            this.log(_PACKAGE_ + pack + " is installed.", Logger.Level.INFO);
        } else {
            this.log(_PACKAGE_ + pack + " is not installed.", Logger.Level.INFO);
        }
        if (isinstalled && version != null && version.length() > 0) {
            try {
                isinstalled = this.silentlyEval(packs + "['" + pack + "','Version'] == \"" + version + "\"").asInteger() == 1;
            }
            catch (REXPMismatchException ex) {
                this.log(HEAD_ERROR + ex.getMessage() + "\n  isPackageInstalled(String pack=" + pack + ", String version=" + version + ")", Logger.Level.ERROR);
            }
            try {
                this.log("    version of package " + pack + " is " + this.silentlyEval(packs + "['" + pack + "','Version']").asString(), Logger.Level.INFO);
            }
            catch (REXPMismatchException ex) {
                this.log(HEAD_ERROR + ex.getMessage() + "\n  isPackageInstalled(String pack=" + pack + ", String version=" + version + ")", Logger.Level.ERROR);
            }
            if (isinstalled) {
                this.log(_PACKAGE_ + pack + " (" + version + ") " + " is installed.", Logger.Level.INFO);
            } else {
                this.log(_PACKAGE_ + pack + " (" + version + ") " + " is not installed.", Logger.Level.INFO);
            }
        }
        return isinstalled;
    }

    public String installPackages(String[] pack, boolean load) {
        String resall = HEAD_TRY;
        for (String pv : pack) {
            String res = this.installPackage(pv, load);
            if (load) {
                if (res.equals(PACKAGELOADED)) continue;
                resall = resall + "\n" + res;
                continue;
            }
            if (res.equals(PACKAGEINSTALLED)) continue;
            resall = resall + "\n" + res;
        }
        if (resall.length() > 0) {
            return resall;
        }
        return load ? PACKAGELOADED : PACKAGEINSTALLED;
    }

    public String installPackage(File pack, boolean load) {
        this.sendFile(pack);
        this.eval("install.packages('" + pack.getName() + "',repos=NULL," + "dependencies=TRUE)");
        this.log("  request package " + pack + " install...", Logger.Level.INFO);
        String name = pack.getName();
        if (name.contains("_")) {
            name = name.substring(0, name.indexOf("_"));
        }
        if (name.contains(".")) {
            name = name.substring(0, name.indexOf("."));
        }
        if (this.isPackageInstalled(name, null)) {
            this.log(_PACKAGE_ + pack + " installation sucessfull.", Logger.Level.INFO);
            if (load) {
                return this.loadPackage(name);
            }
            return PACKAGEINSTALLED;
        }
        this.log(_PACKAGE_ + pack + " installation failed.", Logger.Level.ERROR);
        if (load) {
            return this.loadPackage(name);
        }
        return "Impossible to install package " + pack + " !";
    }

    public String installPackage(final String pack, File dir, boolean load) {
        File[] pack_files;
        this.log("  trying to load package " + pack, Logger.Level.INFO);
        if (this.isPackageInstalled(pack, null)) {
            this.log(_PACKAGE_ + pack + " already installed.", Logger.Level.INFO);
            if (load) {
                return this.loadPackage(pack);
            }
            return PACKAGEINSTALLED;
        }
        this.log(_PACKAGE_ + pack + " not yet installed.", Logger.Level.INFO);
        File[] fileArray = pack_files = dir == null ? null : dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (!pathname.getName().contains(pack)) {
                    return false;
                }
                if (Rsession.this.RServeOSisWindows()) {
                    return pathname.getName().endsWith(".zip");
                }
                if (Rsession.this.RServeOSisLinux()) {
                    return pathname.getName().endsWith(".tar.gz");
                }
                if (Rsession.this.RServeOSisMacOSX()) {
                    return pathname.getName().endsWith(".tgz");
                }
                return false;
            }
        });
        if (pack_files == null || pack_files.length == 0) {
            this.log("  impossible to find package " + pack + " in directory " + dir.getAbsolutePath() + " !", Logger.Level.WARNING);
            return "Impossible to find package " + pack + " in directory " + dir.getAbsolutePath() + " !";
        }
        this.log("  found package " + pack + " : " + pack_files[0].getAbsolutePath(), Logger.Level.INFO);
        this.sendFile(pack_files[0]);
        this.eval("install.packages('" + pack_files[0].getName() + "',repos=NULL," + "dependencies=TRUE)", this.TRY_MODE);
        this.log("  request package " + pack + " install...", Logger.Level.INFO);
        if (this.isPackageInstalled(pack, null)) {
            this.log(_PACKAGE_ + pack + " installation sucessfull.", Logger.Level.INFO);
            if (load) {
                return this.loadPackage(pack);
            }
            return PACKAGEINSTALLED;
        }
        this.log(_PACKAGE_ + pack + " installation failed.", Logger.Level.ERROR);
        if (load) {
            return this.loadPackage(pack);
        }
        return "Impossible to install package " + pack + " !";
    }

    public String installPackage(String pack, boolean load) {
        this.log("  trying to load package " + pack, Logger.Level.INFO);
        if (this.isPackageInstalled(pack, null)) {
            this.log(_PACKAGE_ + pack + " already installed.", Logger.Level.INFO);
            if (load) {
                return this.loadPackage(pack);
            }
            return PACKAGEINSTALLED;
        }
        this.log(_PACKAGE_ + pack + " not yet installed.", Logger.Level.INFO);
        this.eval("install.packages('" + pack + "',repos='" + this.repos + "'," + "dependencies=TRUE)", this.TRY_MODE);
        this.log("  request package " + pack + " install...", Logger.Level.INFO);
        if (this.isPackageInstalled(pack, null)) {
            this.log(_PACKAGE_ + pack + " installation sucessfull.", Logger.Level.INFO);
            if (load) {
                return this.loadPackage(pack);
            }
            return PACKAGEINSTALLED;
        }
        this.log(_PACKAGE_ + pack + " installation failed.", Logger.Level.ERROR);
        if (load) {
            return this.loadPackage(pack);
        }
        return "Impossible to install package " + pack + " !";
    }

    public String loadPackage(String pack) {
        this.log("  request package " + pack + " loading...", Logger.Level.INFO);
        try {
            boolean ok;
            boolean bl = ok = this.eval("library(" + pack + ",logical.return=T,quietly=T,verbose=F)", this.TRY_MODE).asBytes()[0] == 1;
            if (ok) {
                this.log(_PACKAGE_ + pack + " loading sucessfull.", Logger.Level.INFO);
                return PACKAGELOADED;
            }
            this.log(_PACKAGE_ + pack + " loading failed.", Logger.Level.ERROR);
            return "Impossible to load package " + pack + ": " + this.getLastLogEntry() + "," + this.getLastError();
        }
        catch (Exception ex) {
            this.log(_PACKAGE_ + pack + " loading failed.", Logger.Level.ERROR);
            return "Impossible to load package " + pack + ": " + ex.getLocalizedMessage();
        }
    }

    public boolean silentlyVoidEval(String expression) {
        return this.silentlyVoidEval(expression, this.TRY_MODE_DEFAULT);
    }

    public String getLastOutput() {
        if (!this.SINK_OUTPUT) {
            return null;
        }
        return this.lastOuput;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean silentlyVoidEval(String expression, boolean tryEval) {
        if (!this.connected) {
            this.log("[exception] R environment not initialized.", Logger.Level.ERROR);
            return false;
        }
        if (expression == null) {
            return false;
        }
        if (expression.trim().length() == 0) {
            return true;
        }
        for (EvalListener b : this.eval) {
            b.eval(expression);
        }
        REXP e = null;
        try {
            EvalListener b;
            b = this.connection;
            synchronized (b) {
                if (this.SINK_OUTPUT) {
                    this.connection.parseAndEval("sink('" + this.SINK_FILE + "',type='output')");
                }
                e = tryEval ? this.connection.parseAndEval("try(eval(parse(text='" + expression.replace("'", "\\'") + "')),silent=FALSE)") : this.connection.parseAndEval(expression);
                if (this.SINK_OUTPUT) {
                    this.connection.parseAndEval("sink(type='output')");
                    try {
                        this.lastOuput = this.connection.parseAndEval("paste(collapse='\n',readLines('" + this.SINK_FILE + "'))").asString();
                        this.log(this.lastOuput, Logger.Level.OUTPUT);
                    }
                    catch (Exception ex) {
                        this.lastOuput = ex.getMessage();
                        this.log(this.lastOuput, Logger.Level.WARNING);
                    }
                    this.connection.parseAndEval("unlink('" + this.SINK_FILE + "')");
                }
            }
        }
        catch (Exception ex) {
            this.log(HEAD_EXCEPTION + ex.getMessage() + "\n  " + expression, Logger.Level.ERROR);
        }
        if (tryEval && e != null) {
            try {
                if (e.inherits("try-error")) {
                    this.log(HEAD_EXCEPTION + e.asString() + "\n  " + expression, Logger.Level.WARNING);
                    return false;
                }
            }
            catch (REXPMismatchException ex) {
                this.log(HEAD_ERROR + ex.getMessage() + "\n  " + expression, Logger.Level.ERROR);
                return false;
            }
        }
        return true;
    }

    public boolean voidEval(String expression, boolean tryEval) {
        this.log(HEAD_EVAL + (tryEval ? HEAD_TRY : " ") + expression, Logger.Level.INFO);
        boolean done = this.silentlyVoidEval(expression, tryEval);
        if (done) {
            for (UpdateObjectsListener b : this.updateObjects) {
                b.update();
            }
        }
        return done;
    }

    public boolean voidEval(String expression) {
        return this.voidEval(expression, this.TRY_MODE_DEFAULT);
    }

    public REXP silentlyEval(String expression) {
        return this.silentlyEval(expression, this.TRY_MODE_DEFAULT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public REXP silentlyEval(String expression, boolean tryEval) {
        assert (this.connected) : "R environment not initialized.";
        if (expression == null) {
            return null;
        }
        if (expression.trim().length() == 0) {
            return null;
        }
        for (EvalListener b : this.eval) {
            b.eval(expression);
        }
        REXP e = null;
        try {
            EvalListener b;
            b = this.connection;
            synchronized (b) {
                if (this.SINK_OUTPUT) {
                    this.connection.parseAndEval("sink('" + this.SINK_FILE + "',type='output')");
                }
                e = tryEval ? this.connection.parseAndEval("try(eval(parse(text='" + expression.replace("'", "\\'") + "')),silent=FALSE)") : this.connection.parseAndEval(expression);
                if (this.SINK_OUTPUT) {
                    this.connection.parseAndEval("sink(type='output')");
                    try {
                        this.lastOuput = this.connection.parseAndEval("paste(collapse='\n',readLines('" + this.SINK_FILE + "'))").asString();
                        this.log(this.lastOuput, Logger.Level.OUTPUT);
                    }
                    catch (Exception ex) {
                        this.lastOuput = ex.getMessage();
                        this.log(this.lastOuput, Logger.Level.WARNING);
                    }
                    this.connection.parseAndEval("unlink('" + this.SINK_FILE + "')");
                }
            }
        }
        catch (Exception ex) {
            this.log(HEAD_EXCEPTION + ex.getMessage() + "\n  " + expression, Logger.Level.ERROR);
        }
        if (tryEval && e != null) {
            try {
                if (e.inherits("try-error")) {
                    this.log(HEAD_EXCEPTION + e.asString() + "\n  " + expression, Logger.Level.WARNING);
                    e = null;
                }
            }
            catch (REXPMismatchException ex) {
                this.log(HEAD_ERROR + ex.getMessage() + "\n  " + expression, Logger.Level.ERROR);
                return null;
            }
        }
        return e;
    }

    public REXP eval(String expression, boolean tryEval) {
        this.log(HEAD_EVAL + (tryEval ? HEAD_TRY : HEAD_TRY) + expression, Logger.Level.INFO);
        REXP e = this.silentlyEval(expression, tryEval);
        for (UpdateObjectsListener b : this.updateObjects) {
            b.update();
        }
        if (e != null) {
            this.log(__ + e.toDebugString(), Logger.Level.INFO);
        }
        return e;
    }

    public REXP eval(String expression) {
        return this.eval(expression, this.TRY_MODE_DEFAULT);
    }

    public String getRServeOS() {
        try {
            return this.eval("Sys.info()['sysname']", this.TRY_MODE).asString();
        }
        catch (REXPMismatchException re) {
            return "unknown";
        }
    }

    public boolean RServeOSisWindows() {
        return this.getRServeOS().startsWith("Windows");
    }

    public boolean RServeOSisLinux() {
        return this.getRServeOS().startsWith("Linux");
    }

    public boolean RServeOSisMacOSX() {
        return this.getRServeOS().startsWith("Darwin");
    }

    public boolean RServeOSisUnknown() {
        return !this.RServeOSisWindows() && !this.RServeOSisLinux() && !this.RServeOSisMacOSX();
    }

    public boolean rmAll() {
        return this.voidEval("rm(list=ls(all=TRUE))", this.TRY_MODE);
    }

    public static String buildList(String ... vars) {
        if (vars.length > 1) {
            StringBuffer b = new StringBuffer("c(");
            for (String v : vars) {
                b.append(v + ",");
            }
            return b.substring(0, b.length() - 1) + ")";
        }
        return vars[0];
    }

    public static String buildListString(String ... vars) {
        if (vars.length > 1) {
            StringBuffer b = new StringBuffer("c(");
            for (String v : vars) {
                b.append("'" + v + "',");
            }
            return b.substring(0, b.length() - 1) + ")";
        }
        return "'" + vars[0] + "'";
    }

    public static String buildListPattern(String ... vars) {
        if (vars.length > 1) {
            StringBuffer b = new StringBuffer("c(");
            for (String v : vars) {
                b.append("ls(pattern='" + v + "'),");
            }
            return b.substring(0, b.length() - 1) + ")";
        }
        return "ls(pattern='" + vars[0] + "')";
    }

    public void source(File f) {
        this.sendFile(f);
        this.voidEval("source('" + f.getName() + "')", this.TRY_MODE);
    }

    public void load(File f) {
        this.sendFile(f);
        try {
            assert (this.eval("file.exists('" + f.getName() + "')", this.TRY_MODE).asInteger() == 1);
        }
        catch (REXPMismatchException r) {
            r.printStackTrace();
        }
        this.voidEval("load('" + f.getName() + "')", this.TRY_MODE);
    }

    public String[] ls() {
        try {
            return this.eval("ls()", this.TRY_MODE).asStrings();
        }
        catch (REXPMismatchException re) {
            return new String[0];
        }
        catch (Exception re) {
            return new String[]{"?"};
        }
    }

    public String[] ls(String ... vars) {
        if (vars == null || vars.length == 0) {
            try {
                return this.eval("ls()", this.TRY_MODE).asStrings();
            }
            catch (REXPMismatchException re) {
                return new String[0];
            }
            catch (Exception re) {
                return new String[]{"?"};
            }
        }
        if (vars.length == 1) {
            try {
                return this.eval(Rsession.buildListPattern(vars[0]), this.TRY_MODE).asStrings();
            }
            catch (REXPMismatchException re) {
                return new String[0];
            }
            catch (Exception re) {
                return new String[]{"?"};
            }
        }
        try {
            return this.eval(Rsession.buildListPattern(vars), this.TRY_MODE).asStrings();
        }
        catch (REXPMismatchException re) {
            return new String[0];
        }
        catch (Exception re) {
            return new String[]{"?"};
        }
    }

    public boolean rm(String ... vars) {
        if (vars.length == 1) {
            return this.voidEval("rm(" + vars[0] + ")", this.TRY_MODE);
        }
        return this.voidEval("rm(list=" + Rsession.buildListString(vars) + ")", this.TRY_MODE);
    }

    public boolean rmls(String ... vars) {
        if (vars.length == 1) {
            return this.voidEval("rm(list=" + Rsession.buildListPattern(vars[0]) + ")", this.TRY_MODE);
        }
        return this.voidEval("rm(list=" + Rsession.buildListPattern(vars) + ")", this.TRY_MODE);
    }

    public void save(File f, String ... vars) {
        if (vars.length == 1) {
            this.voidEval("save(file='" + f.getName() + "'," + vars[0] + ",ascii=" + (this.SAVE_ASCII ? "TRUE" : "FALSE") + ")", this.TRY_MODE);
        } else {
            this.voidEval("save(file='" + f.getName() + "',list=" + Rsession.buildListString(vars) + ",ascii=" + (this.SAVE_ASCII ? "TRUE" : "FALSE") + ")", this.TRY_MODE);
        }
        this.receiveFile(f);
        this.removeFile(f.getName());
    }

    public void savels(File f, String ... vars) {
        if (vars.length == 1) {
            this.voidEval("save(file='" + f.getName() + "',list=" + Rsession.buildListPattern(vars[0]) + ",ascii=" + (this.SAVE_ASCII ? "TRUE" : "FALSE") + ")", this.TRY_MODE);
        } else {
            this.voidEval("save(file='" + f.getName() + "',list=" + Rsession.buildListPattern(vars) + ",ascii=" + (this.SAVE_ASCII ? "TRUE" : "FALSE") + ")", this.TRY_MODE);
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.receiveFile(f);
        this.removeFile(f.getName());
    }

    public String typeOf(String robject) {
        if (robject == null) {
            return "NULL";
        }
        for (String t : types) {
            REXP is = this.silentlyEval("is." + t + "(" + robject + ")");
            try {
                if (is == null || is.asInteger() != 1) continue;
                return t;
            }
            catch (REXPMismatchException ex) {
                this.log("[error] [typeOf] " + robject + " type unknown.", Logger.Level.ERROR);
                return null;
            }
        }
        return "unknown";
    }

    public static RList buildRList(double[][] data, String ... names) {
        assert (data[0].length == names.length) : "Cannot build R list from " + Arrays.deepToString((Object[])data) + " & " + Arrays.toString(names);
        REXP[] vals = new REXP[names.length];
        for (int i = 0; i < names.length; ++i) {
            double[] coli = new double[data.length];
            for (int j = 0; j < coli.length; ++j) {
                coli[j] = data[j].length > i ? data[j][i] : Double.NaN;
            }
            vals[i] = new REXPDouble(coli);
        }
        return new RList(vals, names);
    }

    public static RList buildRList(List<double[]> coldata, String ... names) {
        assert (coldata.size() == names.length);
        RList list = new RList(coldata.size(), true);
        for (int i = 0; i < names.length; ++i) {
            list.put((Object)names[i], (Object)new REXPDouble(coldata.get(i)));
        }
        return list;
    }

    public boolean unset(String ... varname) {
        return this.rm(varname);
    }

    public boolean unset(Collection varname) {
        boolean done = true;
        for (Object v : varname) {
            done &= this.rm(v.toString());
        }
        return done;
    }

    public boolean set(Map<String, Object> _vars) {
        boolean done = true;
        for (String varname : _vars.keySet()) {
            done &= this.set(varname, _vars.get(varname));
        }
        return done;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean set(String varname, double[][] data, String ... names) {
        RList list = Rsession.buildRList(data, names);
        this.log(HEAD_SET + varname + " <- " + Rsession.toString(list), Logger.Level.INFO);
        try {
            RConnection rConnection = this.connection;
            synchronized (rConnection) {
                this.connection.assign(varname, REXP.createDataFrame((RList)list));
            }
        }
        catch (REXPMismatchException re) {
            this.log("[error]  RList " + list.toString() + " not convertible as dataframe.", Logger.Level.ERROR);
            return false;
        }
        catch (RserveException ex) {
            this.log(HEAD_EXCEPTION + ex.getMessage() + "\n  set(String varname=" + varname + ",double[][] data, String... names)", Logger.Level.ERROR);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean set(String varname, Object var) {
        block53: {
            if (!this.connected) {
                this.log("[exception] R environment not initialized. Please make sure that R.init() method was called first.", Logger.Level.ERROR);
                return false;
            }
            this.log(HEAD_SET + varname + " <- " + var, Logger.Level.INFO);
            if (var == null) {
                this.rm(varname);
                return true;
            }
            if (var instanceof RList) {
                RList l = (RList)var;
                try {
                    RConnection rConnection = this.connection;
                    synchronized (rConnection) {
                        this.connection.assign(varname, (REXP)new REXPList(l));
                        break block53;
                    }
                }
                catch (RserveException ex) {
                    this.log(HEAD_EXCEPTION + ex.getMessage() + "\n  set(String varname=" + varname + ",Object (RList) var)", Logger.Level.ERROR);
                    return false;
                }
            }
            if (var instanceof File) {
                this.sendFile((File)var);
                return this.silentlyVoidEval(varname + "<-'" + ((File)var).getName() + "'");
            }
            if (var instanceof Integer) {
                return this.silentlyVoidEval(varname + "<-" + (Integer)var);
            }
            if (var instanceof Double) {
                return this.silentlyVoidEval(varname + "<-" + (Double)var);
            }
            if (var instanceof Double[]) {
                Double[] varD = (Double[])var;
                double[] vard = new double[varD.length];
                System.arraycopy(varD, 0, vard, 0, varD.length);
                try {
                    RConnection rConnection = this.connection;
                    synchronized (rConnection) {
                        this.connection.assign(varname, vard);
                    }
                }
                catch (REngineException ex) {
                    this.log(HEAD_ERROR + ex.getMessage() + "\n  set(String varname=" + varname + ",Object (Double[]) var)", Logger.Level.ERROR);
                    return false;
                }
                return this.silentlyVoidEval(varname);
            }
            if (var instanceof double[]) {
                try {
                    RConnection varD = this.connection;
                    synchronized (varD) {
                        this.connection.assign(varname, (double[])var);
                    }
                }
                catch (REngineException ex) {
                    this.log(HEAD_ERROR + ex.getMessage() + "\n  set(String varname=" + varname + ",Object (double[]) var)", Logger.Level.ERROR);
                    return false;
                }
                return this.silentlyVoidEval(varname);
            }
            if (var instanceof Double[][]) {
                Double[][] array = (Double[][])var;
                int rows = array.length;
                int col = array[0].length;
                try {
                    RConnection rConnection = this.connection;
                    synchronized (rConnection) {
                        this.connection.assign("row_" + varname, Rsession.reshapeAsRow(array));
                    }
                }
                catch (REngineException ex) {
                    this.log(HEAD_ERROR + ex.getMessage() + "\n  set(String varname=" + varname + ",Object (double[][]) var)", Logger.Level.ERROR);
                    return false;
                }
                boolean done = this.silentlyVoidEval(varname + "<-array(row_" + varname + ",c(" + rows + "," + col + "))");
                return done && this.silentlyVoidEval("rm(row_" + varname + ")");
            }
            if (var instanceof double[][]) {
                double[][] array = (double[][])var;
                int rows = array.length;
                int col = array[0].length;
                try {
                    RConnection done = this.connection;
                    synchronized (done) {
                        this.connection.assign("row_" + varname, Rsession.reshapeAsRow(array));
                    }
                }
                catch (REngineException ex) {
                    this.log(HEAD_ERROR + ex.getMessage() + "\n  set(String varname=" + varname + ",Object (double[][]) var)", Logger.Level.ERROR);
                    return false;
                }
                boolean done = this.silentlyVoidEval(varname + "<-array(row_" + varname + ",c(" + rows + "," + col + "))");
                return done && this.silentlyVoidEval("rm(row_" + varname + ")");
            }
            if (var instanceof String) {
                try {
                    RConnection array = this.connection;
                    synchronized (array) {
                        this.connection.assign(varname, (String)var);
                    }
                }
                catch (RserveException ex) {
                    this.log(HEAD_EXCEPTION + ex.getMessage() + "\n  set(String varname=" + varname + ",Object (String) var)", Logger.Level.ERROR);
                    return false;
                }
                return this.silentlyVoidEval(varname);
            }
            if (var instanceof String[]) {
                try {
                    RConnection ex = this.connection;
                    synchronized (ex) {
                        this.connection.assign(varname, (String[])var);
                    }
                }
                catch (REngineException ex) {
                    this.log(HEAD_ERROR + ex.getMessage() + "\n  set(String varname=" + varname + ",Object (String[]) var)", Logger.Level.ERROR);
                    return false;
                }
                return this.silentlyVoidEval(varname);
            }
            if (var instanceof Map) {
                try {
                    RConnection ex = this.connection;
                    synchronized (ex) {
                        this.connection.assign(varname, (REXP)Rsession.asRList((Map)var));
                    }
                }
                catch (Exception ex) {
                    this.log(HEAD_ERROR + ex.getMessage() + "\n  set(String varname=" + varname + ",Object (Map) var)", Logger.Level.ERROR);
                    return false;
                }
                return this.silentlyVoidEval(varname);
            }
            throw new IllegalArgumentException("Variable " + varname + " is not double, double[],  double[][], String or String[]. R engine can not handle.");
        }
        return true;
    }

    public static REXPList asRList(Map m) {
        RList l = new RList();
        for (Object o : m.keySet()) {
            Object v = m.get(o);
            if (v instanceof Double) {
                l.put((Object)o.toString(), (Object)new REXPDouble(((Double)v).doubleValue()));
                continue;
            }
            if (v instanceof double[]) {
                l.put((Object)o.toString(), (Object)new REXPDouble((double[])v));
                continue;
            }
            if (v instanceof Integer) {
                l.put((Object)o.toString(), (Object)new REXPInteger(((Integer)v).intValue()));
                continue;
            }
            if (v instanceof int[]) {
                l.put((Object)o.toString(), (Object)new REXPInteger((int[])v));
                continue;
            }
            if (v instanceof String) {
                l.put((Object)o.toString(), (Object)new REXPString((String)v));
                continue;
            }
            if (v instanceof String[]) {
                l.put((Object)o.toString(), (Object)new REXPString((String[])v));
                continue;
            }
            if (v instanceof Boolean) {
                l.put((Object)o.toString(), (Object)new REXPLogical(((Boolean)v).booleanValue()));
                continue;
            }
            if (v instanceof boolean[]) {
                l.put((Object)o.toString(), (Object)new REXPLogical((boolean[])v));
                continue;
            }
            if (v instanceof Map) {
                l.put((Object)o.toString(), (Object)Rsession.asRList((Map)v));
                continue;
            }
            if (v instanceof RList) {
                l.put((Object)o.toString(), (Object)((RList)v));
                continue;
            }
            if (v == null) {
                l.put((Object)o.toString(), (Object)new REXPNull());
                continue;
            }
            System.err.println("Could not cast object " + o + " : " + v);
        }
        return new REXPList(l);
    }

    private static double[] reshapeAsRow(double[][] a) {
        double[] reshaped = new double[a.length * a[0].length];
        int ir = 0;
        for (int j = 0; j < a[0].length; ++j) {
            for (int i = 0; i < a.length; ++i) {
                reshaped[ir] = a[i][j];
                ++ir;
            }
        }
        return reshaped;
    }

    private static double[] reshapeAsRow(Double[][] a) {
        double[] reshaped = new double[a.length * a[0].length];
        int ir = 0;
        for (int j = 0; j < a[0].length; ++j) {
            for (int i = 0; i < a.length; ++i) {
                reshaped[ir] = a[i][j];
                ++ir;
            }
        }
        return reshaped;
    }

    public static Object cast(REXP eval) throws REXPMismatchException {
        if (eval == null) {
            return null;
        }
        if (eval.isNumeric()) {
            if (eval.dim() == null || eval.dim().length == 1) {
                double[] array = eval.asDoubles();
                if (array.length == 0) {
                    return null;
                }
                if (array.length == 1) {
                    return array[0];
                }
                return array;
            }
            double[][] mat = eval.asDoubleMatrix();
            if (mat.length == 0) {
                return null;
            }
            if (mat.length == 1) {
                if (mat[0].length == 0) {
                    return null;
                }
                if (mat[0].length == 1) {
                    return mat[0][0];
                }
                return mat[0];
            }
            if (mat[0].length == 0) {
                return null;
            }
            if (mat[0].length == 1) {
                double[] dmat = new double[mat.length];
                for (int i = 0; i < dmat.length; ++i) {
                    dmat[i] = mat[i][0];
                }
                return dmat;
            }
            return mat;
        }
        if (eval.isString()) {
            String[] s = eval.asStrings();
            if (s.length == 1) {
                return s[0];
            }
            return s;
        }
        if (eval.isLogical()) {
            return eval.asInteger() == 1;
        }
        if (eval.isList()) {
            return eval.asList();
        }
        if (eval.isNull()) {
            return null;
        }
        System.err.println("Unsupported type: " + eval.toDebugString());
        return eval.toString();
    }

    public static String castToString(REXP eval) {
        if (eval == null) {
            return HEAD_TRY;
        }
        return eval.toString();
    }

    public void toGraphic(File f, int width, int height, String fileformat, String ... commands) {
        int h = Math.abs(f.hashCode());
        this.set("plotfile_" + h, f.getName());
        this.silentlyEval(fileformat + "(plotfile_" + h + ", width=" + width + ", height=" + height + ")");
        for (String command : commands) {
            this.silentlyVoidEval(command);
        }
        this.silentlyEval("dev.off()");
        this.receiveFile(f);
        this.rm("plotfile_" + h);
        this.removeFile(f.getName());
    }

    public void toGraphic(File f, int width, int height, String ... commands) {
        if (f.getName().endsWith(GRAPHIC_BMP)) {
            this.toBMP(f, width, height, commands);
        } else if (f.getName().endsWith(GRAPHIC_JPEG)) {
            this.toJPEG(f, width, height, commands);
        } else if (f.getName().endsWith(GRAPHIC_PNG)) {
            this.toPNG(f, width, height, commands);
        } else if (f.getName().endsWith(GRAPHIC_TIFF)) {
            this.toTIFF(f, width, height, commands);
        } else {
            this.toPNG(f, width, height, commands);
        }
    }

    public void toJPEG(File f, int width, int height, String ... commands) {
        this.toGraphic(f, width, height, GRAPHIC_JPEG, commands);
    }

    public void toPNG(File f, int width, int height, String ... commands) {
        if (this.RServeOSisMacOSX()) {
            this.toGraphic(f, width, height, GRAPHIC_JPEG, commands);
        } else {
            this.toGraphic(f, width, height, GRAPHIC_PNG, commands);
        }
    }

    public void toBMP(File f, int width, int height, String ... commands) {
        this.toGraphic(f, width, height, GRAPHIC_BMP, commands);
    }

    public void toTIFF(File f, int width, int height, String ... commands) {
        this.toGraphic(f, width, height, GRAPHIC_TIFF, commands);
    }

    public String asR2HTML(String command) {
        String ret = this.installPackage("R2HTML", true);
        if (!ret.equals(PACKAGEINSTALLED)) {
            return ret;
        }
        int h = Math.abs(command.hashCode());
        this.silentlyEval("HTML(file=\"htmlfile_" + h + "\", " + command + ")");
        String[] lines = null;
        try {
            lines = this.silentlyEval("readLines(\"htmlfile_" + h + "\")").asStrings();
        }
        catch (REXPMismatchException e) {
            return e.getMessage();
        }
        this.removeFile("htmlfile_" + h);
        if (lines == null) {
            return HEAD_TRY;
        }
        StringBuffer sb = new StringBuffer();
        for (String l : lines) {
            sb.append(l);
            sb.append("\n");
        }
        String str = sb.toString();
        str = str.replace("align= center ", "align='center'");
        str = str.replace("cellspacing=0", "cellspacing='0'");
        str = str.replace("border=1", "border='1'");
        str = str.replace("align=bottom", "align='bottom'");
        str = str.replace("class=dataframe", "class='dataframe'");
        str = str.replace("class= firstline ", "class='firstline'");
        str = str.replace("class=firstcolumn", "class='firstcolumn'");
        str = str.replace("class=cellinside", "class='cellinside'");
        str = str.replace("border=0", "border='0'");
        str = str.replace("class=captiondataframe", "class='captiondataframe'");
        str = str.replace("</td></table>", "</td></tr></table>");
        return str;
    }

    public String asHTML(String command) {
        return Rsession.toHTML(this.asString(command));
    }

    public static String toHTML(String src) {
        if (src == null) {
            return src;
        }
        src = src.replace("&", "&amp;");
        src = src.replace("\"", "&quot;");
        src = src.replace("'", "&apos;");
        src = src.replace("<", "&lt;");
        src = src.replace(">", "&gt;");
        return "<html>" + src.replace("\n", "<br/>") + "</html>";
    }

    public String asString(String command) {
        try {
            String s = this.silentlyEval("paste(capture.output(print(" + command + ")),collapse='\\n')").asString();
            return s;
        }
        catch (REXPMismatchException ex) {
            return ex.getMessage();
        }
    }

    public void receiveFile(File localfile) {
        this.receiveFile(localfile, localfile.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveFile(File localfile, String remoteFile) {
        try {
            if (this.silentlyEval("file.exists('" + remoteFile + "')", this.TRY_MODE).asInteger() != 1) {
                this.log("[error] [IO] file " + remoteFile + " not found.", Logger.Level.ERROR);
            }
        }
        catch (Exception ex) {
            this.log(HEAD_ERROR + ex.getMessage() + "\n  getFile(File localfile=" + localfile.getAbsolutePath() + ", String remoteFile=" + remoteFile + ")", Logger.Level.ERROR);
            return;
        }
        if (localfile.exists()) {
            localfile.delete();
            if (!localfile.exists()) {
                this.log("[IO] Local file " + localfile.getAbsolutePath() + " deleted.", Logger.Level.INFO);
            } else {
                this.log("[error] [IO] file " + localfile + " still exists !", Logger.Level.ERROR);
                return;
            }
        }
        RFileInputStream is = null;
        BufferedOutputStream os = null;
        RConnection rConnection = this.connection;
        synchronized (rConnection) {
            try {
                is = this.connection.openFile(remoteFile);
                os = new BufferedOutputStream(new FileOutputStream(localfile));
                IOUtils.copy((InputStream)is, (OutputStream)os);
                this.log("[IO] File " + remoteFile + " received.", Logger.Level.INFO);
                is.close();
                ((OutputStream)os).close();
            }
            catch (IOException e) {
                try {
                    this.log("[error] [IO] " + this.connection.getLastError() + ": file " + remoteFile + " not transmitted.\n" + e.getMessage(), Logger.Level.ERROR);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(is);
                    IOUtils.closeQuietly(os);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)is);
                IOUtils.closeQuietly((OutputStream)os);
            }
            IOUtils.closeQuietly((InputStream)is);
            IOUtils.closeQuietly((OutputStream)os);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFile(String remoteFile) {
        try {
            RConnection rConnection = this.connection;
            synchronized (rConnection) {
                this.connection.removeFile(remoteFile);
            }
        }
        catch (RserveException ex) {
            this.log(HEAD_EXCEPTION + ex.getMessage() + "\n  removeFile(String remoteFile=" + remoteFile + ")", Logger.Level.ERROR);
        }
    }

    public void sendFile(File localfile) {
        this.sendFile(localfile, localfile.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendFile(File localfile, String remoteFile) {
        if (!localfile.exists()) {
            RConnection rConnection = this.connection;
            synchronized (rConnection) {
                this.log("[error] [IO] " + this.connection.getLastError() + "\n  file " + localfile.getAbsolutePath() + " does not exists.", Logger.Level.ERROR);
            }
        }
        try {
            if (this.silentlyEval("file.exists('" + remoteFile + "')", this.TRY_MODE).asInteger() == 1) {
                this.silentlyVoidEval("file.remove('" + remoteFile + "')", this.TRY_MODE);
                this.log("[IO] Remote file " + remoteFile + " deleted.", Logger.Level.INFO);
            }
        }
        catch (REXPMismatchException ex) {
            this.log(HEAD_ERROR + ex.getMessage() + "\n  putFile(File localfile=" + localfile.getAbsolutePath() + ", String remoteFile=" + remoteFile + ")", Logger.Level.ERROR);
            return;
        }
        BufferedInputStream is = null;
        RFileOutputStream os = null;
        RConnection rConnection = this.connection;
        synchronized (rConnection) {
            try {
                os = this.connection.createFile(remoteFile);
                is = new BufferedInputStream(new FileInputStream(localfile));
                IOUtils.copy((InputStream)is, (OutputStream)os);
                this.log("[IO] File " + remoteFile + " sent.", Logger.Level.INFO);
                ((InputStream)is).close();
                os.close();
            }
            catch (IOException e) {
                try {
                    this.log("[error] [IO] " + this.connection.getLastError() + ": file " + remoteFile + " not writable.\n" + e.getMessage(), Logger.Level.ERROR);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(is);
                    IOUtils.closeQuietly((OutputStream)os);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)is);
                IOUtils.closeQuietly((OutputStream)os);
            }
            IOUtils.closeQuietly((InputStream)is);
            IOUtils.closeQuietly((OutputStream)os);
        }
    }

    public synchronized Object proxyEval(String expression, Map<String, Object> vars) throws Exception {
        if (expression.length() == 0) {
            return null;
        }
        try {
            this.log("[cache] No evaluation needed for " + expression, Logger.Level.INFO);
            return Double.parseDouble(expression);
        }
        catch (NumberFormatException ne) {
            if (!Rsession.uses(expression, vars) && this.noVarsEvals.containsKey(expression)) {
                this.log("[cache] Cached evaluation of " + expression + " in " + this.noVarsEvals, Logger.Level.INFO);
                return this.noVarsEvals.get(expression);
            }
            if (vars != null && vars.containsKey(expression)) {
                this.log("[cache] Get evaluation of " + expression + " in " + vars, Logger.Level.INFO);
                return vars.get(expression);
            }
            HashMap<String, Object> clean_vars = new HashMap<String, Object>();
            String clean_expression = expression;
            if (vars != null) {
                for (String v : vars.keySet()) {
                    if (vars.get(v) instanceof Number) {
                        while (Rsession.containsVar(clean_expression, v)) {
                            clean_expression = Rsession.replaceVar(clean_expression, v, "(" + vars.get(v) + ")");
                        }
                        this.log("[cache] Replacing " + v + " in " + clean_expression, Logger.Level.INFO);
                        continue;
                    }
                    if (!Rsession.containsVar(clean_expression, v)) continue;
                    String newvarname = v;
                    while (this.ls(newvarname).length > 0) {
                        newvarname = "_" + newvarname;
                    }
                    this.log("[cache] Renaming " + v + " by " + newvarname + " in " + clean_expression, Logger.Level.INFO);
                    while (Rsession.containsVar(clean_expression, v)) {
                        clean_expression = Rsession.replaceVar(clean_expression, v, newvarname);
                    }
                    clean_vars.put(newvarname, vars.get(v));
                }
            }
            if (!Rsession.uses(clean_expression, clean_vars) && this.noVarsEvals.containsKey(clean_expression)) {
                this.log("[cache] Cached evaluation of " + expression + " in " + this.noVarsEvals, Logger.Level.INFO);
                return this.noVarsEvals.get(clean_expression);
            }
            Object out = null;
            try {
                if (Rsession.uses(clean_expression, clean_vars)) {
                    this.set(clean_vars);
                }
                this.log("[cache] True evaluation of " + clean_expression + " with " + clean_vars, Logger.Level.INFO);
                REXP exp = this.eval(clean_expression);
                out = Rsession.cast(exp);
                if (clean_vars.isEmpty() && out != null) {
                    this.log("[cache] Saving result of " + clean_expression, Logger.Level.INFO);
                    this.noVarsEvals.put(clean_expression, out);
                }
                if (!Rsession.uses(expression, vars) && out != null) {
                    this.log("[cache] Saving result of " + expression, Logger.Level.INFO);
                    this.noVarsEvals.put(expression, out);
                }
            }
            catch (Exception e) {
                this.log("[cache] Failed cast of " + expression, Logger.Level.INFO);
                throw new Exception(CAST_ERROR + expression + ": " + e.getMessage());
            }
            finally {
                if (Rsession.uses(clean_expression, clean_vars)) {
                    this.unset(clean_vars.keySet());
                }
            }
            if (out == null) {
                boolean restartR = false;
                try {
                    REXP testEval = this.eval(testExpression);
                    double testOut = (Double)Rsession.cast(testEval);
                    if (testOut == Double.NaN || Math.abs(testOut - 4.141592653589793) > 0.1) {
                        restartR = true;
                    }
                }
                catch (Exception e) {
                    restartR = true;
                }
                if (restartR) {
                    System.err.println("Problem occured, R engine restarted.");
                    this.log("[cache] Problem occured, R engine restarted.", Logger.Level.INFO);
                    this.end();
                    this.startup();
                    return this.proxyEval(expression, vars);
                }
            }
            return out;
        }
    }

    static String replaceVar(String expr, String var, String val) {
        String regexp = AW + var + Az;
        Matcher m = Pattern.compile(regexp).matcher(expr);
        if (m.find()) {
            return expr.replace(m.group(), m.group().replace(var, val));
        }
        return expr;
    }

    static boolean containsVar(String expr, String var) {
        String regexp = AW + var + Az;
        Matcher m = Pattern.compile(regexp).matcher(expr);
        return m.find();
    }

    static boolean areUsed(String expression, Set<String> vars) {
        for (String v : vars) {
            if (!Rsession.containsVar(expression, v)) continue;
            return true;
        }
        return false;
    }

    static boolean uses(String expression, Map<String, Object> vars) {
        return vars != null && !vars.isEmpty() && Rsession.areUsed(expression, vars.keySet());
    }

    public static void main(String[] args) throws Exception {
        if (args == null || args.length == 0) {
            args = new String[10];
            for (int i = 0; i < args.length; ++i) {
                args[i] = Math.random() + "+pi";
            }
        }
        Rsession R = null;
        int i = 0;
        Slf4jLogger l = new Slf4jLogger();
        if (args[0].startsWith("R://")) {
            ++i;
            R = Rsession.newInstanceTry(l, RserverConf.parse(args[0]));
        } else {
            R = Rsession.newInstanceTry(l, null);
        }
        for (int j = i; j < args.length; ++j) {
            System.err.print(args[j] + ": ");
            System.err.println(Rsession.castToString(R.eval(args[j])));
        }
        R.end();
    }
}

