/*
 * Decompiled with CFR 0.152.
 */
package org.math.R;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import org.math.R.Logger;
import org.math.R.Rsession;

public class RLogPanel
extends JPanel
implements Logger {
    private static int _fontSize = 12;
    private static Font _smallFont = new Font("Arial", 0, _fontSize - 2);
    public int maxsize = Integer.parseInt(System.getProperty("RLogPanel.maxsize", "100000"));
    public int minsize = Integer.parseInt(System.getProperty("RLogPanel.minsize", "10000"));
    public String filter = null;
    private OutputStream output_stream;
    private OutputStream info_stream;
    private OutputStream error_stream;
    private OutputStream warn_stream;
    char level = (char)105;
    char[] buffer = new char[this.maxsize];
    volatile int pos = 0;
    private PrintStream output_pstream;
    private PrintStream info_pstream;
    private PrintStream warn_pstream;
    private PrintStream error_pstream;
    private JToolBar _bar;
    public JButton _del;
    public JButton _save;
    public JButton _update;
    private JScrollPane jScrollPane1;
    private JTextPane jTextPane1;

    public static void main(String[] args) {
        RLogPanel log = new RLogPanel();
        JFrame f = new JFrame();
        f.setContentPane(log);
        f.setVisible(true);
        f.pack();
        Rsession R = Rsession.newInstanceTry(log, null);
        R.eval("ls()");
    }

    @Override
    public synchronized void println(String message, Logger.Level l) {
        if (this.filter == null || message.matches(this.filter)) {
            try {
                if (l == Logger.Level.OUTPUT) {
                    this.getOutputPrintStream().println(message);
                } else if (l == Logger.Level.INFO) {
                    this.getInfoPrintStream().println(message);
                } else if (l == Logger.Level.WARNING) {
                    this.getWarnPrintStream().println(message);
                } else if (l == Logger.Level.ERROR) {
                    this.getErrorPrintStream().println(message);
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
    }

    public RLogPanel() {
        this.initComponents();
        StyleConstants.setForeground(this.jTextPane1.addStyle("OUTPUT", null), Color.gray);
        StyleConstants.setForeground(this.jTextPane1.addStyle("INFO", null), Color.black);
        StyleConstants.setForeground(this.jTextPane1.addStyle("WARN", null), Color.blue);
        StyleConstants.setForeground(this.jTextPane1.addStyle("ERROR", null), Color.red);
        this.jTextPane1.setEditable(false);
        this.jTextPane1.setFont(_smallFont);
    }

    @Override
    public void close() {
        if (this.output_stream != null) {
            try {
                this.output_stream.close();
            }
            catch (IOException ex) {
                ex.printStackTrace(System.err);
            }
        }
        if (this.info_stream != null) {
            try {
                this.info_stream.close();
            }
            catch (IOException ex) {
                ex.printStackTrace(System.err);
            }
        }
        if (this.error_stream != null) {
            try {
                this.error_stream.close();
            }
            catch (IOException ex) {
                ex.printStackTrace(System.err);
            }
        }
        if (this.warn_stream != null) {
            try {
                this.warn_stream.close();
            }
            catch (IOException ex) {
                ex.printStackTrace(System.err);
            }
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    OutputStream getInfoStream() {
        if (this.info_stream == null) {
            this.info_stream = new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                    if (RLogPanel.this.level != 'i') {
                        RLogPanel.this.level = (char)105;
                        this.write(105);
                        this.write(32);
                        this.write(b);
                        return;
                    }
                    if (RLogPanel.this.pos >= RLogPanel.this.maxsize) {
                        for (int i = 0; i < RLogPanel.this.minsize; ++i) {
                            RLogPanel.this.buffer[i] = RLogPanel.this.buffer[RLogPanel.this.maxsize - RLogPanel.this.minsize + i];
                        }
                        RLogPanel.this.pos = RLogPanel.this.minsize;
                    }
                    RLogPanel.this.buffer[RLogPanel.this.pos] = (char)b;
                    ++RLogPanel.this.pos;
                }
            };
        }
        return this.info_stream;
    }

    OutputStream getOutputStream() {
        if (this.output_stream == null) {
            this.output_stream = new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                    if (RLogPanel.this.level != 'o') {
                        RLogPanel.this.level = (char)111;
                        this.write(111);
                        this.write(32);
                        this.write(b);
                        return;
                    }
                    if (RLogPanel.this.pos >= RLogPanel.this.maxsize) {
                        for (int i = 0; i < RLogPanel.this.minsize; ++i) {
                            RLogPanel.this.buffer[i] = RLogPanel.this.buffer[RLogPanel.this.maxsize - RLogPanel.this.minsize + i];
                        }
                        RLogPanel.this.pos = RLogPanel.this.minsize;
                    }
                    RLogPanel.this.buffer[RLogPanel.this.pos] = (char)b;
                    ++RLogPanel.this.pos;
                }
            };
        }
        return this.output_stream;
    }

    OutputStream getWarnStream() {
        if (this.warn_stream == null) {
            this.warn_stream = new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                    if (RLogPanel.this.level != 'w') {
                        RLogPanel.this.level = (char)119;
                        this.write(119);
                        this.write(32);
                        this.write(b);
                        return;
                    }
                    if (RLogPanel.this.pos >= RLogPanel.this.maxsize) {
                        for (int i = 0; i < RLogPanel.this.minsize; ++i) {
                            RLogPanel.this.buffer[i] = RLogPanel.this.buffer[RLogPanel.this.maxsize - RLogPanel.this.minsize + i];
                        }
                        RLogPanel.this.pos = RLogPanel.this.minsize;
                    }
                    RLogPanel.this.buffer[RLogPanel.this.pos] = (char)b;
                    ++RLogPanel.this.pos;
                }
            };
        }
        return this.warn_stream;
    }

    OutputStream getErrorStream() {
        if (this.error_stream == null) {
            this.error_stream = new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                    if (RLogPanel.this.level != 'e') {
                        RLogPanel.this.level = (char)101;
                        this.write(101);
                        this.write(32);
                        this.write(b);
                        return;
                    }
                    if (RLogPanel.this.pos >= RLogPanel.this.maxsize) {
                        for (int i = 0; i < RLogPanel.this.minsize; ++i) {
                            RLogPanel.this.buffer[i] = RLogPanel.this.buffer[RLogPanel.this.maxsize - RLogPanel.this.minsize + i];
                        }
                        RLogPanel.this.pos = RLogPanel.this.minsize;
                    }
                    RLogPanel.this.buffer[RLogPanel.this.pos] = (char)b;
                    ++RLogPanel.this.pos;
                }
            };
        }
        return this.error_stream;
    }

    public PrintStream getInfoPrintStream() {
        if (this.info_pstream == null) {
            this.info_pstream = new PrintStream(this.getInfoStream());
        }
        return this.info_pstream;
    }

    public PrintStream getOutputPrintStream() {
        if (this.output_stream == null) {
            this.output_pstream = new PrintStream(this.getOutputStream());
        }
        return this.output_pstream;
    }

    public PrintStream getWarnPrintStream() {
        if (this.warn_pstream == null) {
            this.warn_pstream = new PrintStream(this.getWarnStream());
        }
        return this.warn_pstream;
    }

    public PrintStream getErrorPrintStream() {
        if (this.error_pstream == null) {
            this.error_pstream = new PrintStream(this.getErrorStream());
        }
        return this.error_pstream;
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTextPane1 = new JTextPane();
        this._bar = new JToolBar();
        this._update = new JButton();
        this._del = new JButton();
        this._save = new JButton();
        this.jScrollPane1.setHorizontalScrollBarPolicy(31);
        this.jScrollPane1.setViewportView(this.jTextPane1);
        this._bar.setFloatable(false);
        this._bar.setOrientation(1);
        this._bar.setRollover(true);
        this._update.setText("Update");
        this._update.setToolTipText("Remove R object");
        this._update.setFocusable(false);
        this._update.setHorizontalTextPosition(0);
        this._update.setVerticalTextPosition(3);
        this._update.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RLogPanel.this._updateActionPerformed(evt);
            }
        });
        this._bar.add(this._update);
        this._del.setText("Clear");
        this._del.setToolTipText("Remove R object");
        this._del.setFocusable(false);
        this._del.setHorizontalTextPosition(0);
        this._del.setVerticalTextPosition(3);
        this._del.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RLogPanel.this._delActionPerformed(evt);
            }
        });
        this._bar.add(this._del);
        this._save.setText("Save");
        this._save.setToolTipText("Remove R object");
        this._save.setFocusable(false);
        this._save.setHorizontalTextPosition(0);
        this._save.setVerticalTextPosition(3);
        this._save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RLogPanel.this._saveActionPerformed(evt);
            }
        });
        this._bar.add(this._save);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this._bar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 407, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 197, Short.MAX_VALUE).addComponent(this._bar, -1, 197, Short.MAX_VALUE));
    }

    private void _delActionPerformed(ActionEvent evt) {
        this.jTextPane1.setText("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _saveActionPerformed(ActionEvent evt) {
        JFileChooser fc = new JFileChooser(new File("R.log"));
        if (fc.showSaveDialog(this) == 0 && fc.getSelectedFile() != null) {
            FileOutputStream os = null;
            try {
                os = new FileOutputStream(fc.getSelectedFile());
                os.write(this.jTextPane1.getText().getBytes());
                os.flush();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    os.close();
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                }
            }
        }
    }

    private void _updateActionPerformed(ActionEvent evt) {
        this.jTextPane1.setText("");
        String text = new String(this.buffer, 0, this.pos);
        String[] lines = text.split("\n");
        Style style = this.jTextPane1.getStyle("INFO");
        for (String line : lines) {
            if (line.startsWith("o ")) {
                line = line.substring(2);
                style = this.jTextPane1.getStyle("OUTPUT");
            } else if (line.startsWith("i ")) {
                line = line.substring(2);
                style = this.jTextPane1.getStyle("INFO");
            } else if (line.startsWith("w ")) {
                line = line.substring(2);
                style = this.jTextPane1.getStyle("WARN");
            } else if (line.startsWith("e ")) {
                line = line.substring(2);
                style = this.jTextPane1.getStyle("ERROR");
            }
            try {
                this.jTextPane1.getDocument().insertString(this.jTextPane1.getDocument().getLength(), line + "\n", style);
                this.jTextPane1.setCaretPosition(this.jTextPane1.getDocument().getLength());
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
    }
}

