/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.s7.model;

import com.github.xingshuangs.iot.common.IObjectByteArray;
import com.github.xingshuangs.iot.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.s7.enums.EDestinationFileSystem;
import com.github.xingshuangs.iot.protocol.s7.enums.EErrorClass;
import com.github.xingshuangs.iot.protocol.s7.enums.EFileBlockType;
import com.github.xingshuangs.iot.protocol.s7.enums.EFunctionCode;
import com.github.xingshuangs.iot.protocol.s7.model.AckHeader;
import com.github.xingshuangs.iot.protocol.s7.model.COTP;
import com.github.xingshuangs.iot.protocol.s7.model.COTPBuilder;
import com.github.xingshuangs.iot.protocol.s7.model.COTPConnection;
import com.github.xingshuangs.iot.protocol.s7.model.COTPData;
import com.github.xingshuangs.iot.protocol.s7.model.DataItem;
import com.github.xingshuangs.iot.protocol.s7.model.Datum;
import com.github.xingshuangs.iot.protocol.s7.model.DownloadParameter;
import com.github.xingshuangs.iot.protocol.s7.model.EndDownloadParameter;
import com.github.xingshuangs.iot.protocol.s7.model.EndUploadParameter;
import com.github.xingshuangs.iot.protocol.s7.model.Header;
import com.github.xingshuangs.iot.protocol.s7.model.HeaderBuilder;
import com.github.xingshuangs.iot.protocol.s7.model.Parameter;
import com.github.xingshuangs.iot.protocol.s7.model.ParameterBuilder;
import com.github.xingshuangs.iot.protocol.s7.model.PlcControlParameter;
import com.github.xingshuangs.iot.protocol.s7.model.PlcStopParameter;
import com.github.xingshuangs.iot.protocol.s7.model.ReadWriteDatum;
import com.github.xingshuangs.iot.protocol.s7.model.ReadWriteParameter;
import com.github.xingshuangs.iot.protocol.s7.model.RequestItem;
import com.github.xingshuangs.iot.protocol.s7.model.ReturnItem;
import com.github.xingshuangs.iot.protocol.s7.model.SetupComParameter;
import com.github.xingshuangs.iot.protocol.s7.model.StartDownloadParameter;
import com.github.xingshuangs.iot.protocol.s7.model.StartUploadParameter;
import com.github.xingshuangs.iot.protocol.s7.model.TPKT;
import com.github.xingshuangs.iot.protocol.s7.model.UpDownloadDatum;
import com.github.xingshuangs.iot.protocol.s7.model.UploadParameter;
import java.util.Arrays;
import java.util.List;

public class S7Data
implements IObjectByteArray {
    private TPKT tpkt;
    private COTP cotp;
    private Header header;
    private Parameter parameter;
    private Datum datum;

    @Override
    public int byteArrayLength() {
        int length = 0;
        length += this.tpkt != null ? this.tpkt.byteArrayLength() : 0;
        length += this.cotp != null ? this.cotp.byteArrayLength() : 0;
        length += this.header != null ? this.header.byteArrayLength() : 0;
        length += this.parameter != null ? this.parameter.byteArrayLength() : 0;
        return length += this.datum != null ? this.datum.byteArrayLength() : 0;
    }

    @Override
    public byte[] toByteArray() {
        ByteWriteBuff buff = ByteWriteBuff.newInstance(this.byteArrayLength());
        if (this.tpkt != null) {
            buff.putBytes(this.tpkt.toByteArray());
        }
        if (this.cotp != null) {
            buff.putBytes(this.cotp.toByteArray());
        }
        if (this.header != null) {
            buff.putBytes(this.header.toByteArray());
        }
        if (this.parameter != null) {
            buff.putBytes(this.parameter.toByteArray());
        }
        if (this.datum != null) {
            buff.putBytes(this.datum.toByteArray());
        }
        return buff.getData();
    }

    public void selfCheck() {
        if (this.header != null) {
            this.header.setDataLength(0);
            this.header.setParameterLength(0);
        }
        if (this.parameter != null && this.header != null) {
            this.header.setParameterLength(this.parameter.byteArrayLength());
        }
        if (this.datum != null && this.header != null) {
            this.header.setDataLength(this.datum.byteArrayLength());
        }
        if (this.tpkt != null) {
            this.tpkt.setLength(this.byteArrayLength());
        }
    }

    public static S7Data fromBytes(byte[] data) {
        byte[] tpktBytes = Arrays.copyOfRange(data, 0, 4);
        TPKT tpkt = TPKT.fromBytes(tpktBytes);
        byte[] remainBytes = Arrays.copyOfRange(data, 4, data.length);
        return S7Data.fromBytes(tpkt, remainBytes);
    }

    public static S7Data fromBytes(TPKT tpkt, byte[] remain) {
        Header header;
        COTP cotp;
        S7Data s7Data = new S7Data();
        s7Data.tpkt = tpkt;
        s7Data.cotp = cotp = COTPBuilder.fromBytes(remain);
        if (cotp == null || remain.length <= cotp.byteArrayLength()) {
            return s7Data;
        }
        byte[] lastBytes = Arrays.copyOfRange(remain, cotp.byteArrayLength(), remain.length);
        s7Data.header = header = HeaderBuilder.fromBytes(lastBytes);
        if (header == null) {
            return s7Data;
        }
        if (header.getParameterLength() > 0) {
            byte[] parameterBytes = Arrays.copyOfRange(lastBytes, header.byteArrayLength(), header.byteArrayLength() + header.getParameterLength());
            s7Data.parameter = ParameterBuilder.fromBytes(parameterBytes, s7Data.header.getMessageType());
        }
        if (header.getDataLength() > 0) {
            byte[] dataBytes = Arrays.copyOfRange(lastBytes, header.byteArrayLength() + header.getParameterLength(), header.byteArrayLength() + header.getParameterLength() + header.getDataLength());
            s7Data.datum = Datum.fromBytes(dataBytes, s7Data.header.getMessageType(), s7Data.parameter.getFunctionCode());
        }
        return s7Data;
    }

    public static S7Data createConnectRequest(int local, int remote) {
        S7Data s7Data = new S7Data();
        s7Data.tpkt = new TPKT();
        s7Data.cotp = COTPConnection.crConnectRequest(local, remote);
        s7Data.selfCheck();
        return s7Data;
    }

    public static S7Data createConnectConfirm(S7Data request) {
        S7Data s7Data = new S7Data();
        s7Data.tpkt = new TPKT();
        s7Data.cotp = COTPConnection.crConnectConfirm((COTPConnection)request.cotp);
        s7Data.selfCheck();
        return s7Data;
    }

    public static S7Data createConnectDtData(int pduLength) {
        S7Data s7Data = new S7Data();
        s7Data.tpkt = new TPKT();
        s7Data.cotp = COTPData.createDefault();
        s7Data.header = Header.createDefault();
        s7Data.parameter = SetupComParameter.createDefault(pduLength);
        s7Data.selfCheck();
        return s7Data;
    }

    public static S7Data createConnectAckDtData(S7Data request) {
        S7Data s7Data = new S7Data();
        s7Data.tpkt = new TPKT();
        s7Data.cotp = request.cotp;
        s7Data.header = AckHeader.createDefault(request.header, EErrorClass.NO_ERROR, 0);
        s7Data.parameter = request.parameter;
        s7Data.selfCheck();
        return s7Data;
    }

    public static S7Data createErrorResponse(S7Data request, EErrorClass errorClass, int errorCode) {
        S7Data s7Data = new S7Data();
        s7Data.tpkt = new TPKT();
        s7Data.cotp = COTPData.createDefault();
        s7Data.header = AckHeader.createDefault(request.header, errorClass, errorCode);
        s7Data.parameter = ReadWriteParameter.createAckParameter((ReadWriteParameter)request.parameter);
        s7Data.selfCheck();
        return s7Data;
    }

    public static S7Data createReadRequest(List<RequestItem> requestItems) {
        S7Data s7Data = new S7Data();
        s7Data.tpkt = new TPKT();
        s7Data.cotp = COTPData.createDefault();
        s7Data.header = Header.createDefault();
        s7Data.parameter = ReadWriteParameter.createReqParameter(EFunctionCode.READ_VARIABLE, requestItems);
        s7Data.selfCheck();
        return s7Data;
    }

    public static S7Data createWriteRequest(List<RequestItem> requestItems, List<DataItem> dataItems) {
        S7Data s7Data = new S7Data();
        s7Data.tpkt = new TPKT();
        s7Data.cotp = COTPData.createDefault();
        s7Data.header = Header.createDefault();
        s7Data.parameter = ReadWriteParameter.createReqParameter(EFunctionCode.WRITE_VARIABLE, requestItems);
        s7Data.datum = ReadWriteDatum.createDatum(dataItems);
        s7Data.selfCheck();
        return s7Data;
    }

    public static S7Data createReadWriteResponse(S7Data request, List<ReturnItem> returnItems) {
        S7Data s7Data = new S7Data();
        s7Data.tpkt = new TPKT();
        s7Data.cotp = COTPData.createDefault();
        s7Data.header = AckHeader.createDefault(request.header, EErrorClass.NO_ERROR, 0);
        s7Data.parameter = ReadWriteParameter.createAckParameter((ReadWriteParameter)request.parameter);
        s7Data.datum = ReadWriteDatum.createDatum(returnItems);
        s7Data.selfCheck();
        return s7Data;
    }

    public static S7Data createHotRestart() {
        S7Data s7Data = new S7Data();
        s7Data.tpkt = new TPKT();
        s7Data.cotp = COTPData.createDefault();
        s7Data.header = Header.createDefault();
        s7Data.parameter = PlcControlParameter.hotRestart();
        s7Data.selfCheck();
        return s7Data;
    }

    public static S7Data createColdRestart() {
        S7Data s7Data = new S7Data();
        s7Data.tpkt = new TPKT();
        s7Data.cotp = COTPData.createDefault();
        s7Data.header = Header.createDefault();
        s7Data.parameter = PlcControlParameter.coldRestart();
        s7Data.selfCheck();
        return s7Data;
    }

    public static S7Data createPlcStop() {
        S7Data s7Data = new S7Data();
        s7Data.tpkt = new TPKT();
        s7Data.cotp = COTPData.createDefault();
        s7Data.header = Header.createDefault();
        s7Data.parameter = PlcStopParameter.createDefault();
        s7Data.selfCheck();
        return s7Data;
    }

    public static S7Data createCopyRamToRom() {
        S7Data s7Data = new S7Data();
        s7Data.tpkt = new TPKT();
        s7Data.cotp = COTPData.createDefault();
        s7Data.header = Header.createDefault();
        s7Data.parameter = PlcControlParameter.copyRamToRom();
        s7Data.selfCheck();
        return s7Data;
    }

    public static S7Data createCompress() {
        S7Data s7Data = new S7Data();
        s7Data.tpkt = new TPKT();
        s7Data.cotp = COTPData.createDefault();
        s7Data.header = Header.createDefault();
        s7Data.parameter = PlcControlParameter.compress();
        s7Data.selfCheck();
        return s7Data;
    }

    public static S7Data createInsert(EFileBlockType blockType, int blockNumber, EDestinationFileSystem destinationFileSystem) {
        S7Data s7Data = new S7Data();
        s7Data.tpkt = new TPKT();
        s7Data.cotp = COTPData.createDefault();
        s7Data.header = Header.createDefault();
        s7Data.parameter = PlcControlParameter.insert(blockType, blockNumber, destinationFileSystem);
        s7Data.selfCheck();
        return s7Data;
    }

    public static S7Data createStartDownload(EFileBlockType blockType, int blockNumber, EDestinationFileSystem destinationFileSystem, int loadMemoryLength, int mC7CodeLength) {
        S7Data s7Data = new S7Data();
        s7Data.tpkt = new TPKT();
        s7Data.cotp = COTPData.createDefault();
        s7Data.header = Header.createDefault();
        s7Data.parameter = StartDownloadParameter.createDefault(blockType, blockNumber, destinationFileSystem, loadMemoryLength, mC7CodeLength);
        s7Data.selfCheck();
        return s7Data;
    }

    public static S7Data createDownload(EFileBlockType blockType, int blockNumber, EDestinationFileSystem destinationFileSystem, boolean moreDataFollowing, byte[] data) {
        S7Data s7Data = new S7Data();
        s7Data.tpkt = new TPKT();
        s7Data.cotp = COTPData.createDefault();
        s7Data.header = Header.createDefault();
        s7Data.parameter = DownloadParameter.createDefault(blockType, blockNumber, destinationFileSystem, moreDataFollowing);
        s7Data.datum = UpDownloadDatum.createDownloadData(data);
        s7Data.selfCheck();
        return s7Data;
    }

    public static S7Data createEndDownload(EFileBlockType blockType, int blockNumber, EDestinationFileSystem destinationFileSystem) {
        S7Data s7Data = new S7Data();
        s7Data.tpkt = new TPKT();
        s7Data.cotp = COTPData.createDefault();
        s7Data.header = Header.createDefault();
        s7Data.parameter = EndDownloadParameter.createDefault(blockType, blockNumber, destinationFileSystem);
        s7Data.selfCheck();
        return s7Data;
    }

    public static S7Data createStartUpload(EFileBlockType blockType, int blockNumber, EDestinationFileSystem destinationFileSystem) {
        S7Data s7Data = new S7Data();
        s7Data.tpkt = new TPKT();
        s7Data.cotp = COTPData.createDefault();
        s7Data.header = Header.createDefault();
        s7Data.parameter = StartUploadParameter.createDefault(blockType, blockNumber, destinationFileSystem);
        s7Data.selfCheck();
        return s7Data;
    }

    public static S7Data createUpload(long uploadId) {
        S7Data s7Data = new S7Data();
        s7Data.tpkt = new TPKT();
        s7Data.cotp = COTPData.createDefault();
        s7Data.header = Header.createDefault();
        s7Data.parameter = UploadParameter.createDefault(uploadId);
        s7Data.selfCheck();
        return s7Data;
    }

    public static S7Data createEndUpload(long uploadId) {
        S7Data s7Data = new S7Data();
        s7Data.tpkt = new TPKT();
        s7Data.cotp = COTPData.createDefault();
        s7Data.header = Header.createDefault();
        s7Data.parameter = EndUploadParameter.createDefault(uploadId);
        s7Data.selfCheck();
        return s7Data;
    }

    public TPKT getTpkt() {
        return this.tpkt;
    }

    public COTP getCotp() {
        return this.cotp;
    }

    public Header getHeader() {
        return this.header;
    }

    public Parameter getParameter() {
        return this.parameter;
    }

    public Datum getDatum() {
        return this.datum;
    }

    public void setTpkt(TPKT tpkt) {
        this.tpkt = tpkt;
    }

    public void setCotp(COTP cotp) {
        this.cotp = cotp;
    }

    public void setHeader(Header header) {
        this.header = header;
    }

    public void setParameter(Parameter parameter) {
        this.parameter = parameter;
    }

    public void setDatum(Datum datum) {
        this.datum = datum;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof S7Data)) {
            return false;
        }
        S7Data other = (S7Data)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TPKT this$tpkt = this.getTpkt();
        TPKT other$tpkt = other.getTpkt();
        if (this$tpkt == null ? other$tpkt != null : !this$tpkt.equals(other$tpkt)) {
            return false;
        }
        COTP this$cotp = this.getCotp();
        COTP other$cotp = other.getCotp();
        if (this$cotp == null ? other$cotp != null : !((Object)this$cotp).equals(other$cotp)) {
            return false;
        }
        Header this$header = this.getHeader();
        Header other$header = other.getHeader();
        if (this$header == null ? other$header != null : !((Object)this$header).equals(other$header)) {
            return false;
        }
        Parameter this$parameter = this.getParameter();
        Parameter other$parameter = other.getParameter();
        if (this$parameter == null ? other$parameter != null : !((Object)this$parameter).equals(other$parameter)) {
            return false;
        }
        Datum this$datum = this.getDatum();
        Datum other$datum = other.getDatum();
        return !(this$datum == null ? other$datum != null : !((Object)this$datum).equals(other$datum));
    }

    protected boolean canEqual(Object other) {
        return other instanceof S7Data;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TPKT $tpkt = this.getTpkt();
        result = result * 59 + ($tpkt == null ? 43 : $tpkt.hashCode());
        COTP $cotp = this.getCotp();
        result = result * 59 + ($cotp == null ? 43 : ((Object)$cotp).hashCode());
        Header $header = this.getHeader();
        result = result * 59 + ($header == null ? 43 : ((Object)$header).hashCode());
        Parameter $parameter = this.getParameter();
        result = result * 59 + ($parameter == null ? 43 : ((Object)$parameter).hashCode());
        Datum $datum = this.getDatum();
        result = result * 59 + ($datum == null ? 43 : ((Object)$datum).hashCode());
        return result;
    }

    public String toString() {
        return "S7Data(tpkt=" + this.getTpkt() + ", cotp=" + this.getCotp() + ", header=" + this.getHeader() + ", parameter=" + this.getParameter() + ", datum=" + this.getDatum() + ")";
    }
}

