/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.s7.model;

import com.github.xingshuangs.iot.common.IObjectByteArray;
import com.github.xingshuangs.iot.common.buff.ByteReadBuff;
import com.github.xingshuangs.iot.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.exceptions.S7CommException;
import com.github.xingshuangs.iot.protocol.s7.enums.EDestinationFileSystem;
import com.github.xingshuangs.iot.protocol.s7.enums.EFileBlockType;
import com.github.xingshuangs.iot.protocol.s7.enums.EFunctionCode;
import com.github.xingshuangs.iot.protocol.s7.model.Parameter;
import com.github.xingshuangs.iot.protocol.s7.model.PlcControlInsertParamBlock;
import com.github.xingshuangs.iot.protocol.s7.model.PlcControlParamBlock;
import com.github.xingshuangs.iot.protocol.s7.model.PlcControlStringParamBlock;
import com.github.xingshuangs.iot.utils.ByteUtil;
import java.util.Arrays;

public class PlcControlParameter
extends Parameter
implements IObjectByteArray {
    public static final String P_PROGRAM = "P_PROGRAM";
    private byte[] unknownBytes = new byte[]{0, 0, 0, 0, 0, 0, -3};
    private int parameterBlockLength = 0;
    private PlcControlParamBlock parameterBlock;
    private int lengthPart = 0;
    private String piService = "";

    public void setParameterBlock(PlcControlParamBlock parameterBlock) {
        this.parameterBlock = parameterBlock;
        this.parameterBlockLength = this.parameterBlock.byteArrayLength();
    }

    public void setPiService(String piService) {
        this.piService = piService;
        this.lengthPart = this.piService.length();
    }

    public PlcControlParameter() {
        this.functionCode = EFunctionCode.PLC_CONTROL;
    }

    @Override
    public int byteArrayLength() {
        return 10 + this.parameterBlockLength + 1 + this.lengthPart;
    }

    @Override
    public byte[] toByteArray() {
        return ByteWriteBuff.newInstance(10 + this.parameterBlockLength + 1 + this.lengthPart).putByte(this.functionCode.getCode()).putBytes(this.unknownBytes).putShort(this.parameterBlockLength).putBytes(this.parameterBlock.toByteArray()).putByte(this.lengthPart).putString(this.piService).getData();
    }

    public static PlcControlParameter fromBytes(byte[] data) {
        if (data.length < 11) {
            throw new S7CommException("PlcControlParameter\u89e3\u6790\u6709\u8bef\uff0cPlcControlParameter\u5b57\u8282\u6570\u7ec4\u957f\u5ea6 < 11");
        }
        ByteReadBuff buff = new ByteReadBuff(data);
        PlcControlParameter parameter = new PlcControlParameter();
        parameter.functionCode = EFunctionCode.from(buff.getByte());
        parameter.unknownBytes = buff.getBytes(7);
        parameter.parameterBlockLength = buff.getUInt16();
        parameter.parameterBlock = parameter.parameterBlockLength == 0 ? new PlcControlParamBlock() : new PlcControlStringParamBlock(buff.getString(parameter.parameterBlockLength));
        parameter.lengthPart = buff.getByteToInt();
        parameter.piService = parameter.lengthPart == 0 ? "" : buff.getString(parameter.lengthPart);
        return parameter;
    }

    public static PlcControlParameter hotRestart() {
        PlcControlParameter parameter = new PlcControlParameter();
        parameter.setParameterBlock(new PlcControlStringParamBlock());
        parameter.setPiService(P_PROGRAM);
        return parameter;
    }

    public static PlcControlParameter coldRestart() {
        PlcControlParameter parameter = new PlcControlParameter();
        parameter.setParameterBlock(new PlcControlStringParamBlock("C "));
        parameter.setPiService(P_PROGRAM);
        return parameter;
    }

    public static PlcControlParameter copyRamToRom() {
        PlcControlParameter parameter = new PlcControlParameter();
        parameter.setParameterBlock(new PlcControlStringParamBlock("EP"));
        parameter.setPiService("_MODU");
        return parameter;
    }

    public static PlcControlParameter compress() {
        PlcControlParameter parameter = new PlcControlParameter();
        parameter.setParameterBlock(new PlcControlStringParamBlock());
        parameter.setPiService("_GARB");
        return parameter;
    }

    public static PlcControlParameter insert(EFileBlockType blockType, int blockNumber, EDestinationFileSystem destinationFileSystem) {
        byte[] data = ByteWriteBuff.newInstance(8).putBytes(blockType.getByteArray()).putString(String.format("%05d", blockNumber)).putByte(destinationFileSystem.getCode()).getData();
        PlcControlInsertParamBlock insertParamBlock = new PlcControlInsertParamBlock();
        insertParamBlock.addFileName(ByteUtil.toStr(data));
        PlcControlParameter parameter = new PlcControlParameter();
        parameter.setParameterBlock(insertParamBlock);
        parameter.setPiService("_INSE");
        return parameter;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PlcControlParameter)) {
            return false;
        }
        PlcControlParameter other = (PlcControlParameter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getParameterBlockLength() != other.getParameterBlockLength()) {
            return false;
        }
        if (this.getLengthPart() != other.getLengthPart()) {
            return false;
        }
        if (!Arrays.equals(this.getUnknownBytes(), other.getUnknownBytes())) {
            return false;
        }
        PlcControlParamBlock this$parameterBlock = this.getParameterBlock();
        PlcControlParamBlock other$parameterBlock = other.getParameterBlock();
        if (this$parameterBlock == null ? other$parameterBlock != null : !this$parameterBlock.equals(other$parameterBlock)) {
            return false;
        }
        String this$piService = this.getPiService();
        String other$piService = other.getPiService();
        return !(this$piService == null ? other$piService != null : !this$piService.equals(other$piService));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof PlcControlParameter;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getParameterBlockLength();
        result = result * 59 + this.getLengthPart();
        result = result * 59 + Arrays.hashCode(this.getUnknownBytes());
        PlcControlParamBlock $parameterBlock = this.getParameterBlock();
        result = result * 59 + ($parameterBlock == null ? 43 : $parameterBlock.hashCode());
        String $piService = this.getPiService();
        result = result * 59 + ($piService == null ? 43 : $piService.hashCode());
        return result;
    }

    public byte[] getUnknownBytes() {
        return this.unknownBytes;
    }

    public int getParameterBlockLength() {
        return this.parameterBlockLength;
    }

    public PlcControlParamBlock getParameterBlock() {
        return this.parameterBlock;
    }

    public int getLengthPart() {
        return this.lengthPart;
    }

    public String getPiService() {
        return this.piService;
    }

    public void setUnknownBytes(byte[] unknownBytes) {
        this.unknownBytes = unknownBytes;
    }

    public void setParameterBlockLength(int parameterBlockLength) {
        this.parameterBlockLength = parameterBlockLength;
    }

    public void setLengthPart(int lengthPart) {
        this.lengthPart = lengthPart;
    }

    @Override
    public String toString() {
        return "PlcControlParameter(unknownBytes=" + Arrays.toString(this.getUnknownBytes()) + ", parameterBlockLength=" + this.getParameterBlockLength() + ", parameterBlock=" + this.getParameterBlock() + ", lengthPart=" + this.getLengthPart() + ", piService=" + this.getPiService() + ")";
    }
}

