/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.s7.model;

import com.github.xingshuangs.iot.common.IObjectByteArray;
import com.github.xingshuangs.iot.common.buff.ByteReadBuff;
import com.github.xingshuangs.iot.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.exceptions.S7CommException;
import com.github.xingshuangs.iot.protocol.s7.enums.EFunctionCode;
import com.github.xingshuangs.iot.protocol.s7.model.Parameter;

public class PlcControlAckParameter
extends Parameter
implements IObjectByteArray {
    private byte unknownByte;

    public PlcControlAckParameter() {
        this.functionCode = EFunctionCode.PLC_CONTROL;
    }

    @Override
    public int byteArrayLength() {
        return 2;
    }

    @Override
    public byte[] toByteArray() {
        return ByteWriteBuff.newInstance(2).putByte(this.functionCode.getCode()).putByte(this.unknownByte).getData();
    }

    public static PlcControlAckParameter fromBytes(byte[] data) {
        if (data.length < 1) {
            throw new S7CommException("PlcControlAckParameter\u89e3\u6790\u6709\u8bef\uff0cPlcControlAckParameter\u5b57\u8282\u6570\u7ec4\u957f\u5ea6 < 1");
        }
        ByteReadBuff buff = new ByteReadBuff(data);
        PlcControlAckParameter parameter = new PlcControlAckParameter();
        parameter.functionCode = EFunctionCode.from(buff.getByte());
        parameter.unknownByte = buff.getByte();
        return parameter;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PlcControlAckParameter)) {
            return false;
        }
        PlcControlAckParameter other = (PlcControlAckParameter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return this.getUnknownByte() == other.getUnknownByte();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof PlcControlAckParameter;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getUnknownByte();
        return result;
    }

    public byte getUnknownByte() {
        return this.unknownByte;
    }

    public void setUnknownByte(byte unknownByte) {
        this.unknownByte = unknownByte;
    }

    @Override
    public String toString() {
        return "PlcControlAckParameter(unknownByte=" + this.getUnknownByte() + ")";
    }
}

