/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.s7.model;

import com.github.xingshuangs.iot.common.IObjectByteArray;
import com.github.xingshuangs.iot.common.buff.ByteReadBuff;
import com.github.xingshuangs.iot.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.s7.enums.EDestinationFileSystem;
import com.github.xingshuangs.iot.protocol.s7.enums.EFileBlockType;
import com.github.xingshuangs.iot.protocol.s7.enums.EFunctionCode;
import com.github.xingshuangs.iot.protocol.s7.model.UploadAckParameter;
import com.github.xingshuangs.iot.utils.BooleanUtil;
import java.util.Arrays;

public class DownloadParameter
extends UploadAckParameter
implements IObjectByteArray {
    protected byte[] errorCode = new byte[]{1, 0};
    protected long id = 0L;
    protected int fileNameLength = 9;
    protected String fileIdentifier = "_";
    protected EFileBlockType blockType = EFileBlockType.OB;
    protected int blockNumber = 0;
    protected EDestinationFileSystem destinationFileSystem = EDestinationFileSystem.P;

    public DownloadParameter() {
        this.functionCode = EFunctionCode.DOWNLOAD;
    }

    @Override
    public int byteArrayLength() {
        return 18;
    }

    @Override
    public byte[] toByteArray() {
        return ByteWriteBuff.newInstance(18).putByte(this.functionCode.getCode()).putByte((byte)(BooleanUtil.setBit(0, this.moreDataFollowing) | BooleanUtil.setBit(1, this.errorStatus))).putBytes(this.errorCode).putInteger(this.id).putByte(this.fileNameLength).putString(this.fileIdentifier).putBytes(this.blockType.getByteArray()).putString(String.format("%05d", this.blockNumber)).putByte(this.destinationFileSystem.getCode()).getData();
    }

    public static DownloadParameter fromBytes(byte[] data) {
        return DownloadParameter.fromBytes(data, 0);
    }

    public static DownloadParameter fromBytes(byte[] data, int offset) {
        if (data.length < 18) {
            throw new IndexOutOfBoundsException("\u89e3\u6790DownloadParameter\u65f6\uff0c\u5b57\u8282\u6570\u7ec4\u957f\u5ea6\u4e0d\u591f");
        }
        ByteReadBuff buff = new ByteReadBuff(data, offset);
        DownloadParameter res = new DownloadParameter();
        res.functionCode = EFunctionCode.from(buff.getByte());
        byte b = buff.getByte();
        res.moreDataFollowing = BooleanUtil.getValue(b, 0);
        res.errorStatus = BooleanUtil.getValue(b, 1);
        res.errorCode = buff.getBytes(2);
        res.id = buff.getUInt32();
        res.fileNameLength = buff.getByteToInt();
        res.fileIdentifier = buff.getString(1);
        res.blockType = EFileBlockType.from(buff.getString(2));
        res.blockNumber = Integer.parseInt(buff.getString(5));
        res.destinationFileSystem = EDestinationFileSystem.from(buff.getByte());
        return res;
    }

    public static DownloadParameter createDefault(EFileBlockType blockType, int blockNumber, EDestinationFileSystem destinationFileSystem, boolean moreDataFollowing) {
        DownloadParameter parameter = new DownloadParameter();
        parameter.blockType = blockType;
        parameter.blockNumber = blockNumber;
        parameter.destinationFileSystem = destinationFileSystem;
        parameter.setMoreDataFollowing(moreDataFollowing);
        return parameter;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DownloadParameter)) {
            return false;
        }
        DownloadParameter other = (DownloadParameter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        if (this.getFileNameLength() != other.getFileNameLength()) {
            return false;
        }
        if (this.getBlockNumber() != other.getBlockNumber()) {
            return false;
        }
        if (!Arrays.equals(this.getErrorCode(), other.getErrorCode())) {
            return false;
        }
        String this$fileIdentifier = this.getFileIdentifier();
        String other$fileIdentifier = other.getFileIdentifier();
        if (this$fileIdentifier == null ? other$fileIdentifier != null : !this$fileIdentifier.equals(other$fileIdentifier)) {
            return false;
        }
        EFileBlockType this$blockType = this.getBlockType();
        EFileBlockType other$blockType = other.getBlockType();
        if (this$blockType == null ? other$blockType != null : !((Object)((Object)this$blockType)).equals((Object)other$blockType)) {
            return false;
        }
        EDestinationFileSystem this$destinationFileSystem = this.getDestinationFileSystem();
        EDestinationFileSystem other$destinationFileSystem = other.getDestinationFileSystem();
        return !(this$destinationFileSystem == null ? other$destinationFileSystem != null : !((Object)((Object)this$destinationFileSystem)).equals((Object)other$destinationFileSystem));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DownloadParameter;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $id = this.getId();
        result = result * 59 + (int)($id >>> 32 ^ $id);
        result = result * 59 + this.getFileNameLength();
        result = result * 59 + this.getBlockNumber();
        result = result * 59 + Arrays.hashCode(this.getErrorCode());
        String $fileIdentifier = this.getFileIdentifier();
        result = result * 59 + ($fileIdentifier == null ? 43 : $fileIdentifier.hashCode());
        EFileBlockType $blockType = this.getBlockType();
        result = result * 59 + ($blockType == null ? 43 : ((Object)((Object)$blockType)).hashCode());
        EDestinationFileSystem $destinationFileSystem = this.getDestinationFileSystem();
        result = result * 59 + ($destinationFileSystem == null ? 43 : ((Object)((Object)$destinationFileSystem)).hashCode());
        return result;
    }

    public byte[] getErrorCode() {
        return this.errorCode;
    }

    public long getId() {
        return this.id;
    }

    public int getFileNameLength() {
        return this.fileNameLength;
    }

    public String getFileIdentifier() {
        return this.fileIdentifier;
    }

    public EFileBlockType getBlockType() {
        return this.blockType;
    }

    public int getBlockNumber() {
        return this.blockNumber;
    }

    public EDestinationFileSystem getDestinationFileSystem() {
        return this.destinationFileSystem;
    }

    public void setErrorCode(byte[] errorCode) {
        this.errorCode = errorCode;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setFileNameLength(int fileNameLength) {
        this.fileNameLength = fileNameLength;
    }

    public void setFileIdentifier(String fileIdentifier) {
        this.fileIdentifier = fileIdentifier;
    }

    public void setBlockType(EFileBlockType blockType) {
        this.blockType = blockType;
    }

    public void setBlockNumber(int blockNumber) {
        this.blockNumber = blockNumber;
    }

    public void setDestinationFileSystem(EDestinationFileSystem destinationFileSystem) {
        this.destinationFileSystem = destinationFileSystem;
    }

    @Override
    public String toString() {
        return "DownloadParameter(errorCode=" + Arrays.toString(this.getErrorCode()) + ", id=" + this.getId() + ", fileNameLength=" + this.getFileNameLength() + ", fileIdentifier=" + this.getFileIdentifier() + ", blockType=" + (Object)((Object)this.getBlockType()) + ", blockNumber=" + this.getBlockNumber() + ", destinationFileSystem=" + (Object)((Object)this.getDestinationFileSystem()) + ")";
    }
}

