/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.s7.model;

import com.github.xingshuangs.iot.common.IObjectByteArray;
import com.github.xingshuangs.iot.common.buff.ByteReadBuff;
import com.github.xingshuangs.iot.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.exceptions.S7CommException;
import com.github.xingshuangs.iot.protocol.s7.enums.EPduType;
import com.github.xingshuangs.iot.protocol.s7.model.COTP;

public class COTPConnection
extends COTP
implements IObjectByteArray {
    public static final int BYTE_LENGTH = 18;
    private int destinationReference = 0;
    private int sourceReference = 1;
    private byte flags = 0;
    private byte parameterCodeTpduSize = (byte)-64;
    private int parameterLength1 = 1;
    private int tpduSize = 10;
    private byte parameterCodeSrcTsap = (byte)-63;
    private int parameterLength2 = 2;
    private int sourceTsap = 256;
    private byte parameterCodeDstTsap = (byte)-62;
    private int parameterLength3 = 2;
    private int destinationTsap = 256;

    @Override
    public int byteArrayLength() {
        return 18;
    }

    @Override
    public byte[] toByteArray() {
        return ByteWriteBuff.newInstance(18).putByte(this.length).putByte(this.pduType.getCode()).putShort(this.destinationReference).putShort(this.sourceReference).putByte(this.flags).putByte(this.parameterCodeTpduSize).putByte(this.parameterLength1).putByte(this.tpduSize).putByte(this.parameterCodeSrcTsap).putByte(this.parameterLength2).putShort(this.sourceTsap).putByte(this.parameterCodeDstTsap).putByte(this.parameterLength3).putShort(this.destinationTsap).getData();
    }

    public static COTPConnection crConnectRequest(int local, int remote) {
        COTPConnection connection = new COTPConnection();
        connection.length = 17;
        connection.pduType = EPduType.CONNECT_REQUEST;
        connection.destinationReference = 0;
        connection.sourceReference = 1;
        connection.flags = 0;
        connection.parameterCodeTpduSize = (byte)-64;
        connection.parameterLength1 = 1;
        connection.tpduSize = 10;
        connection.parameterCodeSrcTsap = (byte)-63;
        connection.parameterLength2 = 2;
        connection.sourceTsap = local;
        connection.parameterCodeDstTsap = (byte)-62;
        connection.parameterLength3 = 2;
        connection.destinationTsap = remote;
        return connection;
    }

    public static COTPConnection crConnectConfirm(COTPConnection request) {
        COTPConnection connection = new COTPConnection();
        connection.length = 17;
        connection.pduType = EPduType.CONNECT_CONFIRM;
        connection.destinationReference = 1;
        connection.sourceReference = request.sourceReference;
        connection.flags = request.flags;
        connection.parameterCodeTpduSize = request.parameterCodeTpduSize;
        connection.parameterLength1 = request.parameterLength1;
        connection.tpduSize = request.tpduSize;
        connection.parameterCodeSrcTsap = request.parameterCodeSrcTsap;
        connection.parameterLength2 = request.parameterLength2;
        connection.sourceTsap = request.sourceTsap;
        connection.parameterCodeDstTsap = request.parameterCodeDstTsap;
        connection.parameterLength3 = request.parameterLength3;
        connection.destinationTsap = request.destinationTsap;
        return connection;
    }

    public static COTPConnection fromBytes(byte[] data) {
        if (data.length < 18) {
            throw new S7CommException("COTPConnection\u6570\u636e\u5b57\u8282\u957f\u5ea6\u4e0d\u591f\uff0c\u65e0\u6cd5\u89e3\u6790");
        }
        ByteReadBuff buff = new ByteReadBuff(data);
        COTPConnection connection = new COTPConnection();
        connection.length = buff.getByteToInt();
        connection.pduType = EPduType.from(buff.getByte());
        connection.destinationReference = buff.getUInt16();
        connection.sourceReference = buff.getUInt16();
        connection.flags = buff.getByte();
        connection.parameterCodeTpduSize = buff.getByte();
        connection.parameterLength1 = buff.getByteToInt();
        connection.tpduSize = buff.getByteToInt();
        connection.parameterCodeSrcTsap = buff.getByte();
        connection.parameterLength2 = buff.getByteToInt();
        connection.sourceTsap = buff.getUInt16();
        connection.parameterCodeDstTsap = buff.getByte();
        connection.parameterLength3 = buff.getByteToInt();
        connection.destinationTsap = buff.getUInt16();
        return connection;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof COTPConnection)) {
            return false;
        }
        COTPConnection other = (COTPConnection)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getDestinationReference() != other.getDestinationReference()) {
            return false;
        }
        if (this.getSourceReference() != other.getSourceReference()) {
            return false;
        }
        if (this.getFlags() != other.getFlags()) {
            return false;
        }
        if (this.getParameterCodeTpduSize() != other.getParameterCodeTpduSize()) {
            return false;
        }
        if (this.getParameterLength1() != other.getParameterLength1()) {
            return false;
        }
        if (this.getTpduSize() != other.getTpduSize()) {
            return false;
        }
        if (this.getParameterCodeSrcTsap() != other.getParameterCodeSrcTsap()) {
            return false;
        }
        if (this.getParameterLength2() != other.getParameterLength2()) {
            return false;
        }
        if (this.getSourceTsap() != other.getSourceTsap()) {
            return false;
        }
        if (this.getParameterCodeDstTsap() != other.getParameterCodeDstTsap()) {
            return false;
        }
        if (this.getParameterLength3() != other.getParameterLength3()) {
            return false;
        }
        return this.getDestinationTsap() == other.getDestinationTsap();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof COTPConnection;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getDestinationReference();
        result = result * 59 + this.getSourceReference();
        result = result * 59 + this.getFlags();
        result = result * 59 + this.getParameterCodeTpduSize();
        result = result * 59 + this.getParameterLength1();
        result = result * 59 + this.getTpduSize();
        result = result * 59 + this.getParameterCodeSrcTsap();
        result = result * 59 + this.getParameterLength2();
        result = result * 59 + this.getSourceTsap();
        result = result * 59 + this.getParameterCodeDstTsap();
        result = result * 59 + this.getParameterLength3();
        result = result * 59 + this.getDestinationTsap();
        return result;
    }

    public int getDestinationReference() {
        return this.destinationReference;
    }

    public int getSourceReference() {
        return this.sourceReference;
    }

    public byte getFlags() {
        return this.flags;
    }

    public byte getParameterCodeTpduSize() {
        return this.parameterCodeTpduSize;
    }

    public int getParameterLength1() {
        return this.parameterLength1;
    }

    public int getTpduSize() {
        return this.tpduSize;
    }

    public byte getParameterCodeSrcTsap() {
        return this.parameterCodeSrcTsap;
    }

    public int getParameterLength2() {
        return this.parameterLength2;
    }

    public int getSourceTsap() {
        return this.sourceTsap;
    }

    public byte getParameterCodeDstTsap() {
        return this.parameterCodeDstTsap;
    }

    public int getParameterLength3() {
        return this.parameterLength3;
    }

    public int getDestinationTsap() {
        return this.destinationTsap;
    }

    public void setDestinationReference(int destinationReference) {
        this.destinationReference = destinationReference;
    }

    public void setSourceReference(int sourceReference) {
        this.sourceReference = sourceReference;
    }

    public void setFlags(byte flags) {
        this.flags = flags;
    }

    public void setParameterCodeTpduSize(byte parameterCodeTpduSize) {
        this.parameterCodeTpduSize = parameterCodeTpduSize;
    }

    public void setParameterLength1(int parameterLength1) {
        this.parameterLength1 = parameterLength1;
    }

    public void setTpduSize(int tpduSize) {
        this.tpduSize = tpduSize;
    }

    public void setParameterCodeSrcTsap(byte parameterCodeSrcTsap) {
        this.parameterCodeSrcTsap = parameterCodeSrcTsap;
    }

    public void setParameterLength2(int parameterLength2) {
        this.parameterLength2 = parameterLength2;
    }

    public void setSourceTsap(int sourceTsap) {
        this.sourceTsap = sourceTsap;
    }

    public void setParameterCodeDstTsap(byte parameterCodeDstTsap) {
        this.parameterCodeDstTsap = parameterCodeDstTsap;
    }

    public void setParameterLength3(int parameterLength3) {
        this.parameterLength3 = parameterLength3;
    }

    public void setDestinationTsap(int destinationTsap) {
        this.destinationTsap = destinationTsap;
    }

    @Override
    public String toString() {
        return "COTPConnection(destinationReference=" + this.getDestinationReference() + ", sourceReference=" + this.getSourceReference() + ", flags=" + this.getFlags() + ", parameterCodeTpduSize=" + this.getParameterCodeTpduSize() + ", parameterLength1=" + this.getParameterLength1() + ", tpduSize=" + this.getTpduSize() + ", parameterCodeSrcTsap=" + this.getParameterCodeSrcTsap() + ", parameterLength2=" + this.getParameterLength2() + ", sourceTsap=" + this.getSourceTsap() + ", parameterCodeDstTsap=" + this.getParameterCodeDstTsap() + ", parameterLength3=" + this.getParameterLength3() + ", destinationTsap=" + this.getDestinationTsap() + ")";
    }
}

