/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.s7.algorithm;

public class S7ComItem {
    private int index;
    private int rawSize;
    private int splitOffset;
    private int ripeSize;
    private int extraSize;
    private int threshold = 0;

    public int getTotalLength() {
        if (this.ripeSize + this.extraSize > this.threshold) {
            return this.ripeSize + this.extraSize;
        }
        return this.threshold;
    }

    public int getIndex() {
        return this.index;
    }

    public int getRawSize() {
        return this.rawSize;
    }

    public int getSplitOffset() {
        return this.splitOffset;
    }

    public int getRipeSize() {
        return this.ripeSize;
    }

    public int getExtraSize() {
        return this.extraSize;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void setRawSize(int rawSize) {
        this.rawSize = rawSize;
    }

    public void setSplitOffset(int splitOffset) {
        this.splitOffset = splitOffset;
    }

    public void setRipeSize(int ripeSize) {
        this.ripeSize = ripeSize;
    }

    public void setExtraSize(int extraSize) {
        this.extraSize = extraSize;
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof S7ComItem)) {
            return false;
        }
        S7ComItem other = (S7ComItem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getIndex() != other.getIndex()) {
            return false;
        }
        if (this.getRawSize() != other.getRawSize()) {
            return false;
        }
        if (this.getSplitOffset() != other.getSplitOffset()) {
            return false;
        }
        if (this.getRipeSize() != other.getRipeSize()) {
            return false;
        }
        if (this.getExtraSize() != other.getExtraSize()) {
            return false;
        }
        return this.getThreshold() == other.getThreshold();
    }

    protected boolean canEqual(Object other) {
        return other instanceof S7ComItem;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getIndex();
        result = result * 59 + this.getRawSize();
        result = result * 59 + this.getSplitOffset();
        result = result * 59 + this.getRipeSize();
        result = result * 59 + this.getExtraSize();
        result = result * 59 + this.getThreshold();
        return result;
    }

    public String toString() {
        return "S7ComItem(index=" + this.getIndex() + ", rawSize=" + this.getRawSize() + ", splitOffset=" + this.getSplitOffset() + ", ripeSize=" + this.getRipeSize() + ", extraSize=" + this.getExtraSize() + ", threshold=" + this.getThreshold() + ")";
    }

    public S7ComItem(int index, int rawSize, int splitOffset, int ripeSize, int extraSize, int threshold) {
        this.index = index;
        this.rawSize = rawSize;
        this.splitOffset = splitOffset;
        this.ripeSize = ripeSize;
        this.extraSize = extraSize;
        this.threshold = threshold;
    }

    public S7ComItem() {
    }
}

