/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.rtsp.service;

import com.github.xingshuangs.iot.exceptions.RtspCommException;
import com.github.xingshuangs.iot.net.client.TcpClientBasic;
import com.github.xingshuangs.iot.protocol.rtcp.service.RtcpUdpClient;
import com.github.xingshuangs.iot.protocol.rtp.model.frame.H264VideoFrame;
import com.github.xingshuangs.iot.protocol.rtp.model.frame.RawFrame;
import com.github.xingshuangs.iot.protocol.rtp.service.H264VideoParser;
import com.github.xingshuangs.iot.protocol.rtp.service.RtpUdpClient;
import com.github.xingshuangs.iot.protocol.rtsp.authentication.AbstractAuthenticator;
import com.github.xingshuangs.iot.protocol.rtsp.authentication.DigestAuthenticator;
import com.github.xingshuangs.iot.protocol.rtsp.enums.ERtspAcceptContent;
import com.github.xingshuangs.iot.protocol.rtsp.enums.ERtspMethod;
import com.github.xingshuangs.iot.protocol.rtsp.enums.ERtspStatusCode;
import com.github.xingshuangs.iot.protocol.rtsp.enums.ERtspTransportProtocol;
import com.github.xingshuangs.iot.protocol.rtsp.model.RtspDescribeRequest;
import com.github.xingshuangs.iot.protocol.rtsp.model.RtspDescribeResponse;
import com.github.xingshuangs.iot.protocol.rtsp.model.RtspGetParameterRequest;
import com.github.xingshuangs.iot.protocol.rtsp.model.RtspMessageRequest;
import com.github.xingshuangs.iot.protocol.rtsp.model.RtspMessageResponse;
import com.github.xingshuangs.iot.protocol.rtsp.model.RtspMessageResponseBuilder;
import com.github.xingshuangs.iot.protocol.rtsp.model.RtspOptionRequest;
import com.github.xingshuangs.iot.protocol.rtsp.model.RtspOptionResponse;
import com.github.xingshuangs.iot.protocol.rtsp.model.RtspPlayRequest;
import com.github.xingshuangs.iot.protocol.rtsp.model.RtspPlayResponse;
import com.github.xingshuangs.iot.protocol.rtsp.model.RtspSetupRequest;
import com.github.xingshuangs.iot.protocol.rtsp.model.RtspSetupResponse;
import com.github.xingshuangs.iot.protocol.rtsp.model.RtspTeardownRequest;
import com.github.xingshuangs.iot.protocol.rtsp.model.base.RtspClientPortTransport;
import com.github.xingshuangs.iot.protocol.rtsp.model.base.RtspInterleavedTransport;
import com.github.xingshuangs.iot.protocol.rtsp.model.base.RtspRangeNpt;
import com.github.xingshuangs.iot.protocol.rtsp.model.base.RtspRtpInfo;
import com.github.xingshuangs.iot.protocol.rtsp.model.base.RtspSessionInfo;
import com.github.xingshuangs.iot.protocol.rtsp.model.base.RtspTransport;
import com.github.xingshuangs.iot.protocol.rtsp.model.sdp.RtspSdp;
import com.github.xingshuangs.iot.protocol.rtsp.model.sdp.RtspSdpMedia;
import com.github.xingshuangs.iot.protocol.rtsp.model.sdp.RtspTrackInfo;
import com.github.xingshuangs.iot.protocol.rtsp.service.IRtspDataStream;
import com.github.xingshuangs.iot.protocol.rtsp.service.RtspInterleavedClient;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RtspNetwork
extends TcpClientBasic {
    private static final Logger log = LoggerFactory.getLogger(RtspNetwork.class);
    private final Object objLock = new Object();
    private boolean needAuthorization = false;
    private final Map<Integer, IRtspDataStream> socketClients = new HashMap<Integer, IRtspDataStream>();
    protected final URI uri;
    protected DigestAuthenticator authenticator;
    protected List<ERtspMethod> methods = new ArrayList<ERtspMethod>();
    protected RtspSdp sdp;
    protected RtspTransport transport;
    protected List<RtspRtpInfo> rtpInfos = new ArrayList<RtspRtpInfo>();
    protected RtspSessionInfo sessionInfo;
    protected RtspTrackInfo trackInfo;
    private Consumer<String> commCallback;
    private Consumer<RawFrame> frameHandle;
    private Runnable destroyHandle;
    protected ERtspTransportProtocol transportProtocol;

    public void onCommCallback(Consumer<String> commCallback) {
        this.commCallback = commCallback;
    }

    public void onFrameHandle(Consumer<RawFrame> frameHandle) {
        this.frameHandle = frameHandle;
    }

    public void onDestroyHandle(Runnable destroyHandle) {
        this.destroyHandle = destroyHandle;
    }

    public RtspNetwork(URI uri) {
        this(uri, ERtspTransportProtocol.TCP);
    }

    public RtspNetwork(URI uri, ERtspTransportProtocol transportProtocol) {
        this(uri, null, transportProtocol);
    }

    public RtspNetwork(URI uri, DigestAuthenticator authenticator) {
        this(uri, authenticator, ERtspTransportProtocol.TCP);
    }

    public RtspNetwork(URI uri, DigestAuthenticator authenticator, ERtspTransportProtocol transportProtocol) {
        super(uri.getHost(), uri.getPort());
        this.enableReconnect = false;
        this.uri = uri;
        this.authenticator = authenticator;
        this.transportProtocol = transportProtocol;
        this.tag = "RTSP";
    }

    @Override
    protected void doAfterConnected() {
        this.option();
        this.describe();
        this.setup();
        this.play();
    }

    @Override
    public void close() {
        this.clearSocketConnection();
        super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RtspMessageResponse readFromServer(RtspMessageRequest req) {
        RtspMessageResponse ack;
        int headerLen;
        String reqString = req.toObjectString();
        if (this.commCallback != null) {
            this.commCallback.accept(reqString);
        }
        byte[] reqBytes = reqString.getBytes(StandardCharsets.US_ASCII);
        String contentString = "";
        Object object = this.objLock;
        synchronized (object) {
            this.write(reqBytes);
            byte[] header = new byte[4096];
            headerLen = this.read(header);
            contentString = new String(header, 0, headerLen, StandardCharsets.US_ASCII);
            ack = RtspMessageResponseBuilder.fromString(contentString, req);
            if (ack.getContentLength() != null && ack.getContentLength() > 0) {
                String bodyString = "";
                int i = contentString.indexOf("\r\n\r\n");
                if (contentString.length() > i + 5) {
                    bodyString = contentString.substring(i + 4);
                } else {
                    byte[] body = new byte[ack.getContentLength().intValue()];
                    this.read(body);
                    bodyString = new String(body, StandardCharsets.US_ASCII);
                    contentString = contentString + bodyString;
                }
                if (!bodyString.isEmpty()) {
                    ack.addBodyFromString(bodyString);
                }
            }
        }
        if (headerLen == 0) {
            throw new RtspCommException("RTSP\u6570\u636e\u63a5\u6536\u957f\u5ea6\u4e3a0\uff0c\u9519\u8bef");
        }
        if (this.commCallback != null) {
            this.commCallback.accept(contentString);
        }
        this.checkPostedCom(req, ack);
        return ack;
    }

    public void sendWithoutReturn(RtspMessageRequest req) {
        if (this.needAuthorization && this.authenticator != null) {
            this.authenticator.setMethod(req.getMethod().getCode());
        }
        String reqString = req.toObjectString();
        if (this.commCallback != null) {
            this.commCallback.accept(reqString);
        }
        byte[] reqBytes = reqString.getBytes(StandardCharsets.US_ASCII);
        this.write(reqBytes);
    }

    private void checkPostedCom(RtspMessageRequest req, RtspMessageResponse ack) {
        if (!req.getVersion().equals(ack.getVersion())) {
            throw new RtspCommException("\u8bf7\u6c42\u548c\u54cd\u5e94\u7684\u7248\u672c\u53f7\u4e0d\u4e00\u81f4");
        }
        if (req.getCSeq() != ack.getCSeq()) {
            throw new RtspCommException("\u8bf7\u6c42\u548c\u54cd\u5e94\u7684\u5e8f\u5217\u53f7\u4e0d\u4e00\u81f4");
        }
    }

    private RtspMessageResponse sendRequest(RtspMessageRequest request) {
        RtspMessageResponse response;
        if (this.needAuthorization && this.authenticator != null) {
            this.authenticator.setMethod(request.getMethod().getCode());
        }
        if ((response = this.readFromServer(request)).getStatusCode() == ERtspStatusCode.UNAUTHORIZED) {
            this.needAuthorization = true;
            if (this.authenticator == null) {
                throw new RtspCommException(String.format("RTSP[%s]\u4ea4\u4e92\u4e2dauthenticator\u4e3anull", new Object[]{request.getMethod()}));
            }
            this.authenticator.addServerInfoByString(response.getWwwAuthenticate());
            this.authenticator.addClientInfo(this.uri.toString(), request.getMethod().getCode());
            request.setAuthenticator(this.authenticator);
            response = this.readFromServer(request);
        }
        if (response.getStatusCode() != ERtspStatusCode.OK) {
            throw new RtspCommException(String.format("RTSP[%s]\u4ea4\u4e92\u8fd4\u56de\u72b6\u6001\u4e3a[%s]", request.getMethod().getCode(), response.getStatusCode().getCode()));
        }
        return response;
    }

    protected void option() {
        RtspOptionRequest request = new RtspOptionRequest(this.uri);
        RtspOptionResponse response = (RtspOptionResponse)this.sendRequest(request);
        this.methods = response.getPublicMethods();
        this.clearSocketConnection();
    }

    protected void describe() {
        this.checkBeforeRequest(ERtspMethod.DESCRIBE);
        RtspDescribeRequest request = this.needAuthorization ? new RtspDescribeRequest(this.uri, Collections.singletonList(ERtspAcceptContent.SDP), (AbstractAuthenticator)this.authenticator) : new RtspDescribeRequest(this.uri, Collections.singletonList(ERtspAcceptContent.SDP));
        RtspDescribeResponse response = (RtspDescribeResponse)this.sendRequest(request);
        if (response.getSdp().getSession() == null) {
            throw new RtspCommException(String.format("RTSP[%s]\u6ca1\u6709Session", new Object[]{ERtspMethod.DESCRIBE}));
        }
        if (response.getSdp().getMedias().isEmpty()) {
            throw new RtspCommException(String.format("RTSP[%s]\u6ca1\u6709Media", new Object[]{ERtspMethod.DESCRIBE}));
        }
        this.sdp = response.getSdp();
        this.trackInfo = RtspTrackInfo.createTrackInfo(this.sdp);
    }

    protected void setup() {
        if (this.transportProtocol == ERtspTransportProtocol.UDP) {
            this.setupUdp();
        } else {
            this.setupTcp();
        }
    }

    private void setupUdp() {
        for (RtspSdpMedia media : this.sdp.getMedias()) {
            if (!media.getMediaDesc().getType().equals("video")) continue;
            H264VideoParser iPayloadParser = new H264VideoParser();
            iPayloadParser.onFrameHandle(this::doFrameHandle);
            URI actualUri = URI.create(this.uri.toString() + "/" + media.getAttributeControl().getUri());
            RtpUdpClient rtpClient = new RtpUdpClient(iPayloadParser);
            RtcpUdpClient rtcpClient = new RtcpUdpClient();
            rtpClient.setRtcpUdpClient(rtcpClient);
            RtspClientPortTransport reqTransport = new RtspClientPortTransport(rtpClient.getLocalPort(), rtcpClient.getLocalPort());
            this.doSetup(actualUri, reqTransport, media);
            RtspClientPortTransport ackTransport = (RtspClientPortTransport)this.transport;
            rtpClient.bindServer(this.uri.getHost(), ackTransport.getRtpServerPort());
            rtcpClient.bindServer(this.uri.getHost(), ackTransport.getRtcpServerPort());
            this.socketClients.put(rtpClient.getLocalPort(), rtpClient);
            this.socketClients.put(rtcpClient.getLocalPort(), rtcpClient);
        }
    }

    private void setupTcp() {
        int interleavedCount = 0;
        for (RtspSdpMedia media : this.sdp.getMedias()) {
            if (!media.getMediaDesc().getType().equals("video")) continue;
            int rtpChannelNumber = interleavedCount++;
            int rtcpChannelNumber = interleavedCount++;
            RtspInterleavedTransport reqTransport = new RtspInterleavedTransport(rtpChannelNumber, rtcpChannelNumber);
            URI actualUri = URI.create(this.uri.toString() + "/" + media.getAttributeControl().getUri());
            this.doSetup(actualUri, reqTransport, media);
            H264VideoParser iPayloadParser = new H264VideoParser();
            iPayloadParser.onFrameHandle(this::doFrameHandle);
            RtspInterleavedTransport ackTransport = (RtspInterleavedTransport)this.transport;
            RtspInterleavedClient rtspInterleavedClient = new RtspInterleavedClient(iPayloadParser, this);
            rtspInterleavedClient.setRtpVideoChannelNumber(ackTransport.getInterleaved1());
            rtspInterleavedClient.setRtcpVideoChannelNumber(ackTransport.getInterleaved2());
            this.socketClients.put(rtspInterleavedClient.getRtpVideoChannelNumber(), rtspInterleavedClient);
        }
    }

    private void doSetup(URI actualUri, RtspTransport reqTransport, RtspSdpMedia media) {
        this.checkBeforeRequest(ERtspMethod.SETUP);
        RtspSetupRequest request = this.needAuthorization ? new RtspSetupRequest(actualUri, reqTransport, (AbstractAuthenticator)this.authenticator) : new RtspSetupRequest(actualUri, reqTransport);
        RtspSetupResponse response = (RtspSetupResponse)this.sendRequest(request);
        this.transport = response.getTransport();
        this.sessionInfo = response.getSessionInfo();
        if (this.frameHandle != null && media.getMediaDesc().getType().equals("video")) {
            this.frameHandle.accept(H264VideoFrame.createSpsPpsFrame(media.getAttributeFmtp().getSps()));
            this.frameHandle.accept(H264VideoFrame.createSpsPpsFrame(media.getAttributeFmtp().getPps()));
        }
    }

    protected void play() {
        this.checkBeforeRequest(ERtspMethod.PLAY);
        RtspPlayRequest request = this.needAuthorization ? new RtspPlayRequest(this.uri, this.sessionInfo.getSessionId(), new RtspRangeNpt("0.000"), (AbstractAuthenticator)this.authenticator) : new RtspPlayRequest(this.uri, this.sessionInfo.getSessionId(), new RtspRangeNpt("0.000"));
        RtspPlayResponse response = (RtspPlayResponse)this.sendRequest(request);
        this.rtpInfos = response.getRtpInfo();
        this.socketClients.values().forEach(IRtspDataStream::triggerReceive);
    }

    protected void teardown() {
        this.clearSocketConnection();
        this.checkBeforeRequest(ERtspMethod.TEARDOWN);
        RtspTeardownRequest request = this.needAuthorization ? new RtspTeardownRequest(this.uri, this.sessionInfo.getSessionId(), (AbstractAuthenticator)this.authenticator) : new RtspTeardownRequest(this.uri, this.sessionInfo.getSessionId());
        this.sendWithoutReturn(request);
        if (this.destroyHandle != null) {
            this.destroyHandle.run();
        }
    }

    protected void getParameter() {
        RtspGetParameterRequest request;
        this.checkBeforeRequest(ERtspMethod.GET_PARAMETER);
        RtspGetParameterRequest rtspGetParameterRequest = request = this.needAuthorization ? new RtspGetParameterRequest(this.uri, this.sessionInfo.getSessionId(), (AbstractAuthenticator)this.authenticator) : new RtspGetParameterRequest(this.uri, this.sessionInfo.getSessionId());
        if (this.transportProtocol == ERtspTransportProtocol.UDP) {
            this.sendRequest(request);
        } else {
            this.sendWithoutReturn(request);
        }
    }

    private void clearSocketConnection() {
        if (this.socketClients.isEmpty()) {
            return;
        }
        this.socketClients.values().forEach(IRtspDataStream::close);
        this.socketClientJoinForFinished();
        this.socketClients.clear();
    }

    private void checkBeforeRequest(ERtspMethod method) {
        if (!this.methods.contains((Object)method)) {
            throw new RtspCommException(String.format("RTSP\u4e0d\u652f\u6301[%s]", method.getCode()));
        }
        if (this.needAuthorization && this.authenticator == null) {
            throw new RtspCommException(String.format("RTSP[%s]\u4ea4\u4e92\u4e2dauthenticator\u4e3anull", method.getCode()));
        }
    }

    private void doFrameHandle(RawFrame frame) {
        if (this.frameHandle != null) {
            this.frameHandle.accept(frame);
        }
    }

    protected void socketClientJoinForFinished() {
        CompletableFuture[] futures = (CompletableFuture[])this.socketClients.values().stream().map(IRtspDataStream::getFuture).filter(Objects::nonNull).toArray(CompletableFuture[]::new);
        if (futures.length == 0) {
            return;
        }
        CompletableFuture<Void> all = CompletableFuture.allOf(futures);
        all.join();
    }

    protected boolean socketClientIsAllDone() {
        return this.socketClients.values().stream().map(IRtspDataStream::getFuture).allMatch(CompletableFuture::isDone);
    }

    public Object getObjLock() {
        return this.objLock;
    }

    public boolean isNeedAuthorization() {
        return this.needAuthorization;
    }

    public Map<Integer, IRtspDataStream> getSocketClients() {
        return this.socketClients;
    }

    public URI getUri() {
        return this.uri;
    }

    public DigestAuthenticator getAuthenticator() {
        return this.authenticator;
    }

    public List<ERtspMethod> getMethods() {
        return this.methods;
    }

    public RtspSdp getSdp() {
        return this.sdp;
    }

    public RtspTransport getTransport() {
        return this.transport;
    }

    public List<RtspRtpInfo> getRtpInfos() {
        return this.rtpInfos;
    }

    public RtspSessionInfo getSessionInfo() {
        return this.sessionInfo;
    }

    public RtspTrackInfo getTrackInfo() {
        return this.trackInfo;
    }

    public Consumer<String> getCommCallback() {
        return this.commCallback;
    }

    public Consumer<RawFrame> getFrameHandle() {
        return this.frameHandle;
    }

    public Runnable getDestroyHandle() {
        return this.destroyHandle;
    }

    public ERtspTransportProtocol getTransportProtocol() {
        return this.transportProtocol;
    }
}

