/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.rtsp.service;

import com.github.xingshuangs.iot.common.buff.ByteReadBuff;
import com.github.xingshuangs.iot.exceptions.RtspCommException;
import com.github.xingshuangs.iot.exceptions.SocketRuntimeException;
import com.github.xingshuangs.iot.net.client.TcpClientBasic;
import com.github.xingshuangs.iot.protocol.rtcp.model.RtcpBasePackage;
import com.github.xingshuangs.iot.protocol.rtcp.model.RtcpPackageBuilder;
import com.github.xingshuangs.iot.protocol.rtcp.service.RtcpDataStatistics;
import com.github.xingshuangs.iot.protocol.rtp.model.RtpPackage;
import com.github.xingshuangs.iot.protocol.rtp.service.IPayloadParser;
import com.github.xingshuangs.iot.protocol.rtsp.model.interleaved.RtspInterleaved;
import com.github.xingshuangs.iot.protocol.rtsp.service.IRtspDataStream;
import com.github.xingshuangs.iot.utils.HexUtil;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RtspInterleavedClient
implements IRtspDataStream {
    private static final Logger log = LoggerFactory.getLogger(RtspInterleavedClient.class);
    public static final Integer BUFFER_SIZE = 4096;
    private boolean terminal = false;
    private Consumer<byte[]> commCallback;
    private final IPayloadParser iPayloadParser;
    private final RtcpDataStatistics statistics = new RtcpDataStatistics();
    private int rtpVideoChannelNumber = 0;
    private int rtcpVideoChannelNumber = 1;
    private final TcpClientBasic rtspClient;
    private CompletableFuture<Void> future;
    private final ExecutorService executorService;

    public void setCommCallback(Consumer<byte[]> commCallback) {
        this.commCallback = commCallback;
    }

    public int getRtpVideoChannelNumber() {
        return this.rtpVideoChannelNumber;
    }

    public int getRtcpVideoChannelNumber() {
        return this.rtcpVideoChannelNumber;
    }

    public void setRtpVideoChannelNumber(int rtpVideoChannelNumber) {
        this.rtpVideoChannelNumber = rtpVideoChannelNumber;
    }

    public void setRtcpVideoChannelNumber(int rtcpVideoChannelNumber) {
        this.rtcpVideoChannelNumber = rtcpVideoChannelNumber;
    }

    public RtspInterleavedClient(IPayloadParser iPayloadParser, TcpClientBasic rtspClient) {
        this.iPayloadParser = iPayloadParser;
        this.rtspClient = rtspClient;
        this.executorService = Executors.newSingleThreadExecutor();
    }

    @Override
    public CompletableFuture<Void> getFuture() {
        return this.future;
    }

    @Override
    public void close() {
        this.executorService.shutdown();
        if (!this.terminal) {
            byte[] receiverAndByteContent = this.statistics.createReceiverAndByteContent();
            this.sendData(receiverAndByteContent);
            this.terminal = true;
        }
    }

    @Override
    public void triggerReceive() {
        this.future = CompletableFuture.runAsync(this::waitForReceiveData, this.executorService);
    }

    @Override
    public void sendData(byte[] data) {
        if (this.commCallback != null) {
            this.commCallback.accept(data);
        }
        this.rtspClient.write(data);
    }

    private void waitForReceiveData() {
        InetSocketAddress socketAddress = this.rtspClient.getSocketAddress();
        log.debug("[RTSP + TCP] Interleaved \u5f00\u542f\u5f02\u6b65\u63a5\u6536\u6570\u636e\u7ebf\u7a0b\uff0c\u8fdc\u7a0b\u7684IP[/{}:{}]", (Object)socketAddress.getAddress().getHostAddress(), (Object)socketAddress.getPort());
        while (!this.terminal) {
            try {
                RtspInterleaved interleaved;
                if (!this.rtspClient.checkConnected()) {
                    this.terminal = true;
                    break;
                }
                byte[] data = this.readFromServer();
                if (this.commCallback != null) {
                    this.commCallback.accept(data);
                }
                if ((interleaved = RtspInterleaved.fromBytes(data)).getChannelId() == this.rtpVideoChannelNumber) {
                    this.rtpVideoHandle(interleaved);
                    continue;
                }
                if (interleaved.getChannelId() != this.rtcpVideoChannelNumber) continue;
                this.rtcpVideoHandle(interleaved);
            }
            catch (SocketRuntimeException e) {
                log.error(e.getMessage());
                this.terminal = true;
                break;
            }
            catch (Exception e) {
                log.error(e.getMessage());
            }
        }
        log.debug("[RTSP + TCP] Interleaved \u5173\u95ed\u5f02\u6b65\u63a5\u6536\u6570\u636e\u7ebf\u7a0b\uff0c\u8fdc\u7a0b\u7684IP[/{}:{}]", (Object)socketAddress.getAddress().getHostAddress(), (Object)socketAddress.getPort());
    }

    private byte[] readFromServer() {
        byte[] header = new byte[4];
        while (header[0] != 36) {
            this.rtspClient.read(header, 0, 1, 1024, 0, true);
        }
        int readLength = this.rtspClient.read(header, 1, 3, 1024, 0, true);
        if (readLength != 3) {
            throw new RtspCommException("\u5934\u8bfb\u53d6\u957f\u5ea6\u6709\u8bef");
        }
        int offset = 4;
        int length = ByteReadBuff.newInstance(header, 2).getUInt16();
        byte[] total = new byte[length + offset];
        System.arraycopy(header, 0, total, 0, header.length);
        int read = this.rtspClient.read(total, offset, length, 1024, 0, true);
        if (offset + read != total.length) {
            log.error(HexUtil.toHexString(total));
            throw new RtspCommException("\u6570\u636e\u4f53\u8bfb\u53d6\u957f\u5ea6\u6709\u8bef\uff0c\u539f\u6765\u957f\u5ea6[" + total.length + "], \u73b0\u5728\u957f\u5ea6[" + (offset + read) + "]");
        }
        return total;
    }

    private void rtcpVideoHandle(RtspInterleaved interleaved) {
        List<RtcpBasePackage> basePackages = RtcpPackageBuilder.fromBytes(interleaved.getPayload());
        this.statistics.processRtcpPackage(basePackages);
    }

    private void rtpVideoHandle(RtspInterleaved interleaved) {
        RtpPackage rtp = RtpPackage.fromBytes(interleaved.getPayload());
        this.iPayloadParser.processPackage(rtp);
        this.statistics.processRtpPackage(rtp, this::sendData);
    }
}

