/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.rtsp.model.sdp;

import com.github.xingshuangs.iot.protocol.rtsp.model.sdp.RtspSdpMedia;
import com.github.xingshuangs.iot.protocol.rtsp.model.sdp.RtspSdpSession;
import com.github.xingshuangs.iot.utils.StringSpUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class RtspSdp {
    private RtspSdpSession session;
    private List<RtspSdpMedia> medias = new ArrayList<RtspSdpMedia>();

    public static RtspSdp fromString(String src) {
        if (src == null || src.equals("")) {
            throw new IllegalArgumentException("SDP\u89e3\u6790\u6570\u636e\u6e90\u9519\u8befsrc");
        }
        int startSession = src.indexOf("v=");
        List<Integer> flagAllIndexes = StringSpUtil.findFlagAllIndexes(src, "m=");
        RtspSdp sdp = new RtspSdp();
        if (startSession >= 0) {
            String sessionStr = src.substring(startSession, flagAllIndexes.get(0));
            sdp.session = RtspSdpSession.fromString(sessionStr);
        }
        if (flagAllIndexes.isEmpty()) {
            return sdp;
        }
        ArrayList<String> mediaStrList = new ArrayList<String>();
        for (int i = 0; i < flagAllIndexes.size() - 1; ++i) {
            mediaStrList.add(src.substring(flagAllIndexes.get(i), flagAllIndexes.get(i + 1)));
        }
        mediaStrList.add(src.substring(flagAllIndexes.get(flagAllIndexes.size() - 1)));
        sdp.medias = mediaStrList.stream().map(RtspSdpMedia::fromString).collect(Collectors.toList());
        return sdp;
    }

    public RtspSdpSession getSession() {
        return this.session;
    }

    public List<RtspSdpMedia> getMedias() {
        return this.medias;
    }

    public void setSession(RtspSdpSession session) {
        this.session = session;
    }

    public void setMedias(List<RtspSdpMedia> medias) {
        this.medias = medias;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RtspSdp)) {
            return false;
        }
        RtspSdp other = (RtspSdp)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RtspSdpSession this$session = this.getSession();
        RtspSdpSession other$session = other.getSession();
        if (this$session == null ? other$session != null : !((Object)this$session).equals(other$session)) {
            return false;
        }
        List<RtspSdpMedia> this$medias = this.getMedias();
        List<RtspSdpMedia> other$medias = other.getMedias();
        return !(this$medias == null ? other$medias != null : !((Object)this$medias).equals(other$medias));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RtspSdp;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RtspSdpSession $session = this.getSession();
        result = result * 59 + ($session == null ? 43 : ((Object)$session).hashCode());
        List<RtspSdpMedia> $medias = this.getMedias();
        result = result * 59 + ($medias == null ? 43 : ((Object)$medias).hashCode());
        return result;
    }

    public String toString() {
        return "RtspSdp(session=" + this.getSession() + ", medias=" + this.getMedias() + ")";
    }
}

