/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.rtsp.model.base;

import com.github.xingshuangs.iot.exceptions.RtspCommException;
import com.github.xingshuangs.iot.protocol.rtsp.model.base.RtspTransport;
import java.util.ArrayList;
import java.util.Map;

public class RtspClientPortTransport
extends RtspTransport {
    private Integer rtpClientPort;
    private Integer rtcpClientPort;
    private Integer rtpServerPort;
    private Integer rtcpServerPort;

    public RtspClientPortTransport() {
    }

    public RtspClientPortTransport(Integer rtpClientPort, Integer rtcpClientPort) {
        this.protocol = "RTP/AVP";
        this.castMode = "unicast";
        this.rtpClientPort = rtpClientPort;
        this.rtcpClientPort = rtcpClientPort;
    }

    public static RtspClientPortTransport fromString(String src) {
        if (src == null || src.equals("")) {
            throw new IllegalArgumentException("RtspTransport\u90e8\u5206\u6570\u636e\u89e3\u6790\u9519\u8bef");
        }
        RtspClientPortTransport transport = new RtspClientPortTransport();
        String[] split = src.split(";");
        transport.protocol = split[0];
        transport.castMode = split[1];
        Map<String, String> map = transport.getMap(split);
        if (map.containsKey("client_port")) {
            String clientPort1 = map.get("client_port").trim();
            int clientPortIndex = clientPort1.indexOf("-");
            transport.rtpClientPort = Integer.parseInt(clientPort1.substring(0, clientPortIndex));
            transport.rtcpClientPort = Integer.parseInt(clientPort1.substring(clientPortIndex + 1));
        }
        if (map.containsKey("server_port")) {
            String serverPort1 = map.get("server_port").trim();
            int serverPortIndex = serverPort1.indexOf("-");
            transport.rtpServerPort = Integer.parseInt(serverPort1.substring(0, serverPortIndex));
            transport.rtcpServerPort = Integer.parseInt(serverPort1.substring(serverPortIndex + 1));
        }
        if (map.containsKey("ssrc")) {
            transport.ssrc = map.get("ssrc").trim();
        }
        if (map.containsKey("mode")) {
            transport.mode = map.get("mode").replace("\"", "").trim();
        }
        return transport;
    }

    @Override
    public String toString() {
        if (this.protocol == null || this.protocol.equals("")) {
            throw new RtspCommException("RtspTransport\u7684protocol\u5f02\u5e38");
        }
        if (this.castMode == null || this.castMode.equals("")) {
            throw new RtspCommException("RtspTransport\u7684castMode\u5f02\u5e38");
        }
        ArrayList<String> res = new ArrayList<String>();
        res.add(this.protocol);
        res.add(this.castMode);
        res.add(String.format("client_port=%d-%d", this.rtpClientPort, this.rtcpClientPort));
        if (this.rtpServerPort != null && this.rtcpServerPort != null) {
            res.add(String.format("server_port=%d-%d", this.rtpServerPort, this.rtcpServerPort));
        }
        if (this.ssrc != null && !this.ssrc.equals("")) {
            res.add(String.format("ssrc=%s", this.ssrc));
        }
        if (this.mode != null && !this.mode.equals("")) {
            res.add(String.format("mode=\"%s\"", this.mode));
        }
        return String.join((CharSequence)";", res);
    }

    public Integer getRtpClientPort() {
        return this.rtpClientPort;
    }

    public Integer getRtcpClientPort() {
        return this.rtcpClientPort;
    }

    public Integer getRtpServerPort() {
        return this.rtpServerPort;
    }

    public Integer getRtcpServerPort() {
        return this.rtcpServerPort;
    }

    public void setRtpClientPort(Integer rtpClientPort) {
        this.rtpClientPort = rtpClientPort;
    }

    public void setRtcpClientPort(Integer rtcpClientPort) {
        this.rtcpClientPort = rtcpClientPort;
    }

    public void setRtpServerPort(Integer rtpServerPort) {
        this.rtpServerPort = rtpServerPort;
    }

    public void setRtcpServerPort(Integer rtcpServerPort) {
        this.rtcpServerPort = rtcpServerPort;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RtspClientPortTransport)) {
            return false;
        }
        RtspClientPortTransport other = (RtspClientPortTransport)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$rtpClientPort = this.getRtpClientPort();
        Integer other$rtpClientPort = other.getRtpClientPort();
        if (this$rtpClientPort == null ? other$rtpClientPort != null : !((Object)this$rtpClientPort).equals(other$rtpClientPort)) {
            return false;
        }
        Integer this$rtcpClientPort = this.getRtcpClientPort();
        Integer other$rtcpClientPort = other.getRtcpClientPort();
        if (this$rtcpClientPort == null ? other$rtcpClientPort != null : !((Object)this$rtcpClientPort).equals(other$rtcpClientPort)) {
            return false;
        }
        Integer this$rtpServerPort = this.getRtpServerPort();
        Integer other$rtpServerPort = other.getRtpServerPort();
        if (this$rtpServerPort == null ? other$rtpServerPort != null : !((Object)this$rtpServerPort).equals(other$rtpServerPort)) {
            return false;
        }
        Integer this$rtcpServerPort = this.getRtcpServerPort();
        Integer other$rtcpServerPort = other.getRtcpServerPort();
        return !(this$rtcpServerPort == null ? other$rtcpServerPort != null : !((Object)this$rtcpServerPort).equals(other$rtcpServerPort));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RtspClientPortTransport;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $rtpClientPort = this.getRtpClientPort();
        result = result * 59 + ($rtpClientPort == null ? 43 : ((Object)$rtpClientPort).hashCode());
        Integer $rtcpClientPort = this.getRtcpClientPort();
        result = result * 59 + ($rtcpClientPort == null ? 43 : ((Object)$rtcpClientPort).hashCode());
        Integer $rtpServerPort = this.getRtpServerPort();
        result = result * 59 + ($rtpServerPort == null ? 43 : ((Object)$rtpServerPort).hashCode());
        Integer $rtcpServerPort = this.getRtcpServerPort();
        result = result * 59 + ($rtcpServerPort == null ? 43 : ((Object)$rtcpServerPort).hashCode());
        return result;
    }
}

