/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.rtp.model.payload;

import com.github.xingshuangs.iot.common.IObjectByteArray;
import com.github.xingshuangs.iot.common.buff.ByteReadBuff;
import com.github.xingshuangs.iot.protocol.rtp.enums.EH264NaluType;
import com.github.xingshuangs.iot.utils.BooleanUtil;

public class H264NaluHeader
implements IObjectByteArray {
    private boolean forbiddenZeroBit;
    private int nri;
    private EH264NaluType type;

    @Override
    public int byteArrayLength() {
        return 1;
    }

    @Override
    public byte[] toByteArray() {
        byte res = (byte)(BooleanUtil.setBit(7, this.forbiddenZeroBit) | this.nri << 5 & 0x60 | this.type.getCode() & 0x1F);
        return new byte[]{res};
    }

    public static H264NaluHeader fromBytes(byte[] data) {
        return H264NaluHeader.fromBytes(data, 0);
    }

    public static H264NaluHeader fromBytes(byte[] data, int offset) {
        if (data.length < 1) {
            throw new IndexOutOfBoundsException("\u89e3\u6790header\u65f6\uff0c\u5b57\u8282\u6570\u7ec4\u957f\u5ea6\u4e0d\u591f");
        }
        ByteReadBuff buff = new ByteReadBuff(data, offset);
        H264NaluHeader res = new H264NaluHeader();
        byte aByte = buff.getByte();
        res.forbiddenZeroBit = BooleanUtil.getValue(aByte, 7);
        res.nri = aByte >> 5 & 3;
        res.type = EH264NaluType.from(aByte & 0x1F);
        return res;
    }

    public boolean isForbiddenZeroBit() {
        return this.forbiddenZeroBit;
    }

    public int getNri() {
        return this.nri;
    }

    public EH264NaluType getType() {
        return this.type;
    }

    public void setForbiddenZeroBit(boolean forbiddenZeroBit) {
        this.forbiddenZeroBit = forbiddenZeroBit;
    }

    public void setNri(int nri) {
        this.nri = nri;
    }

    public void setType(EH264NaluType type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof H264NaluHeader)) {
            return false;
        }
        H264NaluHeader other = (H264NaluHeader)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isForbiddenZeroBit() != other.isForbiddenZeroBit()) {
            return false;
        }
        if (this.getNri() != other.getNri()) {
            return false;
        }
        EH264NaluType this$type = this.getType();
        EH264NaluType other$type = other.getType();
        return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
    }

    protected boolean canEqual(Object other) {
        return other instanceof H264NaluHeader;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isForbiddenZeroBit() ? 79 : 97);
        result = result * 59 + this.getNri();
        EH264NaluType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        return result;
    }

    public String toString() {
        return "H264NaluHeader(forbiddenZeroBit=" + this.isForbiddenZeroBit() + ", nri=" + this.getNri() + ", type=" + (Object)((Object)this.getType()) + ")";
    }
}

