/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.rtp.model.payload;

import com.github.xingshuangs.iot.common.IObjectByteArray;
import com.github.xingshuangs.iot.common.buff.ByteReadBuff;
import com.github.xingshuangs.iot.protocol.rtp.enums.EH264NaluType;
import com.github.xingshuangs.iot.utils.BooleanUtil;

public class H264NaluFuHeader
implements IObjectByteArray {
    private boolean start;
    private boolean end;
    private boolean reserve;
    private EH264NaluType type;

    @Override
    public int byteArrayLength() {
        return 1;
    }

    @Override
    public byte[] toByteArray() {
        byte res = (byte)(BooleanUtil.setBit(7, this.start) | BooleanUtil.setBit(6, this.end) | BooleanUtil.setBit(5, this.reserve) | this.type.getCode() & 0x1F);
        return new byte[]{res};
    }

    public static H264NaluFuHeader fromBytes(byte[] data) {
        return H264NaluFuHeader.fromBytes(data, 0);
    }

    public static H264NaluFuHeader fromBytes(byte[] data, int offset) {
        if (data.length < 1) {
            throw new IndexOutOfBoundsException("\u89e3\u6790H264NaluFuHeader\u65f6\uff0c\u5b57\u8282\u6570\u7ec4\u957f\u5ea6\u4e0d\u591f");
        }
        ByteReadBuff buff = new ByteReadBuff(data, offset);
        H264NaluFuHeader res = new H264NaluFuHeader();
        byte aByte = buff.getByte();
        res.start = BooleanUtil.getValue(aByte, 7);
        res.end = BooleanUtil.getValue(aByte, 6);
        res.reserve = BooleanUtil.getValue(aByte, 5);
        res.type = EH264NaluType.from(aByte & 0x1F);
        return res;
    }

    public boolean isStart() {
        return this.start;
    }

    public boolean isEnd() {
        return this.end;
    }

    public boolean isReserve() {
        return this.reserve;
    }

    public EH264NaluType getType() {
        return this.type;
    }

    public void setStart(boolean start) {
        this.start = start;
    }

    public void setEnd(boolean end) {
        this.end = end;
    }

    public void setReserve(boolean reserve) {
        this.reserve = reserve;
    }

    public void setType(EH264NaluType type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof H264NaluFuHeader)) {
            return false;
        }
        H264NaluFuHeader other = (H264NaluFuHeader)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isStart() != other.isStart()) {
            return false;
        }
        if (this.isEnd() != other.isEnd()) {
            return false;
        }
        if (this.isReserve() != other.isReserve()) {
            return false;
        }
        EH264NaluType this$type = this.getType();
        EH264NaluType other$type = other.getType();
        return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
    }

    protected boolean canEqual(Object other) {
        return other instanceof H264NaluFuHeader;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isStart() ? 79 : 97);
        result = result * 59 + (this.isEnd() ? 79 : 97);
        result = result * 59 + (this.isReserve() ? 79 : 97);
        EH264NaluType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        return result;
    }

    public String toString() {
        return "H264NaluFuHeader(start=" + this.isStart() + ", end=" + this.isEnd() + ", reserve=" + this.isReserve() + ", type=" + (Object)((Object)this.getType()) + ")";
    }
}

