/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.rtp.model.payload;

import com.github.xingshuangs.iot.exceptions.RtpCommException;
import com.github.xingshuangs.iot.protocol.rtp.model.payload.H264NaluBase;
import com.github.xingshuangs.iot.protocol.rtp.model.payload.H264NaluFuA;
import com.github.xingshuangs.iot.protocol.rtp.model.payload.H264NaluFuB;
import com.github.xingshuangs.iot.protocol.rtp.model.payload.H264NaluHeader;
import com.github.xingshuangs.iot.protocol.rtp.model.payload.H264NaluMtap16;
import com.github.xingshuangs.iot.protocol.rtp.model.payload.H264NaluMtap24;
import com.github.xingshuangs.iot.protocol.rtp.model.payload.H264NaluSingle;
import com.github.xingshuangs.iot.protocol.rtp.model.payload.H264NaluStapA;
import com.github.xingshuangs.iot.protocol.rtp.model.payload.H264NaluStapB;

public class H264NaluBuilder {
    private H264NaluBuilder() {
    }

    public static H264NaluBase parsePackage(byte[] data) {
        return H264NaluBuilder.parsePackage(data, 0);
    }

    public static H264NaluBase parsePackage(byte[] data, int offset) {
        H264NaluHeader header = H264NaluHeader.fromBytes(data, offset);
        switch (header.getType()) {
            case SEI: 
            case SPS: 
            case PPS: 
            case AUD: 
            case NON_IDR_SLICE: 
            case IDR_SLICE: {
                return H264NaluSingle.fromBytes(data, offset);
            }
            case STAP_A: {
                return H264NaluStapA.fromBytes(data, offset);
            }
            case STAP_B: {
                return H264NaluStapB.fromBytes(data, offset);
            }
            case FU_A: {
                return H264NaluFuA.fromBytes(data, offset);
            }
            case FU_B: {
                return H264NaluFuB.fromBytes(data, offset);
            }
            case MTAP16: {
                return H264NaluMtap16.fromBytes(data, offset);
            }
            case MTAP24: {
                return H264NaluMtap24.fromBytes(data, offset);
            }
        }
        throw new RtpCommException("\u65e0\u6cd5\u8bc6\u522b\u7c7b\u578b");
    }
}

