/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.rtcp.model;

import com.github.xingshuangs.iot.common.IObjectByteArray;
import com.github.xingshuangs.iot.common.buff.ByteReadBuff;
import com.github.xingshuangs.iot.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.rtcp.enums.ERtcpSdesItemType;

public class RtcpSdesItem
implements IObjectByteArray {
    private ERtcpSdesItemType type;
    private int length;
    private String text = "";

    @Override
    public int byteArrayLength() {
        return 2 + this.text.length();
    }

    @Override
    public byte[] toByteArray() {
        return ByteWriteBuff.newInstance(2 + this.text.length()).putByte(this.type.getCode()).putByte(this.length).putString(this.text).getData();
    }

    public static RtcpSdesItem fromBytes(byte[] data) {
        return RtcpSdesItem.fromBytes(data, 0);
    }

    public static RtcpSdesItem fromBytes(byte[] data, int offset) {
        if (data.length < 2) {
            throw new IndexOutOfBoundsException("\u89e3\u6790RtcpSdesItem\u65f6\uff0c\u5b57\u8282\u6570\u7ec4\u957f\u5ea6\u4e0d\u591f");
        }
        ByteReadBuff buff = new ByteReadBuff(data, offset);
        RtcpSdesItem res = new RtcpSdesItem();
        res.type = ERtcpSdesItemType.from(buff.getByte());
        res.length = buff.getByteToInt();
        res.text = buff.getString(res.length);
        return res;
    }

    public ERtcpSdesItemType getType() {
        return this.type;
    }

    public int getLength() {
        return this.length;
    }

    public String getText() {
        return this.text;
    }

    public void setType(ERtcpSdesItemType type) {
        this.type = type;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void setText(String text) {
        this.text = text;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RtcpSdesItem)) {
            return false;
        }
        RtcpSdesItem other = (RtcpSdesItem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getLength() != other.getLength()) {
            return false;
        }
        ERtcpSdesItemType this$type = this.getType();
        ERtcpSdesItemType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        return !(this$text == null ? other$text != null : !this$text.equals(other$text));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RtcpSdesItem;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getLength();
        ERtcpSdesItemType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        return result;
    }

    public String toString() {
        return "RtcpSdesItem(type=" + (Object)((Object)this.getType()) + ", length=" + this.getLength() + ", text=" + this.getText() + ")";
    }
}

