/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.mp4.model;

import com.github.xingshuangs.iot.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.mp4.enums.EMp4Type;
import com.github.xingshuangs.iot.protocol.mp4.model.Mp4Box;
import com.github.xingshuangs.iot.protocol.mp4.model.Mp4SampleData;
import com.github.xingshuangs.iot.protocol.mp4.model.Mp4SampleFlag;
import java.util.List;

public class Mp4SdtpBox
extends Mp4Box {
    private final byte[] reserved;
    private final byte[] flags;

    public Mp4SdtpBox(List<Mp4SampleData> samples) {
        this.mp4Type = EMp4Type.SDTP;
        this.reserved = new byte[4];
        this.flags = new byte[samples.size()];
        for (int i = 0; i < samples.size(); ++i) {
            Mp4SampleFlag sampleFlag = samples.get(i).getFlags();
            this.flags[i] = (byte)(sampleFlag.getDependedOn() << 4 | sampleFlag.getIsDependedOn() << 2 | sampleFlag.getHasRedundancy());
        }
    }

    @Override
    public int byteArrayLength() {
        return 12 + this.flags.length;
    }

    @Override
    public byte[] toByteArray() {
        int size = this.byteArrayLength();
        return ByteWriteBuff.newInstance(size).putInteger(size).putBytes(this.mp4Type.getByteArray()).putBytes(this.reserved).putBytes(this.flags).getData();
    }
}

