/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.mp4.model;

import com.github.xingshuangs.iot.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.mp4.enums.EMp4Type;
import com.github.xingshuangs.iot.protocol.mp4.model.Mp4Box;
import com.github.xingshuangs.iot.protocol.mp4.model.Mp4TrackInfo;
import com.github.xingshuangs.iot.protocol.mp4.model.Mp4TrexBox;
import java.util.List;
import java.util.stream.Collectors;

public class Mp4MvexBox
extends Mp4Box {
    private final List<Mp4Box> boxes;

    public Mp4MvexBox(List<Mp4TrackInfo> trackInfos) {
        this.mp4Type = EMp4Type.MVEX;
        this.boxes = trackInfos.stream().map(x -> new Mp4TrexBox(x.getId())).collect(Collectors.toList());
    }

    @Override
    public int byteArrayLength() {
        return 8 + this.boxes.stream().mapToInt(Mp4Box::byteArrayLength).sum();
    }

    @Override
    public byte[] toByteArray() {
        int size = this.byteArrayLength();
        ByteWriteBuff buff = ByteWriteBuff.newInstance(size).putInteger(size).putBytes(this.mp4Type.getByteArray());
        for (Mp4Box box : this.boxes) {
            buff.putBytes(box.toByteArray());
        }
        return buff.getData();
    }
}

