/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.mp4.model;

import com.github.xingshuangs.iot.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.mp4.enums.EMp4Type;
import com.github.xingshuangs.iot.protocol.mp4.model.Mp4Box;
import com.github.xingshuangs.iot.protocol.mp4.model.Mp4MfhdBox;
import com.github.xingshuangs.iot.protocol.mp4.model.Mp4TrackInfo;
import com.github.xingshuangs.iot.protocol.mp4.model.Mp4TrafBox;

public class Mp4MoofBox
extends Mp4Box {
    private final Mp4MfhdBox mfhdBox;
    private final Mp4TrafBox trafBox;

    public Mp4MoofBox(long sequenceNumber, long baseMediaDecodeTime, Mp4TrackInfo trackInfo) {
        this.mp4Type = EMp4Type.MOOF;
        this.mfhdBox = new Mp4MfhdBox(sequenceNumber);
        this.trafBox = new Mp4TrafBox(baseMediaDecodeTime, trackInfo);
    }

    @Override
    public int byteArrayLength() {
        return 8 + this.mfhdBox.byteArrayLength() + this.trafBox.byteArrayLength();
    }

    @Override
    public byte[] toByteArray() {
        int size = this.byteArrayLength();
        return ByteWriteBuff.newInstance(size).putInteger(size).putBytes(this.mp4Type.getByteArray()).putBytes(this.mfhdBox.toByteArray()).putBytes(this.trafBox.toByteArray()).getData();
    }
}

